/* MissingGraphIcon.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gui.icons;

import java.awt.Component;
import java.awt.Graphics;

import org.grinvin.GraphBundleView;

/**
 * Icon that represents a missing graph that could not be loaded.
 */
public class MissingGraphIcon extends AbstractGraphIcon {
    
    //
    private int size;
    
    //
    private GraphBundleView bundle;
    
    /** Creates a new instance of MissingGraphIcon */
    public MissingGraphIcon(GraphBundleView bundle, int size) {
        this.bundle = bundle;
        this.size = size;
    }
        
    // implements Icon
    public int getIconHeight() {
        return size;
    }
    
    // implements Icon
    public int getIconWidth() {
        return size;
    }
    
    public void paintIcon(Component c, Graphics g, int x, int y) {
        /*
        Graphics2D g2 = (Graphics2D)g.create ();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
            RenderingHints.VALUE_ANTIALIAS_ON);
        g2.translate (x, y);
        Font font = new Font("Serif", Font.BOLD, 24);
        g2.setFont(font);
        //g2.drawString("?", x + (size/2), y + (size/2));
        g2.drawString("?", (size/2), (size/2));
        */
    }

}
