/* GraphFactoryIndexView.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.help;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.help.HelpSet;
import javax.help.IndexItem;
import javax.help.IndexView;
import javax.help.Map;
import javax.help.Map.ID;
import javax.swing.tree.DefaultMutableTreeNode;


/**
 * Loads an overview of the graph factories and places them in a index tree
 * that is mergeable with the GrInvIn help index tree.
 */
public class GraphFactoryIndexView extends IndexView {
    
    /**
     * Creates a new instance of GraphFactoryIndexView
     */
    public GraphFactoryIndexView(){
        super(HelpManager.getHelpSet(), HelpManager.getResourceBundle().getString("index.name"), HelpManager.getResourceBundle().getString("index.label"), HelpManager.getHelpSet().getLocale(), new Hashtable());
    }
    
    public GraphFactoryIndexView(HelpSet hs, String name, String Label, Hashtable params){
        this();
    }
    
    public GraphFactoryIndexView(HelpSet hs, String name, String Label, Locale locale, Hashtable params){
        this();
    }
    
    public String getMergeType(){
        return "javax.help.SortMerge";
    }
    
    public DefaultMutableTreeNode getDataAsTree() {
        IndexItem itemgrinvin = new IndexItem();
        itemgrinvin.setName(HelpManager.getResourceBundle().getString("index.item.grinvin"));
        DefaultMutableTreeNode grinvin = new DefaultMutableTreeNode(itemgrinvin);
        for(Enumeration e = GraphFactoryMap.getInstance().getAllIDs(); e.hasMoreElements(); ){
            Map.ID id = (Map.ID)e.nextElement();
            String stringId = id.id;
            IndexItem item = new IndexItem(id, null, null);
            item.setName(GraphFactoryMap.getInstance().getGraphFactoryNameForID(stringId) + " (" + HelpManager.getResourceBundle().getString("factory") + ")");
            grinvin.add(new DefaultMutableTreeNode(item, false));
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(null);
        root.add(grinvin);
        return root;
    }
    
}
