/* GraphFactoryMap.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.help;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.help.HelpSet;
import javax.help.Map;
import javax.help.Map.ID;

import org.grinvin.factories.graphs.GraphFactory;
import org.grinvin.factories.graphs.GraphFactoryManager;

/**
 * Provides the mapping of the context-sensitive help ID of graphfactories and
 * the URL for their help page.
 */
public class GraphFactoryMap implements Map {
    
    // TODO: has lots of code in common with InvariantMap - please refactor
    
    private static final GraphFactoryMap SINGLETON = new GraphFactoryMap();
    
    public static GraphFactoryMap getInstance() {
        return SINGLETON;
    }
    
    /**
     * Maps an graph factory identifier to the corresponding name of the graph factory.
     */
    private final java.util.Map<String, String> graphfactorynames;
    
    public String getGraphFactoryNameForID(String id) {
        return graphfactorynames.get(id);
    }
    
    private GraphFactoryMap(){
        graphfactoryids = new ArrayList<String>();
        graphfactorynames = new HashMap<String, String>();
        for (String id: GraphFactoryManager.getInstance().getIds()) {
            GraphFactory factory = GraphFactoryManager.getInstance().getGraphFactory(id);
            graphfactoryids.add(id);
            graphfactorynames.put(id, factory.getLongName());
        }
    }
    
    private final List<String> graphfactoryids;
    
    public boolean isValidID(String string, HelpSet helpSet) {
        return graphfactoryids.contains(string);
    }
    
    public Enumeration getAllIDs() {
        Vector<Map.ID> ids = new Vector<Map.ID>(); // NOPMD
        for(int i = 0; i<graphfactoryids.size(); i++)
            ids.add(ID.create(graphfactoryids.get(i), HelpManager.getHelpSet()));
        return ids.elements();
    }
    
    public URL getURLFromID(Map.ID iD) throws MalformedURLException {
        String id = iD.id;
        if(graphfactoryids.contains(id))
            return new URL("graphfactory:" + id);
        else
            return null;
    }
    
    public boolean isID(URL uRL) {
        return graphfactoryids.contains(uRL.getHost());
    }
    
    public Map.ID getIDFromURL(URL uRL) {
        if(uRL==null) return null;
        String id = uRL.getHost();
        if(graphfactoryids.contains(id))
            return ID.create(id, HelpManager.getHelpSet());
        else
            return null;
    }
    
    public Map.ID getClosestID(URL uRL) {
        return getIDFromURL(uRL);
    }
    
    public Enumeration getIDs(URL uRL) {
        Vector<String> ids = new Vector<String>(); // NOPMD
        ids.add(getIDFromURL(uRL).id);
        return ids.elements();
    }
}
