/* HelpURIResolver.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.help;

import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.Enumeration;
import javax.help.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

/**
 * Loads an xml-file containing the URLs for all the helpsubjects.
 */
public class HelpURIResolver implements URIResolver {
    
    /** Creates a new instance of HelpURIResolver */
    public HelpURIResolver() {
    }
    
    public Source resolve(String href, String base) throws TransformerException {
        if("grinvinmap".equals (href)){
            Document doc = new Document();
            Element root = new Element("map");
            Map map = HelpManager.getHelpSet().getCombinedMap();
            for(Enumeration e = map.getAllIDs(); e.hasMoreElements(); ){
                Map.ID id = (Map.ID)e.nextElement();
                try {
                    Element entry = new Element("entry");
                    entry.setAttribute("key", id.getIDString());
                    entry.setText(map.getURLFromID(id).toString());
                    root.addContent(entry);
                } catch (MalformedURLException ex) {
                    ex.printStackTrace();
                }
            }
            doc.setRootElement(root);
            XMLOutputter out = new XMLOutputter();
            String output = out.outputString(doc);
            return new StreamSource(new StringReader(output));
        } else {
            return null;
        }
        
    }
    
}
