/* InvariantComputer.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants;

import org.grinvin.GraphBundleView;

/**
 * Implemented by all invariant computers. Every invariant computer 
 * provides a means of computing the value of one specific invariant for
 * any graph we care to hand it.<p>
 * Invariant computers are uniquely idenitified by a string identifier and
 * a version string.
 */
public interface InvariantComputer {
 
    /**
     * Returns the identifier for the invariant computed by this
     * object.
     */
    public String getInvariantId();
    
    /**
     * Compute the value of the associated invariant for the given graph. 
     * Multiple parallel calls of this method for different graphs might occur
     * and must not return incorrect results.
     * @param bundle represents the graph for which the invariant
     * must be computed.
     * @return the value of the invariant encapsulated in an invariant value of the correct type, i.e., the type
     * associated with the invariant.
     */
    public InvariantValue compute(GraphBundleView bundle) throws Exception;

    /**
     * Return the universally unique identifier for this object.
     * For most invariant computers this is the fully qualified class name
     * of the implementation class.
     * 
     * @return the unique string that identifies this InvariantComputer
     */
    public String getId();
    
    /**
     * Return the version of this computer.
     * @return the version of this InvariantComputer
     */
    public String getVersion();
    
}
