/* AbstractInvariantComputer.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants.computers;

import org.grinvin.invariants.InvariantComputer;

/**
 * Abstract superclass used by most invariant computers. Provides a standard
 * identifier and version.
 */
public abstract class AbstractInvariantComputer implements InvariantComputer {
    
    //
    protected AbstractInvariantComputer() {
        initId();
    }
    
    //
    private String factoryId;
    
    /**
     * The id of an invariant computer is usually the same as its fully qualified class name.
     * For reasons of backwards compatibility however, ids of a class in one of the subpackages
     * of <code>org.grinvin.invariants.computers</code>
     * are given an id as if they resided
     * in the package <code>org.grinvin.invariants</code>.
     */
    public String getId() {
        return factoryId;
    }
    
    //
    private void initId() {
        String id = getClass().getName();
        if (id.startsWith("org.grinvin.invariants.")) {
            int pos = id.lastIndexOf('.');
            this.factoryId = "org.grinvin.invariants" + id.substring(pos);
        } else
            this.factoryId = id;
    }
    
    /**
     * {@inheritDoc}<p>
     * This implementation returns the string <code>1.0</code>.
     */
    public String getVersion() {
        return "1.0";
    }
    
}
