/* Bounds.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.io;

import java.awt.Dimension;
import java.awt.Point;
import org.jdom.Element;

/**
 * Class to handle loading and saving of location and size information. It is
 * currently used by the {@link org.grinvin.workspace.DefaultWindowWrapper} to save its window information to jdom.
 */
public class Bounds {
    
    //
    public final Point location;
    
    //
    public final Dimension size;
    
    //TODO: handle not existing bounds gracefully: default values
    public Bounds(Element element) throws IOFormatException {
        
        Element child = element.getChild("bounds");
        
        if (child == null)
            throw new IOFormatException("expected <bounds> element");
        
        int x = Integer.parseInt(child.getAttributeValue("x"));
        int y = Integer.parseInt(child.getAttributeValue("y"));
        int height = Integer.parseInt(child.getAttributeValue("height"));
        int width = Integer.parseInt(child.getAttributeValue("width"));
        
        location = new Point(x, y);
        size = new Dimension(width, height);
    }
    
    //
    public Bounds(Point location, Dimension size) {
        this.location = location;
        this.size = size;
    }
    
    //
    public Element toElement() {
        Element result = new Element("bounds");
        
        result.setAttribute("x", Integer.toString(location.x));
        result.setAttribute("y", Integer.toString(location.y));
        
        result.setAttribute("height", Integer.toString(size.height));
        result.setAttribute("width", Integer.toString(size.width));
        
        return result;
    }
    
}
