/* InvariantValuesLoader.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.io;

import java.io.InputStream;

import org.grinvin.GraphBundle;
import org.grinvin.invariants.InvariantValue;
import org.grinvin.invariants.UnknownInvariantException;
import org.grinvin.invariants.UnknownInvariantTypeException;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/**
 * Loader for the computed values of a saved GraphBundle
 */
public class InvariantValuesLoader {
    
    //
    private GraphBundle bundle;
    
    public InvariantValuesLoader(GraphBundle bundle) {
        this.bundle = bundle;
    }
    
    //TODO: check exceptions
    /**
     * Load the values of the invariants to the given graphbundle
     * @param element The Element containing the invariant values
     */
    private void toInvariantValues(Element element) throws IOFormatException {
        if (! "invariantvalues".equals(element.getName()))
            throw new IOFormatException("Expected <invariantvalues> element");
        for (Object obj : element.getChildren ("invariantvalue")) {
            try {
                InvariantValue value = InvariantValue.fromElement((Element)obj);
                bundle.addInvariantValue(value);
            } catch (UnknownInvariantException e) {
                // ignore
                // TODO: please log this
            } catch (UnknownInvariantTypeException e) {
                // ignore
                // TODO: please log this
            }
        }
    }
    
    /**
     * Load the invariant values from the given InputStream
     * @param input the InputStream
     */
    public void load(InputStream input) throws IOFormatException {
        try {
            Document doc = new SAXBuilder().build(input);
            toInvariantValues(doc.getRootElement());
        } catch (JDOMException ex) {
            throw new IOFormatException("XML parse error", ex);
        } catch (Exception ex) {
            //TODO: check this
            throw new IOFormatException("Missing invariant", ex);
        }
    }
    
}
