/* DefaultGraphListsModel.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list;

import be.ugent.caagt.swirl.lists.TypedListModel;
import java.text.MessageFormat;
import java.util.ResourceBundle;

import org.grinvin.graphbrowser.GraphBrowserWindow;

/**
 * Model that contains a list of available graph lists and the current sequence number.
 */
public class DefaultGraphListsModel implements GraphListsModel {
    
    //
    private static final ResourceBundle BUNDLE
            = ResourceBundle.getBundle("org.grinvin.list.graphlistswindow");
  
    //
    private TypedListModel<GraphBrowserWindow> model;
    
    //
    private int listSequenceNumber;
    
    /**
     * Return the current sequence number, used for
     * the name of a new list to be added to this window.
     */
    public int getListSequenceNumber() {
        return listSequenceNumber;
    }
    
    /**
     * Set the list sequence number.
     */
    public void setListSequenceNumber(int listSequenceNumber) {
        this.listSequenceNumber = listSequenceNumber;
    }
    
    /**
     * Return the list model for this window.
     */
    public TypedListModel<GraphBrowserWindow> getListModel() {
        return this.model;
    }
    
    /**
     * Create a new graph browser window and add it to this list. The list
     * sequence number is used for the name of this list, and is incremented.
     * @return the new window
     */
    public GraphBrowserWindow createNewGraphBrowserWindow() {
        String name = MessageFormat.format(BUNDLE.getString("newgraphlistname.text"), listSequenceNumber);
        listSequenceNumber ++;
        GraphInvariantListModel list = new DefaultGraphInvariantListModel();
        list.setName(name);
        GraphBrowserWindow result = new GraphBrowserWindow(list);
        model.add(result);
        return result;
    }
    
    /**
     * Create a new graph lists model, backed by the given listmodel.
     */
    public DefaultGraphListsModel(TypedListModel<GraphBrowserWindow> model) {
        this.model = model;
        this.listSequenceNumber = 1;
    }
}
