/* DefaultInvariantListModel.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list;

import be.ugent.caagt.swirl.lists.ArrayListModel;

import java.util.Collection;

import org.grinvin.invariants.Invariant;

/**
 * Default implementation of {@link InvariantListModel}.
 */
public class DefaultInvariantListModel extends ArrayListModel<Invariant> implements InvariantListModel {
    
    //
    public void addInvariantListModelListener(InvariantListModelListener listener) {
        this.addListDataListener(listener);
    }
    
    //
    public void removeInvariantListModelListener(InvariantListModelListener listener) {
        this.addListDataListener(listener);
    }
    
    //
    private boolean dirty = false;
    
    public boolean isDirty() {
        return dirty;
    }
    
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
    
    //
    public void add(int index, Invariant element) {
        setDirty(true);
        super.add(index, element);
    }
    
    //
    public boolean add(Invariant element) {
        setDirty(true);
        return super.add(element);
    }
    
    //
    public boolean addAll(Collection<? extends Invariant> collection) {
        setDirty(true);
        return super.addAll(collection);
    }
    
    //
    public boolean addAll(int index, Collection<? extends Invariant> collection) {
        setDirty(true);
        return super.addAll(index, collection);
    }

    //
    public void clear() {
        setDirty(true);
        super.clear();
    }
    
    //
    public boolean remove(Object obj) {
        setDirty(true);
        return super.remove(obj);
    }
    
    //
    public Invariant remove(int index) {
        setDirty(true);
        return super.remove(index);
    }
    
    //
    protected void removeRange(int fromIndex, int toIndex) {
        setDirty(true);
        super.removeRange(fromIndex, toIndex);
    }
    
    //
    public Invariant set(int index, Invariant element) {
        setDirty(true);
        return super.set(index, element);
    }

    
}
