/* GraphList.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list;

import java.net.URI;
import java.util.List;

/**
 * Interface to ease the use of graph lists.
 */
public interface GraphList extends List<GraphListElement>, HasName {
    
    /**
     * Get the uri.
     * @return the uri, or null
     */
    public URI getURI();
    
    /**
     * Set the URI of this GraphListElement. Use this to set the URI when the
     * bundle has been saved.
     * @param uri the URI
     */
    public void setURI(URI uri);
    
    //
    public boolean containsSessionElements();

    //
    public boolean isDirty();
    
    //
    public void setDirty(boolean dirty);
    
}
