/* GraphListElementDropHandler.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list;

import be.ugent.caagt.swirl.dnd.DropHandler;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

import org.grinvin.graphbrowser.HasGraphList;

/**
 * Allows (multiple) graph elements to be dropped onto a component. A component
 * which uses this handler should be of type {@link org.grinvin.graphbrowser.HasGraphList}.
 */
public class GraphListElementDropHandler implements DropHandler {
    // TODO: make this an inner class of GraphListElement?
    
    //
    private static final Class GRAPH_LIST_ELEMENT = GraphListElement.class;
    
    //
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.grinvin.list.resources");
    
    // cannot be instantiated by clients
    private GraphListElementDropHandler() {
        // empty
    }
    
    /**
     * The unique shared object of this type.
     */
    public static final GraphListElementDropHandler DROP_HANDLER = new GraphListElementDropHandler();
    
    //
    public boolean allowsMultipleDrops(JComponent target) {
        return true;
    }
    
    //
    public Class<?> getDropClass(JComponent target) {
        return GRAPH_LIST_ELEMENT;
    }
    
    //
    public boolean acceptDrop(JComponent target, Object object, int seqNr) {
        if (target instanceof HasGraphList) {
            if(!((HasGraphList)target).getGraphList().contains(object)){
                ((HasGraphList)target).getGraphList().add((GraphListElement)object);
                return true;
            } else {
                JOptionPane.showMessageDialog(target, MessageFormat.format(BUNDLE.getString("GraphList.duplicate"), object), BUNDLE.getString("GraphList.warning.title"), JOptionPane.DEFAULT_OPTION);
                return true; //continue with adding remaining graphs
            }
        } else
            return false;
    }
    
}
