/* GraphListElementRenderer.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

import org.grinvin.GraphURI;

/**
 * Cell renderer for objects of type {@link GraphListElement}.
 */
public class GraphListElementRenderer extends DefaultListCellRenderer {
    
    /** Default constructor */
    public GraphListElementRenderer () {
    }

    /**
     * Renders a graph list element as a combination of icon and graph name. The
     * icon depends on the 'type' of graph element (factory generated, uri, ...).
     */
    public Component getListCellRendererComponent 
        (JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {

        super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value instanceof GraphListElement) {
            GraphListElement gle = (GraphListElement)value;
            setText (gle.getName());
            setIcon(GraphURI.getType(gle.getURI()).getSmallIcon());
        }
        else
            throw new IllegalArgumentException
                ("GraphListElementRenderer can only be used with lists of GraphListElement");
        return this;
    }

    
}
