/* ExportGraphList.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list.commands;

import be.ugent.caagt.swirl.commands.AttributedCommandManager;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

import org.grinvin.graphbrowser.GraphBrowserMultiPanel;
import org.grinvin.io.GraphListSaver;

import org.pietschy.command.CommandManager;
import org.pietschy.command.file.AbstractSaveAsCommand;
import org.pietschy.command.file.ExtensionFileFilter;

/**
 * Command to export a list of graphs.
 */
public class ExportGraphList extends AbstractSaveAsCommand {
    
    //
    private static final String KEY = GraphBrowserMultiPanel.class.getName();
    
    //
    private static final FileFilter FILTER = new ExtensionFileFilter("graphlist", "*.graphlist");
    
    //
    private GraphBrowserMultiPanel panel;
    
    //
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle ("org.grinvin.list.commands.resources");

    //
    public ExportGraphList(CommandManager commandManager, String id) {
        super(commandManager, id, FILTER);
        this.panel = (GraphBrowserMultiPanel)((AttributedCommandManager)commandManager).getAttribute(KEY);
    }
    
    //
    protected boolean confirmProceed () {
        if (panel.getGraphInvariantListModel().getGraphList().containsSessionElements()) {
            JOptionPane.showMessageDialog(panel, BUNDLE.getString("GraphList.SessionElements"), BUNDLE.getString("GraphListSave.title"), JOptionPane.DEFAULT_OPTION);
            return false;
        }    
        return true;
    }
    
    // implements performSave
    public void performSave(File file) {
        try {
            GraphListSaver.save(panel.getGraphInvariantListModel(), file);
        } catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Saving graph list failed:" + e);
        }
    }
    
    protected String getFileExistsMessage(File file) {
        return MessageFormat.format(BUNDLE.getString("File.overwrite.message"), file.getName());
    }
    
}

