/* GraphListRename.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list.commands;

import be.ugent.caagt.swirl.commands.AttributedCommandManager;
import be.ugent.caagt.swirl.lists.TypedListModel;

import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import org.grinvin.graphbrowser.GraphBrowserWindow;
import org.grinvin.grinvin.GrinvinWindow;
import org.grinvin.list.GraphList;

import org.pietschy.command.ActionCommand;
import org.pietschy.command.CommandManager;

/**
 * GUI command which allows the user to rename the currently selected
 * graph list.<p>
 * Acts upon a array list model and a selection model stored as attributes in
 * an attributed command manager.
 */
public class GraphListRename extends ActionCommand implements ListSelectionListener, ChangeListener {
    
    //
    private static final String KEY = GrinvinWindow.class.getName();
    
    //
    private TypedListModel<GraphBrowserWindow> list;
    
    //
    private ListSelectionModel selectionModel;
    
    //
    private GrinvinWindow window;
    
    /**
     * Construct an action command of this type.
     * @param commandManager Command manager, which must be of class {@link AttributedCommandManager}
     */
    public GraphListRename (CommandManager commandManager, String id) {
        super (commandManager, id);
        this.window = (GrinvinWindow)((AttributedCommandManager)commandManager).getAttribute (KEY);
        this.list = window.getGraphListsModel().getListModel();
        this.selectionModel = window.getGraphListsListSelectionModel();
        this.selectionModel.addListSelectionListener(this);
        this.window.addTabsChangeListener(this);
        int index = selectionModel.getMinSelectionIndex ();
        setEnabled(index >= 0 && index == selectionModel.getMaxSelectionIndex() && window.getSelectedTab().equals("graphlists"));
    }

    /**
     * Ask the user to rename the currently selected graph list element.
     */
    protected void handleExecute () {
        // TODO: delegate some of this to GraphListsWindow, add method getSelectedWindows?
        
        int index = selectionModel.getMinSelectionIndex ();
        if (index < 0)
            return; // none selected
        if (index != selectionModel.getMaxSelectionIndex ())
            return; // more than one selection
        GraphList graphlist = list.get(index).getGraphList();
        
        //if (gle.isNameEditable()) {
            GraphListRenamePanel panel = new GraphListRenamePanel ();
            panel.showDialog (graphlist, window);
        //}
    }

    public void valueChanged(ListSelectionEvent e) {
        int index = selectionModel.getMinSelectionIndex ();
        setEnabled(index >= 0 && index == selectionModel.getMaxSelectionIndex() && window.getSelectedTab().equals("graphlists"));
    }

    public void stateChanged(ChangeEvent e) {
        int index = selectionModel.getMinSelectionIndex ();
        setEnabled(index >= 0 && index == selectionModel.getMaxSelectionIndex() && window.getSelectedTab().equals("graphlists"));
    }
    
}
