/* GraphListRenamePanel.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list.commands;

import java.awt.Component;
import java.util.ResourceBundle;

import org.grinvin.list.GraphList;

/**
 * Dialog panel for renaming a graph list.
 */
public class GraphListRenamePanel extends RenamePanel {
    
    private static final ResourceBundle BUNDLE
            = ResourceBundle.getBundle("org.grinvin.list.commands.resources");
    
    //
    protected String getOldLabelText() {
        return BUNDLE.getString("GraphListRenamePanel.name.old");
    }
    
    //
    protected String getNewLabelText() {
        return BUNDLE.getString("GraphListRenamePanel.name.new");
    }
    
    //
    protected String getPanelTitle() {
        return BUNDLE.getString("GraphListRenamePanel.title");
    }
    
    /**
     * Create and activate the dialog for the given graph list.
     * When finished, the name of
     * the graph list will be changed, except when the dialog was canceled
     * by the user.
     * @param graphlist GraphListModel of which the name can be changed by the user.
     * @param parent Parent of this dialog
     */
    public void showDialog(GraphList graphlist, Component parent) {
        assert graphlist != null : "Dialog shown without corresponding graph list";
        super.showDialog(graphlist, null, parent);
    }
    
    
}
