/* LoadInvariant.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list.commands;

import java.io.File;

import java.util.ResourceBundle;
import java.util.logging.Logger;

import javax.swing.filechooser.FileFilter;

import org.grinvin.invariants.IllegalInvariantComputerException;
import org.grinvin.invariants.InvariantManager;

import org.pietschy.command.CommandManager;
import org.pietschy.command.file.AbstractFileOpenCommand;
import org.pietschy.command.file.ExtensionFileFilter;

/**
 * Command to load a new invariant computer from file.
 */
public class LoadInvariant extends AbstractFileOpenCommand {
    
    //
    private static final String BUNDLE_NAME
            = "org.grinvin.list.commands.resources";
    //
    private static final ResourceBundle BUNDLE 
            = ResourceBundle.getBundle (BUNDLE_NAME);
    
    //
    private static final Logger LOGGER
            = Logger.getLogger ("org.grinvin.list.commands", BUNDLE_NAME);
    
    //
    private static final FileFilter FILTER
            = new ExtensionFileFilter ("class", 
                BUNDLE.getString ("LoadInvariant.filter.description")) ;
    
    /** Creates a new instance of LoadInvariant */
    public LoadInvariant (CommandManager commandManager, String id) {
        super (commandManager, id, FILTER);
        this.setMultiselectionEnabled(true);
    }
    
    // implements performOpen
    public void performOpen (File[] files) {
        InvariantManager manager = InvariantManager.getInstance ();
        
        for (File file : files) {
            try {
                manager.loadInvariantComputer (file);
            } catch (IllegalInvariantComputerException ex) {
                LOGGER.warning ("LoadInvariant.illegal");
            }
        }
    }

}
