/* ParameterComponent.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.params;

import java.awt.event.FocusListener;

/**
 * Interface that should be implemented by a component that allows
 * editing of parameter values of a certain type. As with {@link ParameterEditor},
 * each parameter component is implicitely associated with a single type.<p>
 * In practice every
 * component implementing this interface should also be an 
 * extension of class {@link java.awt.Component} or preferably of
 * {@link javax.swing.JComponent}.
 */
public interface ParameterComponent {
    
    /**
     * Return the parameter value currently stored in the component. The resulting
     * value object is of the type implicitely associated with this component.
     */
    public Object getParameterValue ();
    
    /**
     * Store the given parameter value into the component. May throw
     * an exception when the given value does not belong to the type  which is 
     * implicitely associated with this component.
     */
    public void setParameterValue (Object value);
    
    public void addFocusListener (FocusListener l);
    
    public void removeFocusListener (FocusListener l);
}
