/* AboutDialog.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.about;

import be.ugent.caagt.swirl.StandardButtons;

import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableColumnModel;

import org.grinvin.gui.icons.SvgIconManager;
import org.grinvin.gui.windows.MindgameWindow;

/**
 * Displays the 'About' dialog, with versioning information.
 */
public class AboutDialog extends JDialog {
    
    //
    private static final String BUNDLE_NAME = "org.grinvin.main.resources";
    
    //
    public AboutDialog() {
        super((Frame)null, ResourceBundle.getBundle(BUNDLE_NAME).getString("window.about.title"));
        
        JPanel contentPane = new JPanel(new GridBagLayout ());
        setContentPane(contentPane);
        GridBagConstraints gbc = new GridBagConstraints ();
        
        gbc.gridx = 0;
        gbc.fill = GridBagConstraints.NONE;
        gbc.insets = new Insets (7, 12, 7, 12);
        
        // add logo
        gbc.gridy = 0;
        JButton logoButton = new JButton();
        ImageIcon icon = SvgIconManager.getInstance().getIcon("/org/grinvin/icons/grinvin-large.svg", 352, 96);
        logoButton.setIcon(icon);
        logoButton.setPressedIcon(icon);
        logoButton.setContentAreaFilled(false);
        logoButton.setBorderPainted(false);
        logoButton.setMargin(new Insets(0,0,0,0));
        logoButton.setFocusable(false);
        logoButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                if (((e.getModifiers() & ActionEvent.SHIFT_MASK) == 1) && ((e.getModifiers() & ActionEvent.CTRL_MASK) == 2)) {
                    new MindgameWindow().setVisible(true);
                }
            }
        });
        contentPane.add(logoButton, gbc);
        
        // add license
        gbc.gridy = 2;
        String licenseText = null;
        try {
            InputStream stream = AboutDialog.class.getResourceAsStream("license_header.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder sb = new StringBuilder();
            String line = reader.readLine();
            while(line!=null){
                sb.append(line);
                sb.append("\n");
                line=reader.readLine();
            }
            licenseText = sb.toString();
            reader.close ();
        } catch (IOException ex) {
            throw new RuntimeException("Could not load license header", ex);
        }
        JTextArea licenseTextArea = new JTextArea(licenseText);
        licenseTextArea.setRows(4);
        licenseTextArea.setEditable(false);
        contentPane.add(new JScrollPane(licenseTextArea), gbc);

        // add version table
        gbc.gridy = 4;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        
        JTable versionTable = new JTable(VersionTableModel.getInstance());
        TableColumnModel tcn = versionTable.getColumnModel();
        tcn.getColumn(0).setPreferredWidth(100);
        tcn.getColumn(1).setPreferredWidth(50);
        tcn.getColumn(2).setPreferredWidth(50);
        tcn.getColumn(3).setPreferredWidth(200);
        contentPane.add(versionTable, gbc);
        
        // OK Button
        gbc.gridy = 7;
        gbc.fill = GridBagConstraints.NONE;
        JButton okButton = StandardButtons.createOKButton();
        okButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
            }
        });
        getRootPane().setDefaultButton(okButton);
        contentPane.add(okButton, gbc);
        
        //mindgame button
        Calendar calendar = GregorianCalendar.getInstance();
        if (calendar.get(Calendar.DAY_OF_WEEK) == Calendar.FRIDAY && calendar.get(Calendar.DAY_OF_MONTH) == 13) {
            JButton mindgameButton = new JButton(ResourceBundle.getBundle(BUNDLE_NAME).getString("about.mindgame.label"));
            mindgameButton.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    new MindgameWindow().setVisible(true);
                }
            });
            gbc.anchor = GridBagConstraints.WEST;
            contentPane.add(mindgameButton, gbc);
        }
        
        // Labels
        gbc.anchor = GridBagConstraints.WEST;
        gbc.gridy = 1;
        ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME);
        JLabel licenseLabel = new JLabel (bundle.getString ("about.license.label"));
        contentPane.add(licenseLabel, gbc);
        
        gbc.gridy = 3;
        JLabel versionLabel = new JLabel (bundle.getString ("about.version.label"));
        contentPane.add(versionLabel, gbc);
        
        gbc.gridy = 5;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        JLabel otherLabel = new JLabel(bundle.getString("about.other.label"));
        contentPane.add(otherLabel, gbc);
        
        gbc.gridy = 6;
        JTable otherTable = new JTable(OtherTableModel.getInstance());
        TableColumnModel othertcn = otherTable.getColumnModel();
        othertcn.getColumn(0).setPreferredWidth(50);
        othertcn.getColumn(1).setPreferredWidth(100);
        contentPane.add(otherTable, gbc);
        
        pack();
        
        // do not allow resize
        setResizable(false);
        
        //center on screen
        setLocationRelativeTo(null);
        
        setDefaultCloseOperation(HIDE_ON_CLOSE);
    }
    
}
