/* GraphComponent.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gui.components;

import java.awt.Dimension;
import javax.swing.JLabel;

import org.grinvin.gui.components.render.GraphListElementCellRenderer;
import org.grinvin.invariants.Invariant;
import org.grinvin.list.graphs.GraphListElement;
import org.grinvin.list.graphs.GraphListElementListener;

/**
 * Component that combines the graph icon with its name.
 */
public class GraphComponent extends JLabel implements GraphListElementListener {
  
    //
    private GraphListElement element;
    
    //
    public GraphComponent() {
        this(null);
    }
    
    public GraphComponent(GraphListElement element) {
        this.element = element;
        setMinimumSize(new Dimension(100, 100));
        setPreferredSize(new Dimension(165, 165));
        setHorizontalAlignment(JLabel.CENTER);
        setHorizontalTextPosition(JLabel.CENTER);
        setVerticalTextPosition(JLabel.TOP);
        setElement(element);
    }
    
    @Override public void doLayout() {
        if (element != null)
            setIcon();
        super.doLayout();
    }

    /**
     * Display information for the given element.
     */
    public void setElement(GraphListElement newElement) {
        if (element != null)
            element.removeGraphListElementListener(this);
        element = newElement;
        if (newElement == null) {
            setIcon(null);
        } else {
            newElement.addGraphListElementListener(this);
            setVisible(true);
            setIcon();
        }
        revalidate();
    }
    
    //
    public GraphListElement getElement() {
        return element;
    }
    
    //
    private void setIcon() {
        //TODO: check why height becomes 0
        int height = getHeight() - 30;
        int width = getWidth() - 30;
        if (height < 1)
            height = 1;
        if (width < 1)
            width = 1;
        setIcon(GraphListElementCellRenderer.getInstance().createIcon(element, Math.min(height, width)));
    }
    
    public void graphListElementURIChanged(GraphListElement element) {
        //ignore, this component does not paint the background
    }

    public void graphListElementNameChanged(GraphListElement element) {
        //ignore, this component does not paint the title
    }

    public void graphListElementInvariantComputed(GraphListElement element, Invariant invariant) {
        //ignore
    }

    public void graphListElementGraphChanged(GraphListElement element) {
        setIcon();
    }
    
}
