/* InvariantValuesLoader.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.io;

import java.io.InputStream;

import org.grinvin.graphs.GraphBundle;
import org.grinvin.invariants.values.AbstractInvariantValueDelegate;
import org.grinvin.invariants.InvariantValue;
import org.grinvin.invariants.UnknownInvariantException;
import org.grinvin.invariants.UnknownInvariantTypeException;

import org.jdom.Document;
import org.jdom.Element;

/**
 * Loader for the computed values of a saved GraphBundle
 */
public class InvariantValuesLoader {
    
    //
    private static final String PUBLIC_ID = "-//GrInvIn IO//Invariant Values 1.1//EN";
    
    //
    private InvariantValuesLoader() { }
    
    //TODO: check exceptions
    /**
     * Load the values of the invariants to the given graphbundle
     * @param element The Element containing the invariant values
     */
    private static void toInvariantValues(GraphBundle bundle, Element element) throws IOFormatException {
        for (Object obj : element.getChildren ("invariantvalue")) {
            try {
                InvariantValue value = AbstractInvariantValueDelegate.fromElement((Element)obj);
                if (value != null)
                    bundle.addInvariantValue(value);
                //TODO: log this
            } catch (UnknownInvariantException e) {
                // ignore
                // TODO: please log this
            } catch (UnknownInvariantTypeException e) {
                // ignore
                // TODO: please log this
            }
        }
    }
    
    private static void toInvariantValues_1_0(GraphBundle bundle, Element element) throws IOFormatException {
        for (Object obj : element.getChildren ("invariantvalue")) {
            try {
                InvariantValue value = AbstractInvariantValueDelegate.fromElement_1_0((Element)obj);
                if (value != null)
                    bundle.addInvariantValue(value);
                //TODO: log this
            } catch (UnknownInvariantException e) {
                // ignore
                // TODO: please log this
            } catch (UnknownInvariantTypeException e) {
                // ignore
                // TODO: please log this
            }
        }
    }
    
    /**
     * Load the invariant values from the given InputStream
     * @param input the InputStream
     */
    public static void load(GraphBundle bundle, InputStream input) throws IOFormatException {
        try {
            Document document = LoaderSaverHelper.loadDocument(input);
            if (!PUBLIC_ID.equals(document.getDocType().getPublicID()))
                throw new IOFormatException("Unkown document type: " + document.getDocType().getPublicID() + " expects " + PUBLIC_ID);
            toInvariantValues(bundle, document.getRootElement());
        } catch (Exception ex) {
            //TODO: check this
            throw new IOFormatException("Missing invariant", ex);
        }
    }

    public static void load_1_0(GraphBundle bundle, InputStream input) throws IOFormatException {
        try {
            toInvariantValues_1_0(bundle, LoaderSaverHelper.loadElementNonValidating(input, "invariantvalues"));
        } catch (Exception ex) {
            //TODO: check this
            throw new IOFormatException("Missing invariant", ex);
        }
    }

    
}
