/* ImportGraphBundle.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list.actions;


import be.ugent.caagt.swirl.actions.FileOpenAction;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

import org.grinvin.graphs.DefaultGraphBundle;
import org.grinvin.graphs.GraphBundle;
import org.grinvin.gui.FileFilters;
import org.grinvin.io.graphs.Graph6Loader;
import org.grinvin.list.graphs.GraphList;
import org.grinvin.list.graphs.GraphListElement;
import org.grinvin.list.graphs.GraphListElementManager;

/**
 * Action to import graph bundles into the given graph list.
 */
public class ImportGraphBundle extends FileOpenAction {

    //
    private static final String BUNDLE_NAME = "org.grinvin.list.actions.resources";
    //
    private static final Logger LOGGER = Logger.getLogger("org.grinvin.io");
    //
    private final GraphList graphList;

    //
    public ImportGraphBundle(GraphList graphList, Window parent) {
        super(parent, true, FileFilters.GPH_FILTER, FileFilters.G6_FILTER);
        this.graphList = graphList;
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setAccessory(new GraphBundlePreview(fileChooser));
    }

    protected void openFile(File file) {
        if (FileFilters.GPH_FILTER.accept(file)) {
            GraphListElement graphlistelement = GraphListElementManager.getInstance().getGraphListElement(file.toURI());
            if (graphList.contains(graphlistelement)) {
                ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME);
                JOptionPane.showMessageDialog(
                        parent,
                        bundle.getString("GraphList.duplicate"),
                        bundle.getString("GraphList.warning.title"),
                        JOptionPane.DEFAULT_OPTION);
            } else {
                graphList.add(graphlistelement);
            }
        } else if (FileFilters.G6_FILTER.accept(file)) {
            GraphBundle bundle = new DefaultGraphBundle();
            try {
                Graph6Loader.readSingleGraph(bundle, file);
                GraphListElement graphlistelement = GraphListElementManager.getInstance().createGraphListElement(bundle);
                graphList.add(graphlistelement);
            } catch (IOException ex) {
                LOGGER.log(Level.INFO, "Failed to import graph", ex);
            }

        }
    }
}
