/* RunConjecturing.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;

import org.grinvin.conjecture.engine.EngineRunner;
import org.grinvin.conjecture.engine.EngineRunner.Status;
import org.grinvin.worksheet.WorksheetWindow;
import org.grinvin.worksheet.WorksheetModelListener;

/**
 * GUI command which runs an engine on the invariant table of a given window
 * and outputs the result to the given text area.
 */
public class RunConjecturing extends AbstractAction implements WorksheetModelListener {

    //
    private final EngineRunner runner;
    //
    private final WorksheetWindow window;

    /**
     * Listens to the engine and adds all generated results to the results area.
     * Disables the command while running.
     */
    private class Listener implements ChangeListener {

        //
        Listener() {
        // avoids creation of access type
        }

        //
        public void stateChanged(ChangeEvent e) {
            Status status = runner.getStatus();
            window.setStatus(status);
            if (status == Status.STOPPED) {
                window.getModel().addResult(runner.getResult());
            }
            setEnabled();
        }
    }

    public RunConjecturing(WorksheetWindow window) {
        this.window = window;
        this.runner = window.getModel().getEngineRunner();
        runner.addChangeListener(new Listener());
        window.getModel().addWorksheetModelListener(this);
        setEnabled();
    }

    // implements handleExecute
    public void actionPerformed(ActionEvent e) {
        if (window.getModel().getInvariantList().size() != 0 &&
                window.getModel().getGraphList().size() + window.getModel().getGeneratorInstanceList().size() != 0 &&
                runner.getStatus() == Status.STOPPED &&
                runner.getEngine().isReadyForRun()) {
            new Thread(runner).start();
        }
    }

    private void setEnabled() {
        setEnabled(window.getModel().getInvariantList().size() != 0 &&
                window.getModel().getGraphList().size() + window.getModel().getGeneratorInstanceList().size() != 0 &&
                runner.getStatus() == Status.STOPPED &&
                runner.getEngine().isReadyForRun());
    }

    public void valueChanged(ListSelectionEvent e) {
        setEnabled();
    }

    public void intervalAdded(ListDataEvent e) {
        setEnabled();
    }

    public void intervalRemoved(ListDataEvent e) {
        setEnabled();
    }

    public void contentsChanged(ListDataEvent e) {
        setEnabled();
    }

    public void engineChanged() {
        setEnabled();
    }

    public void engineConfigurationChanged() {
        setEnabled();
    }

    public void filterChanged() {
    }

    public void worksheetModelNameChanged() {
    }
}
