/* Regularity.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants.computers.simple;

import org.grinvin.GraphBundleView;
import org.grinvin.invariants.BooleanValue;
import org.grinvin.invariants.computers.AbstractInvariantComputer;

/**
 * Computes whether the graph is regular.
 */
public class Regularity extends AbstractInvariantComputer {
    
    public BooleanValue compute(GraphBundleView bundle) {
        int[][] adjlist = bundle.adjacencyList();
        if(adjlist.length == 0)
            //empty graph is regular
            return new BooleanValue(true, this);
        int firstDegree = adjlist[0].length;
        for (int i = 1; i < adjlist.length; i++)
            if (adjlist[i].length != firstDegree)
                return new BooleanValue(false, this);
        return new BooleanValue(true, this);
    }
    
    public String getInvariantId() {
        return "org.grinvin.invariants.Regularity";
    }
}
