/* MeanVertexDegreeEquality.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants.computers.chemical.indices;

import org.grinvin.graphs.GraphBundleView;
import org.grinvin.graphs.GraphView;
import org.grinvin.invariants.computers.AbstractInvariantComputer;
import org.grinvin.invariants.values.RealValue;

/**
 * computes the mean information content on the vertex degree equality of the graph.
 */
public class MeanVertexDegreeEquality extends AbstractInvariantComputer {
    
    public RealValue compute(GraphBundleView bundle) {
        GraphView graph = bundle.getGraph();
        int[][] adjlist = bundle.adjacencyList();
        double numberOfVertices = graph.getNumberOfVertices();
        if(numberOfVertices==0)
            return RealValue.undefinedValue(this);
        double[] vertexDegreeCount = new double[graph.getNumberOfVertices()];
        int maxdeg = 0;
        for (int[] neighbours : adjlist){
            if (neighbours.length > maxdeg)
                maxdeg = neighbours.length;
            vertexDegreeCount[neighbours.length]++;
        }
        double index = 0.0;
        for(int i = 0; i <= maxdeg; i++)
            if(vertexDegreeCount[i]!=0)
                index -= vertexDegreeCount[i]/numberOfVertices * Math.log(vertexDegreeCount[i]/numberOfVertices) / Math.log(2);
        return new RealValue(index, this);
    }
    
    public String getInvariantId() {
        return "org.grinvin.invariants.MeanVertexDegreeEquality";
    }
}
