/*
 * Decompiled with CFR 0.152.
 */
package org.workingfrog.i18n.swing;

import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JToggleButton;
import org.workingfrog.i18n.util.LocaleEvent;
import org.workingfrog.i18n.util.LocaleListener;
import org.workingfrog.i18n.util.Translator;

public class I18NJCheckBoxMenuItem
extends JCheckBoxMenuItem
implements LocaleListener {
    private String bundle = "CoreMenu";
    private String i18nKey = null;

    public I18NJCheckBoxMenuItem(String i18nKey) {
        super(i18nKey);
        this.setText(Translator.checkValue(this.bundle, i18nKey, this));
        Translator.checkKey(i18nKey, this);
        this.i18nKey = i18nKey;
    }

    public I18NJCheckBoxMenuItem(String i18nKey, Icon icon) {
        this(i18nKey);
        ((AbstractButton)this).setModel(new DefaultButtonModel());
        this.setIcon(icon);
    }

    public I18NJCheckBoxMenuItem(String i18nKey, Icon icon, boolean b) {
        this(i18nKey, icon);
        ((AbstractButton)this).setModel(new JToggleButton.ToggleButtonModel());
        this.setSelected(b);
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public void localeChanged(LocaleEvent event) {
        Action action = this.getAction();
        if (action != null) {
            if (action instanceof LocaleListener) {
                ((LocaleListener)((Object)action)).localeChanged(event);
            }
        } else {
            this.setText(Translator.checkValue(this.bundle, this.i18nKey, this));
        }
    }
}

