/*
 * Decompiled with CFR 0.152.
 */
package org.workingfrog.i18n.swing;

import javax.swing.Icon;
import javax.swing.JLabel;
import org.workingfrog.i18n.util.LocaleEvent;
import org.workingfrog.i18n.util.LocaleListener;
import org.workingfrog.i18n.util.Translator;

public class I18NJLabel
extends JLabel
implements LocaleListener {
    private String bundle = "label";
    private String i18nKey = "label.error";
    private boolean flag = false;

    public I18NJLabel() {
    }

    public I18NJLabel(String bundle, Icon icon) {
        super(icon);
        this.bundle = bundle;
        this.flag = true;
    }

    public I18NJLabel(String bundle, Icon icon, int horizontalAlignment) {
        super(icon, horizontalAlignment);
        this.bundle = bundle;
        this.flag = true;
    }

    public I18NJLabel(String bundle, String i18nKey) {
        super(i18nKey);
        this.initResource(bundle, i18nKey);
    }

    public I18NJLabel(String bundle, String i18nKey, Icon icon, int horizontalAlignment) {
        super(i18nKey, icon, horizontalAlignment);
        this.initResource(bundle, i18nKey);
    }

    public I18NJLabel(String bundle, String i18nKey, int horizontalAlignment) {
        super(i18nKey, horizontalAlignment);
        this.initResource(bundle, i18nKey);
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    private void initResource(String bundle, String key) {
        this.bundle = bundle;
        this.i18nKey = key;
        this.flag = true;
        Translator.checkKey(this.i18nKey, this);
        this.setText(key);
    }

    public void setText(String i18nKey) {
        if (i18nKey != null && this.flag) {
            super.setText(Translator.checkValue(this.bundle, i18nKey, this));
        }
    }

    public void localeChanged(LocaleEvent event) {
        super.setText(Translator.checkValue(this.bundle, this.i18nKey, this));
    }
}

