/*
 * Decompiled with CFR 0.152.
 */
package org.workingfrog.i18n.swing;

import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import org.workingfrog.i18n.swing.I18NAction;
import org.workingfrog.i18n.util.LocaleEvent;
import org.workingfrog.i18n.util.LocaleListener;
import org.workingfrog.i18n.util.Translator;

public class I18NJMenuItem
extends JMenuItem
implements LocaleListener {
    private static String menuBundle = "menu";
    private static String actionBundle = "action";
    private String i18nKey = "menu.error";

    public I18NJMenuItem() {
    }

    public I18NJMenuItem(String i18nKey) {
        this(i18nKey, null);
    }

    public I18NJMenuItem(Action action) {
        super(action);
        if (action instanceof LocaleListener) {
            this.i18nKey = ((I18NAction)action).getKey();
            this.setText(Translator.checkValue(actionBundle, this.i18nKey, this));
            Translator.checkKey(this.i18nKey, this);
        }
    }

    public I18NJMenuItem(String i18nKey, Icon icon) {
        super(Translator.checkValue(menuBundle, i18nKey, new I18NJMenuItem()), icon);
        Translator.checkKey(i18nKey, this);
        this.i18nKey = i18nKey;
    }

    public void setBundle(String bundle) {
        menuBundle = bundle;
        this.setText(Translator.checkValue(menuBundle, this.i18nKey, this));
    }

    public void localeChanged(LocaleEvent event) {
        Action action = this.getAction();
        if (action != null) {
            if (action instanceof LocaleListener) {
                ((LocaleListener)((Object)action)).localeChanged(event);
            }
        } else {
            this.setText(Translator.checkValue(menuBundle, this.i18nKey, this));
        }
    }
}

