/*
 * Decompiled with CFR 0.152.
 */
package org.workingfrog.i18n.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.workingfrog.i18n.util.LocaleListener;
import org.workingfrog.i18n.util.Localizer;
import org.workingfrog.i18n.util.Translator;

public class Validator {
    private StringBuffer log = new StringBuffer();
    private String binding = null;
    private String i18nKey = null;
    private String localized = null;
    private HashMap logged = new HashMap();
    private HashSet bindings = new HashSet();
    private boolean name = false;
    private boolean bundle = false;

    public Validator() {
        this.clearLogs();
    }

    public void clearLogs() {
        this.logged.clear();
        this.logged.put("bundles", new HashSet());
        this.logged.put("l10nKeys", new HashSet());
        this.logged.put("naming", new HashSet());
        this.logged.put("oldNaming", new HashSet());
    }

    private void clear() {
        this.log = new StringBuffer();
        this.binding = null;
        this.i18nKey = null;
        this.localized = null;
        this.name = false;
        this.bundle = false;
    }

    public boolean isValidName() {
        return this.name;
    }

    public boolean isValidBundle() {
        return this.bundle;
    }

    public void storeBundle(String binding) {
        this.bindings.add(binding);
    }

    public String getLocalizedValue() {
        return this.localized;
    }

    public boolean check(String i18nKey) {
        this.i18nKey = i18nKey;
        this.clear();
        this.binding = this.getBinding(i18nKey);
        this.checkName(i18nKey);
        this.localized = this.checkValue(i18nKey);
        return this.log.length() == 0;
    }

    public boolean checkName(String i18nKey) {
        if (!Translator.isChecking(3)) {
            return true;
        }
        StringBuffer result = new StringBuffer();
        if (!this.isLogged("naming", i18nKey)) {
            this.logElement("naming", i18nKey);
            if (i18nKey.indexOf(" ") != -1 || i18nKey.indexOf("\t") != -1) {
                if (i18nKey.indexOf(" ") != i18nKey.lastIndexOf(" ") || i18nKey.indexOf("\t") != i18nKey.lastIndexOf("\t")) {
                    result.append("naming : key \"").append(i18nKey).append("\" contains white spaces.");
                } else {
                    result.append("naming : key \"").append(i18nKey).append("\" contains a white space.");
                }
            }
            if (!i18nKey.toLowerCase().equals(i18nKey)) {
                if (result.length() > 0) {
                    result.append("\n");
                }
                result.append("naming : key \"").append(i18nKey).append("\" contains upper case letter(s).");
            }
            if (this.binding != null) {
                this.checkBundle(this.binding);
            } else {
                if (result.length() > 0) {
                    result.append("\n");
                }
                result.append("naming : key \"").append(i18nKey).append("\" must be prefixed with it's bundle name.");
            }
        }
        if (result.length() > 0) {
            this.log.append(result.toString());
            return false;
        }
        return true;
    }

    public boolean checkBundle(String binding) {
        boolean result = this.bindings.contains(binding);
        if (!this.isLogged("bundles", binding)) {
            this.logElement("bundles", binding);
            if (!result) {
                this.log.append("i18n : bundle \"").append(binding).append("\" not loaded.");
            }
        }
        return result;
    }

    public String checkValue(String i18nKey) {
        if (!Translator.isChecking(1)) {
            return Localizer.localize(this.binding, i18nKey);
        }
        if (this.bindings.contains(this.binding)) {
            if (Localizer.containsKey(this.binding, i18nKey)) {
                return Localizer.localize(this.binding, i18nKey);
            }
            if (!this.isLogged("l10nKeys", i18nKey)) {
                this.logElement("l10nKeys", i18nKey);
                this.log.append("l10n : key \"").append(i18nKey).append("\" missing for ").append(Locale.getDefault().getDisplayName()).append(".");
            }
            return "[ " + i18nKey + " ]";
        }
        if (!this.isLogged("oldNaming", i18nKey)) {
            this.logElement("oldNaming", i18nKey);
            System.out.println(String.valueOf(i18nKey) + " not parsed");
        }
        return "[ " + i18nKey + " ]";
    }

    public boolean isLocaleListener(Object object, Object source) {
        if (!Translator.isChecking(2)) {
            return object instanceof LocaleListener;
        }
        if (!(object instanceof LocaleListener)) {
            Translator.log("i18n : source : " + source.getClass().getName());
            Translator.log("i18n : " + object.getClass().getName() + " is not a LocaleListener");
            return false;
        }
        return true;
    }

    private boolean isLogged(String level, String element) {
        return ((HashSet)this.logged.get(level)).contains(element);
    }

    private void logElement(String level, String element) {
        ((HashSet)this.logged.get(level)).add(element);
    }

    public String getBinding(String key) {
        return key.indexOf(".") > 0 ? key.substring(0, key.indexOf(".")) : null;
    }

    public String getReport() {
        return this.log.toString();
    }
}

