/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

/*
 * Created on Jan 17, 2006
 */
package org.jboss.test.remoting.transport.multiplex;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;

import javax.management.MBeanServer;

import org.jboss.remoting.Client;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.transport.ClientInvoker;
import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transport.local.LocalClientInvoker;
import org.jboss.remoting.transport.multiplex.Multiplex;
import org.jboss.remoting.transport.multiplex.MultiplexServerInvoker;
import org.jboss.test.remoting.transport.multiplex.utility.SuccessCountingTestCase;


/**
 * A ConfigurationMapTestCase.

 * @author <a href="mailto:r.sigal@computer.org">Ron Sigal</a>
 * @version $Revision: 1.3 $
 * <p>
 * Copyright (c) 2005
 * </p>
 */

public class LocalInvokerTestCase extends SuccessCountingTestCase
{
   public void testLocalClientInvoker()
   {
      try
      {
         // Create Connector.
         String connectorURI = "multiplex://localhost:5757";
         InvokerLocator connectorLocator = new InvokerLocator(connectorURI);
         System.out.println("Starting remoting server with locator uri of: " + connectorURI);
         log.info("Starting remoting server with locator uri of: " + connectorURI);
         Connector connector = new Connector();
         connector.setInvokerLocator(connectorLocator.getLocatorURI());
         connector.create();
         SimpleServerInvocationHandler invocationHandler = new SimpleServerInvocationHandler();
         connector.addInvocationHandler("test", invocationHandler);
         connector.start();
         
         // Create Client.
         Map configuration = new HashMap();
         configuration.put(Multiplex.MULTIPLEX_BIND_HOST, "localhost");
         configuration.put(Multiplex.MULTIPLEX_BIND_PORT, "6565");
         Client client = new Client(connectorLocator, configuration);
         client.connect();
         
         // Get ClientInvoker
         ClientInvoker clientInvoker = null;
         ClientInvoker[] clientInvokers = InvokerRegistry.getClientInvokers();;
         for (int i = 0; i < clientInvokers.length; i++)
         {
            if(clientInvokers[i].getLocator().equals(connectorLocator))
            {
               clientInvoker = clientInvokers[i];
            }
         }
         
         // Make sure ClientInvoker is a LocalClientInvoker.
         assertTrue(clientInvoker instanceof LocalClientInvoker);

         // Get master MultiplexServerInvoker
         ServerInvoker serverInvoker = null;
         ServerInvoker[] serverInvokers = InvokerRegistry.getServerInvokers();;
         for (int i = 0; i < serverInvokers.length; i++)
         {
            if(serverInvokers[i].getLocator().equals(connectorLocator))
            {
               serverInvoker = serverInvokers[i];
            }
         }
         
         // Make sure there is no virtual MultiplexServerInvoker.
         assertTrue(serverInvoker instanceof MultiplexServerInvoker);
         MultiplexServerInvoker masterInvoker = (MultiplexServerInvoker) serverInvoker;
         InetSocketAddress connectorAddress = new InetSocketAddress("localhost", 6565);
         MultiplexServerInvoker virtualInvoker = masterInvoker.getServerInvoker(connectorAddress);
         assertNull(virtualInvoker);
         
         Object response = client.invoke(new Integer(3));
         log.info("Invocation completed");
         assertNotNull(response);
         assertEquals(new Integer(3), response);
         
         client.disconnect();
         connector.stop();
      }
      catch (Throwable t)
      {
         log.error(t);
         t.printStackTrace();
         fail();
      }
      
      log.info("testLocalClientInvoker() PASSES");
      OKCounter++;
   }


   class SimpleServerInvocationHandler implements ServerInvocationHandler
   {
      InvokerCallbackHandler handler;
     
      public void addListener(InvokerCallbackHandler callbackHandler)
      {
         this.handler = callbackHandler;
      }

      public Object invoke(InvocationRequest invocation) throws Throwable
      {
         log.info("Received invocation:" + invocation);  
         return invocation.getParameter();
      }

      public void removeListener(InvokerCallbackHandler callbackHandler)
      {  
      }

      public void setInvoker(ServerInvoker invoker)
      {  
      }

      public void setMBeanServer(MBeanServer server)
      {  
      }
   }
}

