/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.test.remoting.transport.multiplex.config;


/**
 * 
 * @author <a href="mailto:ron.sigal@jboss.com">Ron Sigal</a>
 * @version $Revision$
 * <p>
 * Copyright (c) May 19, 2006
 * </p>
 */
public class ConfigurationByMapSameStaticObjectsTestServer extends ConfigurationTestServer
{
   protected void runTest() throws Exception
   {
      log.info("starting runTest()");
      is.read();
      Th t1 = new Th(connectorURI1, "ConfigurationByMapSameStaticObjectsTestServer.1");
      t1.start();
      is.read();
      Th t2 = new Th(connectorURI2, "ConfigurationByMapSameStaticObjectsTestServer.2");
      t2.start();
      is.read();
      synchronized (t1) {t1.notify();}
      log.info("closed client 1.1");
      synchronized (t2) {t2.notify();}
      log.info("concluding runTest()");
   }

   
   public static void main(String[] args)
   {
      ConfigurationTestServer tester = new ConfigurationByMapSameStaticObjectsTestServer();
      tester.setUp();
   }
}
