package org.jboss.test.remoting.versioning.transport;

import org.apache.log4j.Level;
import org.jboss.test.remoting.transport.InvokerTestDriver;

/**
 * @author <a href="mailto:tom.elrod@jboss.com">Tom Elrod</a>
 */
public abstract class VersionInvokerTestCaseBase extends InvokerTestDriver
{
   /**
    * Returns the classpath to be added to the classpath used to start the client tests.
    * Default return is null, which means no extra classpath will be added.
    *
    * @return
    */
   protected String getExtendedServerClasspath()
   {
      return System.getProperty("server.path");
   }

   /**
    * Returns the classpath to be added to the classpath used to start the client tests.
    * Default return is null, which means no extra classpath will be added.
    *
    * @return
    */
   protected String getExtendedClientClasspath()
   {
      return System.getProperty("client.path");
   }

//   protected Level getTestHarnessLogLevel()
//   {
//      return Level.DEBUG;
//   }

   protected Level getTestLogLevel()
   {
      return Level.DEBUG;
   }

   /**
    * How long to wait for test results to be returned from the client(s).  If goes longer than the
    * specified limit, will throw an exception and kill the running test cases.  Default value is
    * RESULTS_TIMEOUT.
    *
    * @return
    */
   protected long getResultsTimeout()
   {
      return 60000;
   }

   /**
    * How long for the server test case to wait for tear down message.  If exceeds timeout,
    * will throw exception.  The default value is TEARDOWN_TIMEOUT.
    *
    * @return
    */
   protected long getTearDownTimeout()
   {
      return 60000;
   }

   /**
    * How long to allow each of the test cases to run their tests.  If exceeds this timeout
    * will throw exception and kill tests.  The default value is RUN_TEST_TIMEOUT.
    *
    * @return
    */
   protected long getRunTestTimeout()
   {
      return 60000;
   }


}
