//
// C++ Implementation: slideshow
//
// Description: Backend functions for slideshow creation
//
// Author  : Gibault Stphane
// Modifier: Mikael Bhm <micko@bag.org>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "mandvd_global.h"
#include <mainfrm.h>
#include <slideshow.h>

#include <qmplayerwidget.h> 	/* C++ class for inbedded mplayer */

#include <qfontdialog.h> 
#include <qmessagebox.h> 
#include <qcombobox.h>
#include <qspinbox.h>  
#include <qcheckbox.h> 
#include <qgroupbox.h> 
#include <qstringlist.h> 
#include <qstring.h> 
#include <qpixmap.h> 
#include <qimage.h> 
#include <qpainter.h> 
#include <qdatetime.h> 
#include <qcolor.h> 
#include <qiconview.h> 
#include <qfile.h> 
#include <qrect.h> 
#include <qlabel.h> 
#include <qradiobutton.h> 
#include <qbuttongroup.h> 
#include <qtoolbutton.h> 
#include <qcolordialog.h> 
#include <qprogressbar.h> 
#include <qlineedit.h> 
#include <qtextedit.h> 
#include <qtabwidget.h> 
#include <qslider.h> 
#include <qfileinfo.h> 
#include <qdir.h> 
#include <qlistview.h> 
#include <qdatetimeedit.h> 


/* Code for slideshow */


	/* Methods that use m_pMPlayerWidget */

	/* Usage of m_pMPlayerWidget to preview in slideshow */
	void
	mainfrm::bt_slideshow_clicked () {
	// **********************************************
	// *** Affichage de la fentre de cration des slideshows ***
	// **********************************************
	the_selection->hide ();
	num_photo->setMaxValue (0);
	fen_slideshow->setGeometry (0, 110, 1000, 700);
	Etape_02->setDisabled (true);
	tabWidget2->setCurrentPage (0);
	texttottime->setText ("Total : 0 sec");
	bt_modif_gimp_2->setDisabled (true);
	bt_valid_info_image_2->setDisabled (true);
	bt_valid_info_image_3->setDisabled (true);
	bt_dep_gauche->hide ();
	bt_dep_droite->hide ();
	//
	yaaudio = 0;
	Audio_1->hide ();
	//
	bt_musique_options->setDisabled (true);
	fenparamdef->hide ();
	workinprogress->hide ();
	fen_slideshow->show ();
	fen_slideshow->raise ();
	nbre_images = 0;
	path_musique = "";
	box_det_photo->setDisabled (true);
	idtpage->setText (table_message[34]);
	scroll_timeline->setMaxValue (0);
	scroll_timeline->setValue (0);
	timeline->setGeometry (scroll_timeline->value () * -1, 25, 13500, 140);
	pnt_table_trans[0] = null_transition;
	pnt_table_trans[1] = trans_1;
	pnt_table_trans[2] = trans_2;
	pnt_table_trans[3] = trans_3;
	pnt_table_trans[4] = trans_4;
	pnt_table_trans[5] = trans_5;
	pnt_table_trans[6] = trans_6;
	pnt_table_trans[7] = trans_7;
	pnt_table_trans[8] = trans_8;
	pnt_table_trans[9] = trans_9;
	pnt_table_trans[10] = trans_10;
	pnt_table_trans[11] = trans_11;
	if (m_pMPlayerWidget->isPlaying () == true)
	{
	m_pMPlayerWidget->slotStop ();
	}
	}

	/* Calculate length of audiotrack?  */	
	void
	mainfrm::calczik (QString myfic) {
	path_musique = myfic;
	// *** R�cup�ration de la longueur de la bande son ***
	m_pMPlayerWidget->setFilename (myfic);
	if (m_pMPlayerWidget->isPlaying () == false)
	{
	m_pMPlayerWidget->slotPlay ();
	}
	durfilmchap = 0;
	
	while (durfilmchap == 0)
	{
	if (m_pMPlayerWidget->isPlaying () == false)
		{
		durfilmchap = 1;
		}
	else
		{
		m_pMPlayerWidget->slotReadStdout ();
		durfilmchap = m_pMPlayerWidget->m_fLength;
		}
	}
	if (m_pMPlayerWidget->isPlaying () == true)
	{
	m_pMPlayerWidget->slotStop ();
	}
	Audio_1->setGeometry (0, 121, 500, 18);
	Audio_1->setText ("Audio : " + myfic + " ---> " +
			QString::number (durfilmchap) + " sec");
	yaaudio = durfilmchap;
	Audio_1->show ();
	calcul_dureeslide ();
	}

	/* Shoud be in slideshow */	
	void mainfrm::bt_fermer_menu_anim_clicked () {
	// ************************************************
	// *** Fermeture de la fentre de cration d'un menu anim ***
	// ************************************************
	idtpage->setText (table_message[31]);
	m_pMPlayerWidget->slotStop ();
	creation_menu_anim->hide ();
	vframe->hide ();
	Etape_03->show ();
	}
	
	/* mPlayerwidget something: Slideshow view!? */
	void
	mainfrm::lst_video_1_doubleClicked (QListViewItem *) {
	QListViewItem *i = lst_video_1->selectedItem ();
	
	if (i != 0)
	{
	if (m_pMPlayerWidget->isPlaying () == true)
		{
		m_pMPlayerWidget->slotStop ();
		}
	else
		{
		m_pMPlayerWidget->setFilename (i->text (1));
		m_pMPlayerWidget->slotPlay ();
		}
	}
	}





	void
	mainfrm::bt_fermer_slide_clicked () {
	// **********************************************
	// *** Fermeture de la fen�tre de cr�ation des slideshows ***
	// **********************************************
	if (QMessageBox::question
	(this, MANDVDVER, table_message[18], table_message[61], table_message[62], QString::null, 0,
	1) == 0)
	{
	fen_slideshow->hide ();
	Etape_02->setEnabled (true);
	idtpage->setText (table_message[30]);
	casse_tout ();
	}
	}

	/* Add a picture to the slideshow */	
	void
	mainfrm::bt_add_img_slide_clicked () {
	
	if (nbre_images < 99)
	{
	QStringList listsfile =
		QFileDialog::getOpenFileNames
		("Images (*.jpg *.jpeg *.JPG *.JPEG *.png *.PNG)",
		dossier_travail,
		this, table_message[65], table_message[67] );
	if (listsfile.empty () == true)
		{
		}
	else
		{
		QString myfic;
		QStringList::Iterator mystrlis = listsfile.begin ();
		myfic = *mystrlis;
		QImage myimg;
		QImage tmp_img_2;
		QImage tmp_img_3;
		QColor mycolor (100, 100, 100);
		QImage wl_img2;
		QImage wl_img1;
		QImage wl_img3;
		QImage wl_img4;
		QPixmap wl_pix1 (320, 256);
		QPixmap wl_pix2 (720, 576);
		QPixmap mypix (320, 256);
		QPixmap mypix_2 (720, 576);
		QTime nowtime;
		while (mystrlis != listsfile.end () && nbre_images < 99)
		{
		myimg.load (myfic);
		tmp_img_2 = myimg.scale (320, 256, QImage::ScaleMin);
		//
		mypix.convertFromImage (tmp_img_2);
		wl_pix1.fill (Qt::black);
		wl_img1 = wl_pix1.convertToImage ();
		::bitBlt (&wl_pix1, (320 - mypix.width ()) / 2,
				(256 - mypix.height ()) / 2, &mypix, 0, 0, -1, -1,
				Qt::CopyROP, false);
		wl_img2 = wl_pix1.convertToImage ();
		//
		tmp_img_3 = myimg.scale (720, 576, QImage::ScaleMin);
		mypix_2.convertFromImage (tmp_img_3);
		wl_pix2.fill (Qt::black);
		wl_img3 = wl_pix2.convertToImage ();
		::bitBlt (&wl_pix2, (720 - mypix_2.width ()) / 2,
				(576 - mypix_2.height ()) / 2, &mypix_2, 0, 0, -1, -1,
				Qt::CopyROP, false);
		wl_img4 = wl_pix2.convertToImage ();
		nowtime = QTime::currentTime ();
		tmp_009 =
			wpathtotalproj + "GIBtmpphoto" +
			QString::number (nbre_images) + "_" +
			nowtime.toString ("hh:mm:ss.zzz") + ".png";
		wl_img4.save (tmp_009, "PNG");
		//
		int randomvalue = 0;
		tmp_001 = myfic;
		int i = myfic.findRev ('/');
		if (i != 1)
			{
			dossier_travail = myfic.mid (0, i);
			}
		else
			{
			dossier_travail = myfic;
			}
		QLabel *mylabel = new QLabel (timeline);
		mylabel->setGeometry ((10 + (nbre_images * 120)) +
					(nbre_images * 10), 6, 120, 96);
		mylabel->setPixmap (wl_img2);
		mylabel->setScaledContents (true);
		mylabel->setFrameStyle (QFrame::Box | QFrame::Plain);
		mylabel->setLineWidth (2);
		//
		mylabel->installEventFilter (this);
		//
		mylabel->show ();
		mylabel->raise ();
		QLabel *mylabel_2 = new QLabel (timeline);
		mylabel_2->setText ("Photo : " +
					QString::number (nbre_images + 1));
		mylabel_2->setGeometry ((10 + (nbre_images * 120)) +
					(nbre_images * 10), 103, 120, 14);
		mylabel_2->setPaletteForegroundColor (mycolor);
		mylabel_2->show ();
		mylabel_2->raise ();
		//
		QLabel *mylabel_3 = new QLabel (timeline);
		if (lsttransdef->currentText () == table_message[40])
			{
			mylabel_3->setPixmap (*null_transition->pixmap ());
			}
		else
			{
			QLabel *localmypix;
	
			if (lsttransdef->currentText () == table_message[51])
			{
			randomvalue = rand () % 11;
			if (randomvalue > 0)
				{
				localmypix = pnt_table_trans[randomvalue];
				}
			else
				{
				localmypix = pnt_table_trans[3];
				}
			}
			else
			{
			if (lsttransdef->currentItem () == 12)
				{
				localmypix = pnt_table_trans[11];
				}
			else
				{
				localmypix =
				pnt_table_trans[lsttransdef->currentItem ()];
				}
			}
			mylabel_3->setPixmap (*localmypix->pixmap ());
			}
	
		mylabel_3->setGeometry ((13 + (nbre_images * 120)) +
					(nbre_images * 10), 35, 40, 40);
		mylabel_3->setFrameStyle (QFrame::Box | QFrame::Plain);
		mylabel_3->setScaledContents (true);
		mylabel_3->setLineWidth (1);
		mylabel_3->setPaletteForegroundColor (mycolor);
		mylabel_3->show ();
		mylabel_3->raise ();
		box_det_photo->setEnabled (true);
		//
		table_pnt_img[nbre_images] = mylabel;
		table_pnt_txt[nbre_images][0] = mylabel_2;
		table_pnt_txt[nbre_images][1] = mylabel_3;
		table_images[nbre_images][0] = tmp_009;
		table_images[nbre_images][1] =
			QString::number (spindurdiapo->value ());
		table_images[nbre_images][3] =
			QString::number (spindurtrans->value ());
		table_color[nbre_images] = couleur_1;
		framecolor->setPaletteBackgroundColor (couleur_1);
	
		if (lsttransdef->currentText () == table_message[51])
			{
			lst_effets->setCurrentItem (randomvalue);
			table_images[nbre_images][2] = lst_effets->currentText ();
			}
		else
			{
			table_images[nbre_images][2] = lsttransdef->currentText ();
			}
	
		table_images[nbre_images][4] = "";
		nbre_images = nbre_images + 1;
		num_photo->setMaxValue (nbre_images);
		if (nbre_images > 7)
			{
			scroll_timeline->setMaxValue ((nbre_images - 7) * 130);
			}
		else
			{
			scroll_timeline->setMaxValue (0);
			}
		if (the_selection->isHidden () == true)
			{
			num_photo->setValue (1);
			num_photo->setMinValue (1);
			the_selection->setGeometry (5, -5, 130, 130);
			the_selection->show ();
			}
		else
			{
			num_photo->setValue (num_photo->maxValue ());
			}
		calcul_dureeslide ();
		++mystrlis;
		myfic = *mystrlis;
		}
		}
	}
	else
	{
	QMessageBox::warning (this, MANDVDVER, table_message[19]);
	}
	
	}

	/* Generate slideshow */	
	void
	mainfrm::bt_gener_slideshow_clicked () {
	// **************************************
	// *** G�n�ration du fichier pour le slideshow ***
	// **************************************
	
	// *** Choix du dossier de destination ***
	if (nbre_images > 0)
	{
	SFrom->setValue (0);
	STo->setMaxValue (nbre_images);
	STo->setValue (nbre_images);
	SFrom->setMaxValue (nbre_images);
	textEdit2->hide ();
	pb_004->setProgress (0);
	workinprogress->show ();
	workinprogress->raise ();
	menu_diapo_bt->setDisabled (true);
	bt_gener_slideshow->setDisabled (true);
	bt_fermer_slide->setDisabled (true);
	num_photo->setDisabled (true);
	}
	else
	{
	QMessageBox::warning (this, MANDVDVER, table_message[20]);
	}
	}
	
	void
	mainfrm::stdout_diapo () {
	// ****************************
	// *** Lecture de la sortie console ***   
	// ****************************
	lineEdit1->setText (proc_001->readStdout ());
	tmp_001 = lineEdit1->text ();
	
	
	rc_001 = tmp_001.find ("transition", 0);
	if (rc_001 != -1)
	{
	pb_004->setProgress (pb_004->progress () + 1);
	}
	
	rc_001 = tmp_001.find ("gibusima_x", 0);
	if (rc_001 != -1)
	{
	pb_004->setProgress (pb_004->progress () + 1);
	}
	
	rc_001 = tmp_001.find (" ERROR", 0);
	if (rc_001 != -1)
	{
	rc_002 = 1;
	}
	
	textEdit2->append (lineEdit1->text ());
	}

	/* Finish generation of slideshow */	
	void
	mainfrm::fin_gendiapo () {

	toolButton94->setEnabled (true);
	toolButton94_2->setEnabled (true);
	SFrom->setEnabled (true);
	STo->setEnabled (true);
	tabWidget2->setEnabled (true);
	cadre_timeline->setEnabled (true);
	
	if (rc_002 == 0)
	{
	pb_004->setProgress (100);
	bt_annul_gener_slide->setEnabled (true);
	menu_diapo_bt->setEnabled (true);
	bt_start_gener_slide->setEnabled (true);
	bt_gener_slideshow->setEnabled (true);
	bt_fermer_slide->setEnabled (true);
	num_photo->setEnabled (true);
	
	if (QMessageBox::question
		(this, MANDVDVER, table_message[21], table_message[61], table_message[62], QString::null, 0,
		1) == 0)
		{
		proc_003 = new QProcess (this);
		proc_003->addArgument ("xine");
		proc_003->addArgument (wpathtotalproj + "/" + tmp_009 + ".vob");
		if (!proc_003->start ())
		{
		QMessageBox::warning (this, MANDVDVER,
					table_message[0] + "xine");
		}
		}
	if (QMessageBox::question
		(this, MANDVDVER, table_message[22], table_message[61], table_message[62], QString::null, 0,
		1) == 0)
		{
		workinprogress->hide ();
		fen_slideshow->hide ();
		path_video = path_out->text () + "/" + tmp_009 + ".vob";
		video_size_ok = 0;
		video_codec_ok = 0;
		audio_freq_ok = 0;
		multiangle = 0;
		audio_bitrate = 0;
		yaaudio = 0;
		rc_004 = 0;
		Etape_02->setEnabled (true);
		video_format = "4/3";
		pathnamevideo->hide ();
		theformat->hide ();
		panneau_bouton_1->setDisabled (true);
		lineEdit8->setText ("");
		appimgbt->hide ();
		panneau_titre->show ();
		panneau_titre->raise ();
		tmp_001 = path_video;
		int cpt_001 = tmp_001.length ();
		while (tmp_001.mid (cpt_001, 1) != "/" && cpt_001 != 0)
		{
		cpt_001 = cpt_001 - 1;
		}
	
		if (cpt_001 > 0)
		{
		titre_element->setText (tmp_001.mid (cpt_001 + 1,
							tmp_001.length () -
							(cpt_001 + 5)));
		}
		else
		{
		titre_element->setText ("");
		}
		bt_et02_con->setDisabled (true);
		a_reencoder = "0";
		// *** R�cup info vid�o ***
		proc_001 = new QProcess (this);
		proc_001->addArgument ("tcprobe");
		proc_001->addArgument ("-i");
		proc_001->addArgument (path_video);
	
		connect (proc_001, SIGNAL (readyReadStdout ()), this,
			SLOT (test_type_video ()));
		connect (proc_001, SIGNAL (processExited ()), this,
			SLOT (fin_import ()));
		if (!proc_001->start ())
		{
		QMessageBox::warning (this, MANDVDVER,
					table_message[0] + "transcode");
		}
		idtpage->setText (table_message[30]);
		//
		casse_tout ();
		}
	}
	else
	{
	QMessageBox::warning (this, MANDVDVER, table_message[23]);
	bt_annul_gener_slide->setEnabled (true);
	menu_diapo_bt->setEnabled (true);
	bt_start_gener_slide->setEnabled (true);
	bt_gener_slideshow->setEnabled (true);
	bt_fermer_slide->setEnabled (true);
	num_photo->setEnabled (true);
	}
	}
	
	void
	mainfrm::num_photo_valueChanged (int) {
	// ********************************
	// *** On d�place le cadre de s�lection ***
	// ********************************
	the_selection->setGeometry (5 + (130 * (num_photo->value () - 1)), -5, 130,
				130);
	// *** Modification des param�tres de la photo ***
	
	if (num_photo->value () > 0 && nbre_images > 0)
	{
	QLabel *mypix;
	mypix = table_pnt_img[num_photo->value () - 1];
	apercu_photo_diapo->setPixmap (*mypix->pixmap ());
	tmp_004 = table_images[num_photo->value () - 1][1];
	QIconViewItem *myi =
		mylsttrans->findItem (table_images[num_photo->value () - 1][2],
				Qt::ExactMatch);
	if (myi != 0)
		{
		myi->setSelected (true);
		}
	txt_img->setText (table_images[num_photo->value () - 1][4]);
	rc_001 = tmp_004.toInt (&ok, 10);
	if (ok == true)
		{
		duree_affichage->setValue (rc_001);
		}
	tmp_004 = table_images[num_photo->value () - 1][3];
	rc_001 = tmp_004.toInt (&ok, 10);
	framecolor->setPaletteBackgroundColor (table_color
						[num_photo->value () - 1]);
	if (ok == true)
		{
		duree_transition->setValue (rc_001);
		}
	bt_dep_gauche->setGeometry ((5 + (130 * (num_photo->value () - 1))) +
					10, 116, 21, 21);
	bt_dep_droite->setGeometry ((5 + (130 * (num_photo->value () - 1))) +
					99, 116, 21, 21);
	bt_dep_gauche->show ();
	bt_dep_droite->show ();
	bt_dep_gauche->raise ();
	bt_dep_droite->raise ();
	// *** D�placement automatique de la timeline ***
	QRect locposition = the_selection->geometry ();
	QRect locpostime = timeline->geometry ();
	if (locposition.left () > ((locpostime.left () * -1) + 980))
		{
		timeline->setGeometry ((locposition.left () * -1), 25, 13500, 140);
		scroll_timeline->setValue ((locposition.left () * -1));
		}
	else
		{
		if (locposition.left () < (locpostime.left () * -1))
		{
		if (num_photo->value () > 7)
			{
			timeline->setGeometry (locposition.left () * -1, 25, 13500,
						140);
			scroll_timeline->setValue (locposition.left ());
			}
		else
			{
			timeline->setGeometry (0, 25, 13500, 140);
			scroll_timeline->setValue (0);
			}
		}
		}
	}
	}

	/* Remove picture from slideshow */	
	void
	mainfrm::casse_tout () {
	// ************************************
	// *** Destruction des images du diaporama ***
	// ************************************
	int indice0;
	indice0 = 0;
	while (indice0 < nbre_images)
	{
	delete table_pnt_img[indice0];
	delete table_pnt_txt[indice0][0];
	delete table_pnt_txt[indice0][1];
	indice0 = indice0 + 1;
	}
	nbre_images = 0;
	}
	
	/* Select music to slideshow */
	void
	mainfrm::bt_select_zik_clicked () {
	// **************************************
	// *** S�lection du fond musical du diaporama ***
	// **************************************
	if (nbre_images > 0)
	{
	QString myfic = QFileDialog::getOpenFileName (dossier_travail,
							"Images (*.wav *.WAV *.mp3 *.MP3 *.ogg *.OGG)",
							this, table_message[65], table_message[69] );
	if (myfic.isNull ())
		{
		if (QMessageBox::question
		(this, MANDVDVER, table_message[24], table_message[61], table_message[62], QString::null,
		0, 1) == 0)
		{
		path_musique = "";
		bt_musique_options->setDisabled (true);
		}
		}
	else
		{
		bt_musique_options->setEnabled (true);
		calczik (myfic);
		}
	}
	else
	{
	QMessageBox::warning (this, MANDVDVER, table_message[20]);
	}
	}


	/* Generate transistion in slideshow  */	
	void
	mainfrm::gotrans () {

	// ****************************************
	// *** G�n�ration des transitions et du slideshow ***
	// ****************************************
	if (SFrom->value () > STo->value ())
	{
	STo->setValue (SFrom->value ());
	}
	if (STo->value () < SFrom->value ())
	{
	STo->setValue (SFrom->value ());
	}
	QPixmap my_pixmap_3;
	QPainter mypainter (this);
	int cpt_001;
	cpt_001 = SFrom->value () - 1;
	int cpt_002;
	int cpt_003;
	int depx;
	int depy;
	int posx;
	int posy;
	int curx;
	int cury;
	int curz;
	QString S_wduratrans;
	int wfpstrans = sliderfps->value ();
	int wduratrans = 100 / wfpstrans;
	if (wduratrans < 10)
	{
	S_wduratrans = "0" + QString::number (wduratrans);
	}
	else
	{
	S_wduratrans = QString::number (wduratrans);
	}
	int total_step = 0;
	QImage tmp_img_1;
	QImage tmp_img_2;
	QImage tmp_img_3;
	QPixmap wl_pix_1 (720, 576);
	QPixmap wl_pix_2 (720, 576);
	QPixmap wl_pix_3 (720, 576);
	QPixmap wl_pix_4 (720, 576);
	tmp_006 = "";
	progress = 0;
	QTime mytime (0, 0, 0);
	QTime mytime_2 (0, 0, 0);
	QFile myfic (wpathtotalproj + "/slideshow.txt");
	if (myfic.open (IO_WriteOnly))
	{
	while (cpt_001 < STo->value ())
		{
		// *** Pas de chapitres sur la derni�re image ***
		if (cpt_001 < nbre_images - 1)
		{
		if (table_images[cpt_001][2] != table_message[40])
			{
			progress = table_images[cpt_001][3].toInt (&ok, 10);
			mytime_2 = mytime.addSecs (progress);
			progress = table_images[cpt_001][1].toInt (&ok, 10);
			mytime = mytime_2.addSecs (progress);
			tmp_006 = tmp_006 + mytime.toString ("hh:mm:ss") + ",";
			}
		else
			{
			mytime_2 = mytime.addSecs (0);
			progress = table_images[cpt_001][1].toInt (&ok, 10);
			mytime = mytime_2.addSecs (progress);
			tmp_006 = tmp_006 + mytime.toString ("hh:mm:ss") + ",";
			}
		}
		//
		if (table_images[cpt_001][2] == table_message[41])
		{
		if (cpt_001 == 0 || cpt_001 == SFrom->value () - 1)
			{
			tmp_001 = "fadein:" + table_images[cpt_001][3] + ":\n";
			myfic.writeBlock (tmp_001, tmp_001.length ());
			}
		else
			{
			tmp_001 = "fadeout:" + table_images[cpt_001][3] + ":\n";
			myfic.writeBlock (tmp_001, tmp_001.length ());
			}
		}
		else
		{
		if (table_images[cpt_001][2] == table_message[42])
			{
			tmp_001 = "fadein:" + table_images[cpt_001][3] + ":\n";
			myfic.writeBlock (tmp_001, tmp_001.length ());
			}
		else
			{
			if (table_images[cpt_001][2] == table_message[43])
			{
			if (cpt_001 == 0 || cpt_001 == SFrom->value () - 1)
				{
				tmp_001 =
				"fadein:" + table_images[cpt_001][3] + ":\n";
				myfic.writeBlock (tmp_001, tmp_001.length ());
				}
			else
				{
				tmp_001 =
				"crossfade:" + table_images[cpt_001][3] + ":\n";
				myfic.writeBlock (tmp_001, tmp_001.length ());
				}
			}
			}
		}
	
		// *** Transition fire ************************************************
	
		if (table_images[cpt_001][2] == "Fire")
		{
		if (cpt_001 > 0)
			{
			tmp_img_1.load (table_images[cpt_001 - 1][0]);
			}
		else
			{
			tmp_img_1.load (table_images[cpt_001][0]);
			tmp_img_1.fill (0);
			}
		my_stamp_1->pixmap ()->convertFromImage (tmp_img_1);
		wl_pix_4.convertFromImage (tmp_img_1);
		tmp_img_1.load (table_images[cpt_001][0]);
		my_stamp_2->pixmap ()->convertFromImage (tmp_img_1);
		wl_pix_1.convertFromImage (tmp_img_1);
		tmp_img_2 = pixflam->pixmap ()->convertToImage ();
		wl_pix_2.convertFromImage (tmp_img_2);
		tmp_004 = table_images[cpt_001][3];
		rc_001 = tmp_004.toInt (&ok, 10);
	
		if (ok == true)
			{
			cpt_002 = rc_001 * wfpstrans;
			depx = 576 / cpt_002;
			cpt_003 = 0;
			curx = 576;
			while (cpt_003 < cpt_002)
			{
			posx = curx - depx;
			curx = posx;
			wl_pix_3.fill (Qt::black);
			::bitBlt (&wl_pix_3, 0, 0, &wl_pix_4, 0, 0, -1, -1,
					Qt::CopyROP, false);
			if (cpt_001 > 0)
				{
				::bitBlt (&wl_pix_3, 0, curx, &wl_pix_2, 0, 0, -1,
					-1, Qt::CopyROP, false);
				}
			else
				{
				::bitBlt (&wl_pix_3, 0, curx, &wl_pix_2, 0, 0, -1,
					-1, Qt::CopyROP, false);
				}
			wl_pix_3.save (wpathtotalproj + "/transition" +
					QString::number (cpt_001) + "_" +
					QString::number (cpt_003) + ".jpg",
					"JPEG");
			tmp_001 =
				"transition" + QString::number (cpt_001) + "_" +
				QString::number (cpt_003) + ".jpg:0." + S_wduratrans +
				":\n";
			myfic.writeBlock (tmp_001, tmp_001.length ());
			total_step = total_step + 1;
			cpt_003 = cpt_003 + 1;
			}
			tmp_001 = "crossfade:0.5:\n";
			myfic.writeBlock (tmp_001, tmp_001.length ());
			}
		}
	
		// *** Transition droite a gauche ************************************************
	
		if (table_images[cpt_001][2] == table_message[44])
		{
		if (cpt_001 > 0)
			{
			tmp_img_1.load (table_images[cpt_001 - 1][0]);
			}
		else
			{
			tmp_img_1.load (table_images[cpt_001][0]);
			tmp_img_1.fill (0);
			}
		my_stamp_1->pixmap ()->convertFromImage (tmp_img_1);
		tmp_img_1.load (table_images[cpt_001][0]);
		my_stamp_2->pixmap ()->convertFromImage (tmp_img_1);
	
		tmp_004 = table_images[cpt_001][3];
		rc_001 = tmp_004.toInt (&ok, 10);
	
		if (ok == true)
			{
			cpt_002 = rc_001 * wfpstrans;
			depx = 720 / cpt_002;
			cpt_003 = 0;
			curx = 720;
			while (cpt_003 < cpt_002)
			{
			posx = curx - depx;
			curx = posx;
			copyBlt (my_stamp_1->pixmap (), posx, 0,
				my_stamp_2->pixmap (), 0, 0, -1, -1);
			my_stamp_1->pixmap ()->save (wpathtotalproj +
							"/transition" +
							QString::number (cpt_001) +
							"_" +
							QString::number (cpt_003) +
							".jpg", "JPEG");
			tmp_001 =
				"transition" + QString::number (cpt_001) + "_" +
				QString::number (cpt_003) + ".jpg:0." + S_wduratrans +
				":\n";
			myfic.writeBlock (tmp_001, tmp_001.length ());
			total_step = total_step + 1;
			cpt_003 = cpt_003 + 1;
			}
			}
		}
		// *** Transition gauche a droite ************************************************
	
		if (table_images[cpt_001][2] == table_message[45])
		{
		if (cpt_001 > 0)
			{
			tmp_img_1.load (table_images[cpt_001 - 1][0]);
			}
		else
			{
			tmp_img_1.load (table_images[cpt_001][0]);
			tmp_img_1.fill (0);
			}
		my_stamp_1->pixmap ()->convertFromImage (tmp_img_1);
		tmp_img_1.load (table_images[cpt_001][0]);
		my_stamp_2->pixmap ()->convertFromImage (tmp_img_1);
	
		tmp_004 = table_images[cpt_001][3];
		rc_001 = tmp_004.toInt (&ok, 10);
	
		if (ok == true)
			{
			cpt_002 = rc_001 * wfpstrans;
			depx = 720 / cpt_002;
			cpt_003 = 0;
			curx = 0;
	
			while (cpt_003 < cpt_002)
			{
			posx = curx + depx;
			curx = posx;
			copyBlt (my_stamp_1->pixmap (), 0, 0,
				my_stamp_2->pixmap (), 720 - posx, 0, -1, -1);
			my_stamp_1->pixmap ()->save (wpathtotalproj +
							"/transition" +
							QString::number (cpt_001) +
							"_" +
							QString::number (cpt_003) +
							".jpg", "JPEG");
			tmp_001 =
				"transition" + QString::number (cpt_001) + "_" +
				QString::number (cpt_003) + ".jpg:0." + S_wduratrans +
				":\n";
			myfic.writeBlock (tmp_001, tmp_001.length ());
			total_step = total_step + 1;
			cpt_003 = cpt_003 + 1;
			}
			}
		}
	
		// *** Transition bas en haut ************************************************
	
		if (table_images[cpt_001][2] == table_message[46])
		{
		if (cpt_001 > 0)
			{
			tmp_img_1.load (table_images[cpt_001 - 1][0]);
			}
		else
			{
			tmp_img_1.load (table_images[cpt_001][0]);
			tmp_img_1.fill (0);
			}
		my_stamp_1->pixmap ()->convertFromImage (tmp_img_1);
		tmp_img_1.load (table_images[cpt_001][0]);
		my_stamp_2->pixmap ()->convertFromImage (tmp_img_1);
	
		tmp_004 = table_images[cpt_001][3];
		rc_001 = tmp_004.toInt (&ok, 10);
	
		if (ok == true)
			{
			cpt_002 = rc_001 * wfpstrans;
			depx = 576 / cpt_002;
			cpt_003 = 0;
			curx = 576;
	
			while (cpt_003 < cpt_002)
			{
			posx = curx - depx;
			curx = posx;
			copyBlt (my_stamp_1->pixmap (), 0, posx,
				my_stamp_2->pixmap (), 0, 0, -1, -1);
			my_stamp_1->pixmap ()->save (wpathtotalproj +
							"/transition" +
							QString::number (cpt_001) +
							"_" +
							QString::number (cpt_003) +
							".jpg", "JPEG");
			tmp_001 =
				"transition" + QString::number (cpt_001) + "_" +
				QString::number (cpt_003) + ".jpg:0." + S_wduratrans +
				":\n";
			myfic.writeBlock (tmp_001, tmp_001.length ());
			total_step = total_step + 1;
			cpt_003 = cpt_003 + 1;
			}
			}
		}
	
		// *** Transition haut en bas ************************************************
	
		if (table_images[cpt_001][2] == table_message[47])
		{
		if (cpt_001 > 0)
			{
			tmp_img_1.load (table_images[cpt_001 - 1][0]);
			}
		else
			{
			tmp_img_1.load (table_images[cpt_001][0]);
			tmp_img_1.fill (0);
			}
		my_stamp_1->pixmap ()->convertFromImage (tmp_img_1);
		tmp_img_1.load (table_images[cpt_001][0]);
		my_stamp_2->pixmap ()->convertFromImage (tmp_img_1);
	
		tmp_004 = table_images[cpt_001][3];
		rc_001 = tmp_004.toInt (&ok, 10);
	
		if (ok == true)
			{
			cpt_002 = rc_001 * wfpstrans;
			depx = 576 / cpt_002;
			cpt_003 = 0;
			curx = 0;
	
			while (cpt_003 < cpt_002)
			{
			posx = curx + depx;
			curx = posx;
			copyBlt (my_stamp_1->pixmap (), 0, 0,
				my_stamp_2->pixmap (), 0, 576 - posx, -1, -1);
			my_stamp_1->pixmap ()->save (wpathtotalproj +
							"/transition" +
							QString::number (cpt_001) +
							"_" +
							QString::number (cpt_003) +
							".jpg", "JPEG");
			tmp_001 =
				"transition" + QString::number (cpt_001) + "_" +
				QString::number (cpt_003) + ".jpg:0." + S_wduratrans +
				":\n";
			myfic.writeBlock (tmp_001, tmp_001.length ());
			total_step = total_step + 1;
			cpt_003 = cpt_003 + 1;
			}
			}
		}
	
		// *** Transition zoom ************************************************
	
		if (table_images[cpt_001][2] == table_message[48])
		{
		if (cpt_001 > 0)
			{
			tmp_img_1.load (table_images[cpt_001 - 1][0]);
			}
		else
			{
			tmp_img_1.load (table_images[cpt_001][0]);
			tmp_img_1.fill (0);
			}
		my_stamp_1->pixmap ()->convertFromImage (tmp_img_1);
		tmp_img_1.load (table_images[cpt_001][0]);
		my_stamp_2->pixmap ()->convertFromImage (tmp_img_1);
		tmp_img_2 = my_stamp_2->pixmap ()->convertToImage ();
		tmp_004 = table_images[cpt_001][3];
		rc_001 = tmp_004.toInt (&ok, 10);
	
		if (ok == true)
			{
			cpt_002 = rc_001 * wfpstrans;
			depx = 360 / cpt_002;
			depy = 288 / cpt_002;
			cpt_003 = 0;
			curx = 360 + depx;
			cury = 288 + depy;
	
			while (cpt_003 < cpt_002)
			{
			tmp_img_3 =
				tmp_img_2.scale (((720 / 2) - curx) * 2,
						((576 / 2) - cury) * 2,
						QImage::ScaleMin);
			my_stamp_3->pixmap ()->convertFromImage (tmp_img_3);
			posx = curx - depx;
			posy = cury - depy;
			curx = posx;
			cury = posy;
			//copyBlt ( my_stamp_1->pixmap(), curx, cury, my_stamp_3->pixmap(), 0, 0, -1, -1 );
			copyBlt (my_stamp_1->pixmap (),
				360 - (tmp_img_3.width () / 2),
				288 - (tmp_img_3.height () / 2),
				my_stamp_3->pixmap (), 0, 0, -1, -1);
			my_stamp_1->pixmap ()->save (wpathtotalproj +
							"/transition" +
							QString::number (cpt_001) +
							"_" +
							QString::number (cpt_003) +
							".jpg", "JPEG");
			tmp_001 =
				"transition" + QString::number (cpt_001) + "_" +
				QString::number (cpt_003) + ".jpg:0." + S_wduratrans +
				":\n";
			myfic.writeBlock (tmp_001, tmp_001.length ());
			total_step = total_step + 1;
			cpt_003 = cpt_003 + 1;
			}
			}
		}
	
		// *** Transition double ************************************************
	
		if (table_images[cpt_001][2] == table_message[49])
		{
		if (cpt_001 > 0)
			{
			tmp_img_1.load (table_images[cpt_001 - 1][0]);
			}
		else
			{
			tmp_img_1.load (table_images[cpt_001][0]);
			tmp_img_1.fill (0);
			}
		my_stamp_1->pixmap ()->convertFromImage (tmp_img_1);
		tmp_img_1.load (table_images[cpt_001][0]);
		my_stamp_2->pixmap ()->convertFromImage (tmp_img_1);
	
		tmp_004 = table_images[cpt_001][3];
		rc_001 = tmp_004.toInt (&ok, 10);
	
		if (ok == true)
			{
			cpt_002 = rc_001 * wfpstrans;
			depx = 576 / cpt_002;
			cpt_003 = 0;
			curx = 0;
			cury = 576;
	
			while (cpt_003 < cpt_002)
			{
			posx = curx + depx;
			posy = cury - depx;
			curx = posx;
			cury = posy;
			copyBlt (my_stamp_1->pixmap (), 0, 0,
				my_stamp_2->pixmap (), 0, 576 - posx, 360, -1);
			copyBlt (my_stamp_1->pixmap (), 360, cury,
				my_stamp_2->pixmap (), 360, 0, 360, -1);
			my_stamp_1->pixmap ()->save (wpathtotalproj +
							"/transition" +
							QString::number (cpt_001) +
							"_" +
							QString::number (cpt_003) +
							".jpg", "JPEG");
			tmp_001 =
				"transition" + QString::number (cpt_001) + "_" +
				QString::number (cpt_003) + ".jpg:0." + S_wduratrans +
				":\n";
			myfic.writeBlock (tmp_001, tmp_001.length ());
			total_step = total_step + 1;
			cpt_003 = cpt_003 + 1;
			}
			}
		}
	
		// *** Transition haut et bas ************************************************
	
		if (table_images[cpt_001][2] == table_message[50])
		{
		if (cpt_001 > 0)
			{
			tmp_img_1.load (table_images[cpt_001 - 1][0]);
			}
		else
			{
			tmp_img_1.load (table_images[cpt_001][0]);
			tmp_img_1.fill (0);
			}
		my_stamp_1->pixmap ()->convertFromImage (tmp_img_1);
		tmp_img_1.load (table_images[cpt_001][0]);
		my_stamp_2->pixmap ()->convertFromImage (tmp_img_1);
	
		tmp_004 = table_images[cpt_001][3];
		rc_001 = tmp_004.toInt (&ok, 10);
	
		if (ok == true)
			{
			cpt_002 = rc_001 * wfpstrans;
			depx = 288 / cpt_002;
			cpt_003 = 0;
			curx = 0;
			cury = 576;
			curz = -288;
	
			while (cpt_003 < cpt_002)
			{
			posx = curx + depx;
			posy = cury - depx;
			curz = curz + depx;
			curx = posx;
			cury = posy;
			copyBlt (my_stamp_1->pixmap (), 0, curz,
				my_stamp_2->pixmap (), 0, 0, -1, 288);
			copyBlt (my_stamp_1->pixmap (), 0, cury,
				my_stamp_2->pixmap (), 0, 289, -1, -1);
			my_stamp_1->pixmap ()->save (wpathtotalproj +
							"/transition" +
							QString::number (cpt_001) +
							"_" +
							QString::number (cpt_003) +
							".jpg", "JPEG");
			tmp_001 =
				"transition" + QString::number (cpt_001) + "_" +
				QString::number (cpt_003) + ".jpg:0." + S_wduratrans +
				":\n";
			myfic.writeBlock (tmp_001, tmp_001.length ());
			total_step = total_step + 1;
			cpt_003 = cpt_003 + 1;
			}
			}
		}
	
		// *** Fin du calcul des transitions *************************************
		tmp_001 =
		"gibusima_x" + QString::number (cpt_001) + ".jpg:" +
		table_images[cpt_001][1] + "::\n";
		total_step = total_step + 1;
		myfic.writeBlock (tmp_001, tmp_001.length ());
		cpt_001 = cpt_001 + 1;
		if (cpt_001 == nbre_images)
		{
		if (bt_add_fondu_fin->isChecked () == true)
			{
			tmp_001 = "fadeout:2:\n";
			myfic.writeBlock (tmp_001, tmp_001.length ());
			}
		}
		}
	myfic.close ();
	
	QFile myfic_2 (wpathtotalproj + "/gendiapo.sh");
	if (myfic_2.open (IO_WriteOnly))
		{
		tmp_001 = "#!/bin/bash\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		tmp_001 = "cd \"" + wpathtotalproj + "\"\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		cpt_001 = 0;
		while (cpt_001 < nbre_images)
		{
		tmp_img_1.load (table_images[cpt_001][0]);
		//tmp_img_2 = tmp_img_1.scale(720, 576,QImage::ScaleMax);
		my_stamp_2->pixmap ()->convertFromImage (tmp_img_1);
		// *** Ajout du texte sur la diapo ***
		myfont.setFixedPitch (true);
		QFontMetrics fm (myfont);
		longueur =
			fm.width ("\"" + table_images[cpt_001][4] + "\"", -1);
		hauteur = (taille_police + 2) * 2;
		mypainter.end ();
		mypainter.begin (my_stamp_2->pixmap ());
		mypainter.setPen (table_color[cpt_001]);
		mypainter.setFont (myfont);
		mypainter.drawText ((720 - longueur) / 2, 500,
					table_images[cpt_001][4]);
		//
		my_stamp_2->pixmap ()->save (wpathtotalproj + "/gibusima_x" +
						QString::number (cpt_001) + ".jpg",
						"JPEG");
		cpt_001 = cpt_001 + 1;
		}
		if (qualite_render->isChecked () == true)
		{
		tmp_002 = "";
		}
		else
		{
		tmp_002 = "-L";
		}
		QTime nowtime;
		nowtime = QTime::currentTime ();
		tmp_009 = "slideshow_" + nowtime.toString ("hh:mm:ss");
		if (path_musique != "")
		{
		if (videostandard->currentText () == "PAL")
			{
			tmp_001 =
			"nice -n 0 dvd-slideshow -o \"" + wpathtotalproj +
			"\" -n '" + tmp_009 + "' -p " + tmp_002 +
			" -f slideshow.txt -a \"" + path_musique + "\"\n";
			}
		else
			{
			tmp_001 =
			"nice -n 0 dvd-slideshow -o \"" + wpathtotalproj +
			"\" -n '" + tmp_009 + "' " + tmp_002 +
			" -f slideshow.txt -a \"" + path_musique + "\"\n";
			}
		}
		else
		{
		if (videostandard->currentText () == "PAL")
			{
			tmp_001 =
			"nice -n 0 dvd-slideshow -o \"" + wpathtotalproj +
			"\" -n '" + tmp_009 + "' -p -f slideshow.txt\n";
			}
		else
			{
			tmp_001 =
			"nice -n 0 dvd-slideshow -o \"" + wpathtotalproj +
			"\" -n '" + tmp_009 + "' -f slideshow.txt\n";
			}
		}
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		tmp_001 = "rm -f " + wpathtotalproj + "/gibusima_x*.*\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		tmp_001 = "rm -f " + wpathtotalproj + "/transition*.*\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		tmp_001 = "rm -f " + wpathtotalproj + "/slideshow.txt\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		tmp_001 = "rm -f " + wpathtotalproj + "/slideshow.xml\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		tmp_001 = "rm -f " + wpathtotalproj + "/*.log\n";
		myfic_2.writeBlock (tmp_001, tmp_001.length ());
		myfic_2.close ();
		}
	}
	pb_004->setTotalSteps (total_step);
	rc_002 = 0;
	proc_001 = new QProcess (this);
	proc_001->addArgument ("bash");
	proc_001->addArgument (wpathtotalproj + "/gendiapo.sh");
	connect (proc_001, SIGNAL (readyReadStdout ()), this,
		SLOT (stdout_diapo ()));
	connect (proc_001, SIGNAL (processExited ()), this, SLOT (fin_gendiapo ()));
	if (!proc_001->start ())
	{
	QMessageBox::warning (this, MANDVDVER,
				table_message[0] + "dvd-slideshow");
	workinprogress->hide ();
	bt_gener_slideshow->setEnabled (true);
	bt_fermer_slide->setEnabled (true);
	num_photo->setEnabled (true);
	tabWidget2->setEnabled (true);
	cadre_timeline->setEnabled (true);
	}
	}
	
	void
	mainfrm::bt_annul_gener_slide_clicked () {
	// *****************************************
	// *** Annulation de la g�n�ration du diaporama ***
	// *****************************************
	workinprogress->hide ();
	menu_diapo_bt->setEnabled (true);
	bt_gener_slideshow->setEnabled (true);
	bt_fermer_slide->setEnabled (true);
	num_photo->setEnabled (true);
	}
	
	void
	mainfrm::bt_start_gener_slide_clicked () {
	// *****************************************
	// *** D�marrage de la g�n�ration du diaporama ***
	// *****************************************
	bt_annul_gener_slide->setDisabled (true);
	bt_start_gener_slide->setDisabled (true);
	toolButton94->setDisabled (true);
	toolButton94_2->setDisabled (true);
	SFrom->setDisabled (true);
	STo->setDisabled (true);
	pb_004->setProgress (0);
	tabWidget2->setDisabled (true);
	cadre_timeline->setDisabled (true);
	gotrans ();
	}
	
	void
	mainfrm::bt_aff_con_diapo_clicked () {
	// ************************
	// *** Switch console diapo ***
	// ************************
	if (textEdit2->isVisible () == true)
	{
	textEdit2->hide ();
	}
	else
	{
	textEdit2->show ();
	textEdit2->raise ();
	}
	}
	
	void
	mainfrm::bt_fond_mus_clicked () {
	// ***************************
	// *** S�lection du fond musical ***
	// ***************************
	QString myfic = QFileDialog::getOpenFileName ("~",
							"Images (*.wav *.WAV *.MP3 *.mp3 *.ogg *.OGG)",
							this, table_message[65], table_message[69] );
	if (myfic.isNull ())
	{
	if (QMessageBox::question
		(this, MANDVDVER, table_message[24], table_message[61], table_message[62], QString::null, 0,
		1) == 0)
		{
		path_fond_musical = "";
		loopsound->setCurrentItem (0);
		loopsound->setDisabled (true);
		}
	}
	else
	{
	path_fond_musical = myfic;
	loopsound->setEnabled (true);
	}
	}
	
	void
	mainfrm::bt_affcach_con_grave_clicked () {
	// ********************************************
	// *** Affichage ou pas de la console dans le gravage ***
	// ********************************************
	if (textEdit3->isVisible () == true)
	{
	textEdit3->hide ();
	}
	else
	{
	textEdit3->show ();
	textEdit3->raise ();
	}
	}

	/* Choose font type */	
	void
	mainfrm::bt_choix_police_titre_clicked () {
	// **********************************
	// *** Sélection de la police de caractére ***
	// **********************************
	myfont = QFontDialog::getFont (&ok, QFont ("Helvetica [Cronyx]", 10), this);
	taille_police = myfont.pointSize ();
	app_pol_txt->setFont (myfont);
	}

	/* Choose colour of slideshow title */	
	void
	mainfrm::bt_choix_couleur_titre_clicked () {
	// *****************************************
	// *** Choix de la couleur des titres du diaporama ***
	// *****************************************
	couleur_1 =
	QColorDialog::getColor (couleur_1, this, table_message[71] );
	}
	
	void
	mainfrm::bt_add_img_slide_2_clicked () {
	// **********************************************
	// *** Importation de l'ensemble des images d'un dossier ***
	// **********************************************
	pb_import->setProgress (0);
	QImage myimg;
	QImage tmp_img_2;
	QString myfic;
	QString ext;
	int cpt1;
	QColor mycolor (100, 100, 100);
	
	QString mypath = QFileDialog::getExistingDirectory 
		(dossier_travail, this, table_message[65], table_message[67], TRUE);

	if (mypath.isNull () == true)
	{
	}
	else
	{
	QDir d;
	dossier_travail = mypath;
	d.setPath (mypath);
	pb_import->setTotalSteps (d.count ());
	d.setFilter (QDir::Files | QDir::NoSymLinks);
	const QFileInfoList *list = d.entryInfoList ();
	QFileInfoListIterator it (*list);
	QFileInfo *fi;
	QPixmap wl_pix1 (320, 256);
	QPixmap wl_pix2 (720, 576);
	QImage wl_img1;
	QImage wl_img2;
	QPixmap mypix (320, 256);
	QPixmap mypix_2 (720, 576);
	QImage wl_img4;
	QTime nowtime;
	int randomvalue;
	tmp_002 = d.path ();
	cpt1 = 0;
	
	while ((fi = it.current ()) != 0 && nbre_images < 99)
		{
		tmp_003 = fi->fileName ().latin1 ();
		myfic = fi->fileName ().latin1 ();
		ext = fi->extension (FALSE);
		cpt1 = cpt1 + 1;
		pb_import->setProgress (cpt1);
		if (ext == "jpg" || ext == "jpeg" || ext == "JPG" || ext == "JPEG"
		|| ext == "png" || ext == "PNG")
		{
		tmp_004 = tmp_002 + "/" + tmp_003;
		myimg.load (tmp_004);
		tmp_img_2 = myimg.scale (320, 256, QImage::ScaleMin);
		//
		mypix.convertFromImage (tmp_img_2);
		wl_pix1.fill (Qt::black);
		wl_img1 = wl_pix1.convertToImage ();
		::bitBlt (&wl_pix1, (320 - mypix.width ()) / 2,
				(256 - mypix.height ()) / 2, &mypix, 0, 0, -1, -1,
				Qt::CopyROP, false);
		wl_img2 = wl_pix1.convertToImage ();
		tmp_001 = myfic;
		QLabel *mylabel = new QLabel (timeline);
		mylabel->setScaledContents (true);
		mylabel->setGeometry ((10 + (nbre_images * 120)) +
					(nbre_images * 10), 6, 120, 96);
		mylabel->setPixmap (wl_img2);
		//
		mylabel->installEventFilter (this);
		//
		mylabel->setFrameStyle (QFrame::Box | QFrame::Plain);
		mylabel->setLineWidth (2);
		mylabel->show ();
		mylabel->raise ();
		QLabel *mylabel_2 = new QLabel (timeline);
		mylabel_2->setText ("Photo : " +
					QString::number (nbre_images + 1));
		mylabel_2->setGeometry ((10 + (nbre_images * 120)) +
					(nbre_images * 10), 103, 120, 14);
		mylabel_2->setPaletteForegroundColor (mycolor);
		mylabel_2->show ();
		mylabel_2->raise ();
		//
		tmp_img_2 = myimg.scale (720, 576, QImage::ScaleMin);
		mypix_2.convertFromImage (tmp_img_2);
		wl_pix2.fill (Qt::black);
		wl_img1 = wl_pix2.convertToImage ();
		::bitBlt (&wl_pix2, (720 - mypix_2.width ()) / 2,
				(576 - mypix_2.height ()) / 2, &mypix_2, 0, 0, -1, -1,
				Qt::CopyROP, false);
		wl_img4 = wl_pix2.convertToImage ();
		nowtime = QTime::currentTime ();
		tmp_009 =
			wpathtotalproj + "GIBtmpphoto" +
			QString::number (nbre_images) + "_" +
			nowtime.toString ("hh:mm:ss.zzz") + ".png";
		wl_img4.save (tmp_009, "PNG");
		//
		QLabel *mylabel_3 = new QLabel (timeline);
		if (lsttransdef->currentText () == table_message[40])
			{
			mylabel_3->setPixmap (*null_transition->pixmap ());
			}
		else
			{
			QLabel *localmypix;
			if (lsttransdef->currentText () == table_message[51])
			{
			randomvalue = rand () % 11;
			if (randomvalue > 0)
				{
				localmypix = pnt_table_trans[randomvalue];
				}
			else
				{
				localmypix = pnt_table_trans[3];
				}
			}
			else
			{
			if (lsttransdef->currentItem () == 12)
				{
				localmypix = pnt_table_trans[11];
				}
			else
				{
				localmypix =
				pnt_table_trans[lsttransdef->currentItem ()];
				}
			}
			mylabel_3->setPixmap (*localmypix->pixmap ());
			}
	
		mylabel_3->setGeometry ((13 + (nbre_images * 120)) +
					(nbre_images * 10), 35, 40, 40);
		mylabel_3->setFrameStyle (QFrame::Box | QFrame::Plain);
		mylabel_3->setScaledContents (true);
		mylabel_3->setLineWidth (1);
		mylabel_3->setPaletteForegroundColor (mycolor);
		mylabel_3->show ();
		mylabel_3->raise ();
		//
		table_pnt_img[nbre_images] = mylabel;
		table_pnt_txt[nbre_images][0] = mylabel_2;
		table_pnt_txt[nbre_images][1] = mylabel_3;
		table_images[nbre_images][0] = tmp_009;
		table_images[nbre_images][1] =
			QString::number (spindurdiapo->value ());
		table_color[nbre_images] = couleur_1;
		framecolor->setPaletteBackgroundColor (couleur_1);
		if (lsttransdef->currentText () == table_message[51])
			{
			lst_effets->setCurrentItem (randomvalue);
			table_images[nbre_images][2] = lst_effets->currentText ();
			}
		else
			{
			table_images[nbre_images][2] = lsttransdef->currentText ();
			}
		table_images[nbre_images][3] =
			QString::number (spindurtrans->value ());
		table_images[nbre_images][4] = "";
		nbre_images = nbre_images + 1;
		}
		++it;
		}
	calcul_dureeslide ();
	cpt1 = pb_import->totalSteps ();
	pb_import->setProgress (cpt1);
	
	if (nbre_images > 7)
		{
		scroll_timeline->setMaxValue ((nbre_images - 7) * 130);
		}
	else
		{
		scroll_timeline->setMaxValue (0);
		}
	
	if (nbre_images > 0)
		{
		num_photo->setMinValue (1);
		box_det_photo->setEnabled (true);
		num_photo->setMaxValue (nbre_images);
		if (the_selection->isHidden () == true)
		{
		the_selection->setGeometry (5, -5, 130, 130);
		the_selection->show ();
		}
		if (nbre_images > 99)
		{
		QMessageBox::warning (this, MANDVDVER, table_message[19]);
		}
		}
	
	}
	}

	void
	mainfrm::bt_create_fond_anim_clicked () {
	// ************************************************
	// *** Ouverture de la fen�tre de cr�ation d'un menu anim� ***
	// ************************************************
	creation_menu_anim->setGeometry (0, 110, 1000, 700);
	Etape_03->hide ();
	textEdit4->hide ();
	bt_go_extract->setDisabled (true);
	idtpage->setText (table_message[35]);
	vframe->setGeometry (30, 130, 380, 280);
	vframe->show ();
	vframe->raise ();
	buttonGroup64->hide ();
	creation_menu_anim->show ();
	}
	


/*
* Taking my best guess at the moment that all theese functions belongs to the slideshow 
* implementation in the program. Mikael
*/

	/* Slideshow: */
	void
	mainfrm::bt_choix_couleur_titre_2_clicked () {
	// ****************************************
	// *** Choix de la couleur du titre du diaporama ***
	// ****************************************
	QColor couleur_4 =
	QColorDialog::getColor (couleur_4, this, table_message[71]);
	if (couleur_4.isValid () == true)
	{
	table_color[num_photo->value () - 1] = couleur_4;
	framecolor->setPaletteBackgroundColor (couleur_4);
	}
	
	}
	
	/* Slideshow: */
	bool mainfrm::eventFilter (QObject * o, QEvent * e)
	{
	// **********************
	// *** Filtrage des events ***
	// **********************
	if (fen_slideshow->isEnabled () == true
	&& fen_slideshow->isShown () == true)
	{
	if (e->type () == QEvent::MouseButtonPress)
		{
		int i = 0;
		
		while (table_pnt_img[i] != o && i < 100)
		{
		i = i + 1;
		}
		if (table_pnt_img[i] == o)
		{
		num_photo->setValue (i + 1);
		}
		}
	}
	else
	{
	if (editmask->isEnabled () == true && editmask->isShown () == true)
		{
		QMouseEvent *
		k = (QMouseEvent *) e;
		if (e->type () == QEvent::MouseButtonRelease && rc_003 != 3)
		{
		tabpoint[0] = 0;
		tabpoint[1] = 0;
		lineh1->hide ();
		lineh2->hide ();
		linev1->hide ();
		linev2->hide ();
		QPixmap
			px;
		px.resize (editpix->size ());
		::bitBlt (&px, 0, 0, editpix, 0, 0, 720, 576, Qt::CopyROP,
				false);
		editpix->setPixmap (px);
		lineh1->show ();
		lineh2->show ();
		linev1->show ();
		linev2->show ();
		lineh1->raise ();
		lineh2->raise ();
		linev1->raise ();
		linev2->raise ();
		}
	
		if (e->type () == QEvent::MouseButtonPress && rc_003 == 2)
		{
		QPainter
		titi (this);
		titi.end ();
		titi.begin (editpix);
		QPen
			monpinc2;
		QFontMetrics
		fm (myfontmask);
		QString
			machaine = lineEdit13->text ();
		QChar
			chr = machaine.at (0);
		int
			decalagex = fm.leftBearing (chr);
		monpinc2.setColor (fcouleur->backgroundColor ());
		titi.setPen (monpinc2);
		myfontmask.setStyleStrategy (QFont::NoAntialias);
		titi.setFont (myfontmask);
		titi.drawText (k->x () - decalagex, k->y (),
				lineEdit13->text ());
		titi.end ();
		outils0_clicked ();
		}
	
		if (e->type () == QEvent::MouseButtonPress && rc_003 == 3)
		{
		if (tabpoint[0] == 0 && tabpoint[1] == 0)
			{
			tabpoint[0] = k->x ();
			tabpoint[1] = k->y ();
			}
		else
			{
			QPainter
			toto (this);
			toto.end ();
			toto.begin (editpix);
			QPen
			monpinc;
			monpinc.setColor (fcouleur->backgroundColor ());
			monpinc.setWidth (brushsize->value ());
			toto.setPen (monpinc);
			toto.drawLine (tabpoint[0], tabpoint[1], k->x (), k->y ());
			tabpoint[0] = 0;
			tabpoint[1] = 0;
			}
		}
	
		if (e->type () == QEvent::MouseMove)
		{
		locdblebuff->setPixmap (wsavbtmenu.copy
					(k->x () - 58, k->y () - 36, 116, 72));
		::bitBlt (zoommask, 0, 0, locdblebuff->pixmap (), 0, 0, 116, 72,
				Qt::CopyROP, false);
		if (k->state () == Qt::LeftButton && rc_003 < 2)
			{
			if (tabpoint[0] == 0 && tabpoint[1] == 0)
			{
			tabpoint[0] = k->x ();
			tabpoint[1] = k->y ();
			}
			QPainter
			toto (this);
			toto.end ();
			toto.begin (editpix);
			if (rc_003 == 0)
			{
			QPen
				monpinc;
			monpinc.setColor (fcouleur->backgroundColor ());
			monpinc.setWidth (brushsize->value ());
			toto.setPen (monpinc);
			toto.drawLine (tabpoint[0], tabpoint[1], k->x (),
					k->y ());
			tabpoint[0] = k->x ();
			tabpoint[1] = k->y ();
			}
			else
			{
			if (rc_003 == 1)
				{
				toto.eraseRect (k->x (), k->y (),
						brushsize->value (),
						brushsize->value ());
				}
			}
			toto.end ();
			}
		else
			{
			if (k->state () == Qt::LeftButton && rc_003 == 4)
			{
			QPainter
			toto (this);
			toto.end ();
			toto.begin (editpix);
			QPen
				monpinc;
			QBrush
				mybrush;
			if (rc_004 == 0)
				{
				mybrush.setStyle (Qt::SolidPattern);
				}
			else
				{
				if (rc_004 == 1)
				{
				mybrush.setStyle (Qt::BDiagPattern);
				}
				else
				{
				if (rc_004 == 2)
					{
					mybrush.setStyle (Qt::FDiagPattern);
					}
				else
					{
					if (rc_004 == 3)
					{
					mybrush.setStyle (Qt::Dense4Pattern);
					}
					else
					{
					mybrush.setStyle (Qt::Dense6Pattern);
					}
	
					}
	
				}
	
				}
	
			mybrush.setColor (fcouleur->backgroundColor ());
			monpinc.setStyle (Qt::NoPen);
			toto.setBrush (mybrush);
			toto.setPen (monpinc);
			toto.drawRect (k->x (), k->y (),
					3 + brushsize->value (),
					3 + brushsize->value ());
			tabpoint[0] = 0;
			tabpoint[1] = 0;
			toto.end ();
			}
			}
		}
		}
	}
	return QWidget::eventFilter (o, e);
	}

	/* Slideshow: */
	void mainfrm::slider7_valueChanged (int) {
	// ****************************************
	// *** Changement / aggrandissement du bouton ***
	// ****************************************
	float ratio;
	if (wdeflong > wdefhaut)
	{
	longueur = wdeflong + slider7->value ();
	ratio = wdeflong / wdefhaut;
	hauteur = wdefhaut + (slider7->value () / ratio);
	
	if (720 - longueur > 60)
		{
		QImage zicitmp =
		wsavbtmenu.scale (longueur, hauteur, QImage::ScaleMax);
		hauteur = zicitmp.height ();
		clqconstruct->setGeometry (1001, 0, longueur, hauteur);
		clqconstruct->setPixmap (save_fond_2.copy (slider_x->value (),
							slider_y->value (),
							longueur, hauteur, 0));
		// *** Dessin du texte sur le bouton tat normal ***********
		QPainter mypainter (this);
		mypainter.end ();
		mypainter.begin (clqconstruct->pixmap ());
		mypainter.drawImage (0, 0, zicitmp, 0, 0, -1, -1);
		mypainter.end ();
		// *** Rglage des barres de dfilement ***
		slider_x->setMaxValue (720 - longueur);
		slider_y->setMaxValue (576 - hauteur);
		//
		bt_fantome->setGeometry (23 + slider_x->value (),
					23 + slider_y->value (), longueur,
					hauteur);
		bt_fantome->setPixmap (*clqconstruct->pixmap ());
		}
	}
	else
	{
	hauteur = wdefhaut + slider7->value ();
	ratio = wdefhaut / wdeflong;
	longueur = wdeflong + (slider7->value () / ratio);
	
	if (576 - hauteur > 60)
		{
		QImage zicitmp =
		wsavbtmenu.scale (longueur, hauteur, QImage::ScaleMin);
		longueur = zicitmp.width ();
		clqconstruct->setGeometry (1001, 0, longueur, hauteur);
		clqconstruct->setPixmap (save_fond_2.copy (slider_x->value (),
							slider_y->value (),
							longueur, hauteur, 0));
		// *** Dessin du texte sur le bouton tat normal ***********
		QPainter mypainter (this);
		mypainter.end ();
		mypainter.begin (clqconstruct->pixmap ());
		mypainter.drawImage (0, 0, zicitmp, 0, 0, -1, -1);
		mypainter.end ();
		// *** Rglage des barres de dfilement ***
		slider_x->setMaxValue (720 - longueur);
		slider_y->setMaxValue (576 - hauteur);
		bt_fantome->setGeometry (23 + slider_x->value (),
					23 + slider_y->value (), longueur,
					hauteur);
		bt_fantome->setPixmap (*clqconstruct->pixmap ());
		}
	}
	regle_2->setGeometry (23, 23 + slider_y->value () + hauteur + 2, 720, 1);
	}

	/* Slideshow: */
	void mainfrm::toolButton94_clicked () {
	// **********************************
	// *** Sauvegarde d'un projet diaporama ***
	// **********************************
	QString myfic = QFileDialog::getSaveFileName (dossier_travail_2,
							"Projet Slideshow (*.gib)",
							this, table_message[65], "Slideshow export");
	if (myfic.isNull ())
	{
	}
	else
	{
	if (myfic.right (4) != ".gib")
		{
		myfic = myfic + ".gib";
		}
	QFile outfic (myfic);
	if (outfic.open (IO_WriteOnly))
		{
		if (nbre_images > 0)
		{
		int cpt_001;
		cpt_001 = 0;
	
		tmp_001 = path_musique + "\n";
		outfic.writeBlock (tmp_001, tmp_001.length ());
		//
		tmp_001 = myfont.toString () + "\n";
		outfic.writeBlock (tmp_001, tmp_001.length ());
		//
		tmp_001 = QString::number (sliderfps->value ()) + "\n";
		outfic.writeBlock (tmp_001, tmp_001.length ());
	
		while (cpt_001 < nbre_images)
			{
			tmp_001 = table_images[cpt_001][0] + "\n";
			outfic.writeBlock (tmp_001, tmp_001.length ());
			//
			tmp_001 = table_images[cpt_001][1] + "\n";
			outfic.writeBlock (tmp_001, tmp_001.length ());
			//
			tmp_001 = table_images[cpt_001][2] + "\n";
			outfic.writeBlock (tmp_001, tmp_001.length ());
			//
			tmp_001 = table_images[cpt_001][3] + "\n";
			outfic.writeBlock (tmp_001, tmp_001.length ());
			//
			tmp_001 = table_images[cpt_001][4] + "\n";
			outfic.writeBlock (tmp_001, tmp_001.length ());
			//
			QColor icicolor;
			icicolor = table_color[cpt_001];
			tmp_001 = QString::number (icicolor.red ()) + "\n";
			outfic.writeBlock (tmp_001, tmp_001.length ());
			//
			tmp_001 = QString::number (icicolor.green ()) + "\n";
			outfic.writeBlock (tmp_001, tmp_001.length ());
			//
			tmp_001 = QString::number (icicolor.blue ()) + "\n";
			outfic.writeBlock (tmp_001, tmp_001.length ());
			//
			tmp_001 = "$-$$-$\n";
			outfic.writeBlock (tmp_001, tmp_001.length ());
			//
			cpt_001 = cpt_001 + 1;
			}
		QMessageBox::warning (this, MANDVDVER, table_message[39]);
		}
		outfic.close ();
		}
	else
		{
		QMessageBox::warning (this, MANDVDVER, table_message[8]);
		}
	}
	}
	
	/* Import a slideshow */
	void mainfrm::toolButton94_2_clicked () {
	// *********************************
	// *** Ouverture d'un projet diaporama ***
	// *********************************
	QString ficimport = QFileDialog::getOpenFileName (dossier_travail_2,
							"Slideshow (*.GIB *.gib)",
							this, table_message[65], "Slideshow import");
	if (ficimport.isNull ())
	{
	}
	else
	{
	QFile myfic (ficimport);
	if (myfic.open (IO_ReadOnly))
		{
		casse_tout ();
		QTextStream mystream (&myfic);
		QString imp_pathfichier;
		QString imp_dureeaffich;
		QString imp_transition;
		QString imp_durtransition;
		QString imp_titreimage;
		QImage myimg;
		QImage tmp_img_2;
		QColor mycolor;
		QColor loccolor;
		QLabel *localmypix;
		QIconViewItem *myi;
		QString S_Red;
		QString S_Green;
		QString S_Blue;
		int I_Red;
		int I_Green;
		int I_Blue;
		int I_fps;
		QPixmap wl_pix1 (320, 256);
		QImage wl_img1;
		QImage wl_img2;
		QPixmap mypix (320, 256);
		QString myrec = mystream.readLine ();
		path_musique = myrec;
		if (path_musique == "")
		{
		bt_musique_options->setDisabled (true);
		}
		else
		{
		bt_musique_options->setEnabled (true);
		}
		myrec = mystream.readLine ();
		myfont.fromString (myrec);
		myrec = mystream.readLine ();
		I_fps = myrec.toInt (&ok, 10);
		if (ok == false)
		{
		sliderfps->setValue (5);
		}
		else
		{
		sliderfps->setValue (I_fps);
		}
	
		myrec = mystream.readLine ();
	
		while (mystream.atEnd () == false && nbre_images < 100)
		{
		//
		imp_pathfichier = myrec;
		myrec = mystream.readLine ();
		imp_dureeaffich = myrec;
		myrec = mystream.readLine ();
		imp_transition = myrec;
		myrec = mystream.readLine ();
		imp_durtransition = myrec;
		myrec = mystream.readLine ();
		imp_titreimage = myrec;
		myrec = mystream.readLine ();
		S_Red = myrec;
		myrec = mystream.readLine ();
		S_Green = myrec;
		myrec = mystream.readLine ();
		S_Blue = myrec;
		myrec = mystream.readLine ();
	
		I_Red = S_Red.toInt (&ok, 10);
		if (ok == false)
			{
			I_Red = 0;
			}
	
		I_Green = S_Green.toInt (&ok, 10);
		if (ok == false)
			{
			I_Green = 0;
			}
	
		I_Blue = S_Blue.toInt (&ok, 10);
		if (ok == false)
			{
			I_Blue = 0;
			}
		loccolor.setRgb (I_Red, I_Green, I_Blue);
		//
		if (myimg.load (imp_pathfichier) == true)
			{
			tmp_img_2 = myimg.scale (320, 256, QImage::ScaleMin);
			//
			mypix.convertFromImage (tmp_img_2);
			wl_pix1.fill (Qt::black);
			wl_img1 = wl_pix1.convertToImage ();
			::bitBlt (&wl_pix1, (320 - mypix.width ()) / 2,
				(256 - mypix.height ()) / 2, &mypix, 0, 0, -1, -1,
				Qt::CopyROP, false);
			wl_img2 = wl_pix1.convertToImage ();
			//
			QLabel *mylabel = new QLabel (timeline);
			mylabel->setScaledContents (true);
			mylabel->setGeometry ((10 + (nbre_images * 120)) +
						(nbre_images * 10), 6, 120, 96);
			mylabel->setPixmap (wl_img2);
			//
			mylabel->installEventFilter (this);
			mylabel->setFrameStyle (QFrame::Box | QFrame::Plain);
			mylabel->setLineWidth (2);
			mylabel->show ();
			mylabel->raise ();
			QLabel *mylabel_2 = new QLabel (timeline);
			mylabel_2->setText ("Photo : " +
					QString::number (nbre_images + 1));
			mylabel_2->setGeometry ((10 + (nbre_images * 120)) +
						(nbre_images * 10), 103, 120, 14);
			mylabel_2->setPaletteForegroundColor (mycolor);
			mylabel_2->show ();
			mylabel_2->raise ();
			//
			QLabel *mylabel_3 = new QLabel (timeline);
			if (imp_transition == table_message[40])
			{
			mylabel_3->setPixmap (*null_transition->pixmap ());
			}
			else
			{
			myi =
				mylsttrans->findItem (imp_transition, Qt::ExactMatch);
			if (myi != 0)
				{
				localmypix = pnt_table_trans[myi->index ()];
				mylabel_3->setPixmap (*localmypix->pixmap ());
				}
			else
				{
				mylabel_3->setPixmap (*null_transition->pixmap ());
				}
			}
	
			mylabel_3->setGeometry ((13 + (nbre_images * 120)) +
						(nbre_images * 10), 35, 40, 40);
			mylabel_3->setFrameStyle (QFrame::Box | QFrame::Plain);
			mylabel_3->setScaledContents (true);
			mylabel_3->setLineWidth (1);
			mylabel_3->setPaletteForegroundColor (mycolor);
			mylabel_3->show ();
			mylabel_3->raise ();
			//
			table_pnt_img[nbre_images] = mylabel;
			table_pnt_txt[nbre_images][0] = mylabel_2;
			table_pnt_txt[nbre_images][1] = mylabel_3;
			table_images[nbre_images][0] = imp_pathfichier;
			table_images[nbre_images][1] = imp_dureeaffich;
			table_color[nbre_images] = loccolor;
			framecolor->setPaletteBackgroundColor (loccolor);
			table_images[nbre_images][2] = imp_transition;
	
			table_images[nbre_images][3] = imp_durtransition;
			table_images[nbre_images][4] = imp_titreimage;
			nbre_images = nbre_images + 1;
			}
		//
		myrec = mystream.readLine ();
		}
		myfic.close ();
		num_photo->setMinValue (1);
	
		if (nbre_images > 7)
		{
		scroll_timeline->setMaxValue ((nbre_images - 7) * 130);
		}
		else
		{
		scroll_timeline->setMaxValue (0);
		}
	
		if (nbre_images > 0)
		{
		box_det_photo->setEnabled (true);
		num_photo->setMaxValue (nbre_images);
		bt_modif_gimp_2->setEnabled (true);
		bt_valid_info_image_3->setEnabled (true);
		bt_valid_info_image_2->setEnabled (true);
		if (the_selection->isHidden () == true)
			{
			the_selection->setGeometry (5, -5, 130, 130);
			the_selection->show ();
			}
		num_photo->setValue (1);
		if (path_musique != "")
			{
			calczik (path_musique);
			}
		}
		}
	}
	}
	
	/* Converting images and applying effects in a slideshow, I think  */
	void
	mainfrm::mylsteffets_doubleClicked (QIconViewItem *) {
	QIconViewItem *i = mylsteffets->currentItem ();
	
	if (i != 0)
	{
	textLabel1_32->setText (i->text ());
	pixmapLabel1_14->setPixmap (*i->pixmap ());
	pixmapLabel2_3->setPixmap (*apercu_photo_diapo->pixmap ());
	pixmapLabel2_3_2->setPixmap (*apercu_photo_diapo->pixmap ());
	rc_001 = 0;
	
	if (i->text () != "contrast" && i->text () != "blur"
		&& i->text () != "swirl" && i->text () != "cadre"
		&& i->text () != "coupe")
		{
		toolButton97->setDisabled (true);
		toolButton97_2->setDisabled (true);
		if (i->text () == "sepia-tone")
		{
		proc_001 = new QProcess (this);
		proc_001->addArgument ("convert");
		proc_001->addArgument (table_images[num_photo->value () - 1]
					[0]);
		proc_001->addArgument ("-" + textLabel1_32->text ());
		proc_001->addArgument ("50000");
		proc_001->addArgument (wpathtotalproj + "tmpslideimg.png");
		connect (proc_001, SIGNAL (processExited ()), this,
			SLOT (fin_plus_effets ()));
		if (!proc_001->start ())
			{
			QMessageBox::warning (this, MANDVDVER,
						table_message[0] +
						"convert (ImageMagick)");
			}
		else
			{
			deteffets->setDisabled (true);
			}
		}
		else
		{
		if (i->text () == "paint")
			{
			proc_001 = new QProcess (this);
			proc_001->addArgument ("convert");
			proc_001->addArgument (table_images[num_photo->value () - 1]
						[0]);
			proc_001->addArgument ("-" + textLabel1_32->text ());
			proc_001->addArgument ("2");
			proc_001->addArgument (wpathtotalproj + "tmpslideimg.png");
			connect (proc_001, SIGNAL (processExited ()), this,
				SLOT (fin_plus_effets ()));
			if (!proc_001->start ())
			{
			QMessageBox::warning (this, MANDVDVER,
						table_message[0] +
						"convert (ImageMagick)");
			}
			else
			{
			deteffets->setDisabled (true);
			}
			}
		else
			{
			if (i->text () == "negate")
			{
			QImage
				travfond (table_images[num_photo->value () - 1][0]);
			travfond.invertPixels (true);
			travfond.save (wpathtotalproj + "tmpslideimg.png",
					"PNG");
			fin_plus_effets ();
			}
			else
			{
			if (i->text () == "monochrome")
				{
				proc_001 = new QProcess (this);
				proc_001->addArgument ("convert");
				proc_001->addArgument (table_images
							[num_photo->value () -
							1][0]);
				proc_001->addArgument ("-" +
							textLabel1_32->text ());
				proc_001->addArgument (wpathtotalproj +
							"tmpslideimg.png");
				connect (proc_001, SIGNAL (processExited ()), this,
					SLOT (fin_plus_effets ()));
				if (!proc_001->start ())
				{
				QMessageBox::warning (this, MANDVDVER,
							table_message[0] +
							"convert (ImageMagick)");
				}
				else
				{
				deteffets->setDisabled (true);
				}
				}
			else
				{
				if (i->text () == "edge")
				{
				proc_001 = new QProcess (this);
				proc_001->addArgument ("convert");
				proc_001->addArgument (table_images
							[num_photo->value () -
							1][0]);
				proc_001->addArgument ("-" +
							textLabel1_32->text ());
				proc_001->addArgument ("1");
				proc_001->addArgument (wpathtotalproj +
							"tmpslideimg.png");
				connect (proc_001, SIGNAL (processExited ()),
					this, SLOT (fin_plus_effets ()));
				if (!proc_001->start ())
					{
					QMessageBox::warning (this, MANDVDVER,
								table_message[0] +
								"convert (ImageMagick)");
					}
				else
					{
					deteffets->setDisabled (true);
					}
				}
				else
				{
				if (i->text () == "hmirror")
					{
					QImage
					travfond (table_images
						[num_photo->value () - 1][0]);
					QImage tmptrav =
					travfond.mirror (true, false);
					tmptrav.save (wpathtotalproj +
							"tmpslideimg.png", "PNG");
					fin_plus_effets ();
					}
				else
					{
					if (i->text () == "vmirror")
					{
					QImage
						travfond (table_images
							[num_photo->value () -
							1][0]);
					QImage tmptrav =
						travfond.mirror (false, true);
					tmptrav.save (wpathtotalproj +
							"tmpslideimg.png", "PNG");
					fin_plus_effets ();
					}
					else
					{
					if (i->text () == "wave")
						{
						proc_001 = new QProcess (this);
						proc_001->addArgument ("convert");
						proc_001->addArgument (table_images
									[num_photo->value
									() - 1][0]);
						proc_001->addArgument ("-" +
									textLabel1_32->text
									());
						proc_001->addArgument ("10x200");
						proc_001->addArgument
						(wpathtotalproj +
						"tmpslideimg.png");
						connect (proc_001,
							SIGNAL (processExited ()),
							this,
							SLOT (fin_plus_effets ()));
						if (!proc_001->start ())
						{
						QMessageBox::warning (this,
									MANDVDVER,
									table_message
									[0] +
									"convert (ImageMagick)");
						}
						else
						{
						deteffets->setDisabled (true);
						}
						}
					else
						{
						if (i->text () == "cycle")
						{
						proc_001 = new QProcess (this);
						proc_001->addArgument
							("convert");
						proc_001->addArgument
							(table_images
							[num_photo->value () -
							1][0]);
						proc_001->addArgument ("-" +
									textLabel1_32->text
									());
						proc_001->addArgument ("100");
						proc_001->addArgument
							(wpathtotalproj +
							"tmpslideimg.png");
						connect (proc_001,
							SIGNAL (processExited
								()), this,
							SLOT (fin_plus_effets
								()));
						if (!proc_001->start ())
							{
							QMessageBox::warning (this,
										MANDVDVER,
										table_message
										[0] +
										"convert (ImageMagick)");
							}
						else
							{
							deteffets->setDisabled
							(true);
							}
						}
						else
						{
						if (i->text () == "mask")
							{
							QString myfic =
							QFileDialog::getOpenFileName
							(dossier_travail_2,
							"Mask (*.png *.PNG)",
							this,table_message[65], table_message[67] );
							if (myfic.isNull ())
							{
							}
							else
							{
							QPixmap
								tmpcreat (table_images
									[num_photo->value
									() -
									1][0]);
							QPixmap
								tmpcreat2 (myfic);
							QImage wl_img1 =
								tmpcreat2.convertToImage
								();
							QImage wl_img2 =
								wl_img1.scale (720,
									576,
									QImage::ScaleMin);
							QPixmap
								wl_pix1 (wl_img2.width
									(),
									wl_img2.height
									());
							wl_pix1.convertFromImage
								(wl_img2);
							::bitBlt (&tmpcreat, 0,
									0, &wl_pix1,
									0, 0, -1, -1,
									Qt::CopyROP,
									false);
							QImage wl_img3 =
								tmpcreat.convertToImage
								();
							wl_img3.save
								(wpathtotalproj +
								"tmpslideimg.png",
								"PNG");
							fin_plus_effets ();
							}
							}
						}
						}
					}
					}
				}
				}
			}
			}
		}
		deteffets->setGeometry (274, 165, 451, 370);
		deteffets->show ();
		deteffets->raise ();
		}
	else
		{
		if (i->text () == "cadre")
		{
		cadredit->setGeometry (135, 103, 730, 620);
		dial1->setValue (5);
		dial_size->setValue (720);
		dial_x->setValue (0);
		dial_y->setValue (0);
		groupBox13->hide ();
		wlanguage = "";
		calculcadre ();
		cadredit->show ();
		cadredit->raise ();
		}
		else
		{
		if (i->text () == "coupe")
			{
			QImage travfond (table_images[num_photo->value () - 1][0]);
			QImage tmp_img_2 =
			travfond.scale (720, 576, QImage::ScaleMax);
			imgtravail->setPixmap (tmp_img_2);
			fantome_decoupe->setPixmap (tmp_img_2);
			recadrage->setGeometry (45, 110, 910, 615);
			recadrage->show ();
			recadrage->raise ();
			deplace_x->setValue (50);
			deplace_y->setValue (50);
			deplace_w->setValue (100);
			deplace_h->setValue (100);
			deplace_x->setMaxValue (travfond.width ());
			deplace_y->setMaxValue (travfond.height ());
			deplace_w->setMaxValue (travfond.width ());
			deplace_h->setMaxValue (travfond.height ());
			depl_coupe ();
			}
		else
			{
			toolButton97->setEnabled (true);
			toolButton97_2->setEnabled (true);
			deteffets->setGeometry (274, 165, 451, 370);
			deteffets->show ();
			deteffets->raise ();
			}
		}
		}
	fen_slideshow->setDisabled (true);
	}
	}

	/* Slideshow: Transform picture */
	void
	mainfrm::toolButton95_clicked () {
	if (radioButton3_2->isChecked () == true)
	{
	QTime nowtime;
	nowtime = QTime::currentTime ();
	tmp_009 =
		wpathtotalproj + "GIBtmpphoto_" + nowtime.toString ("hh:mm:ss") +
		".png";
	QImage myimg = pixmapLabel2_3_2->pixmap ()->convertToImage ();
	QImage myimg_2 = myimg.scale (720, 576, QImage::ScaleMax);
	myimg_2.save (tmp_009, "PNG");
	table_images[num_photo->value () - 1][0] = tmp_009;
	QLabel *pntloc = table_pnt_img[num_photo->value () - 1];
	QPixmap pixloc;
	pixloc.load (tmp_009);
	QImage tmptransf = pixloc.convertToImage ();
	myimg = tmptransf.scale (320, 256, QImage::ScaleMax);
	pntloc->setPixmap (myimg);
	apercu_photo_diapo->setPixmap (myimg);
	}
	deteffets->hide ();
	fen_slideshow->setEnabled (true);
	}
	
	/* Slideshow: */
	void
	mainfrm::toolButton97_clicked () {
	// *** PLUS ***
	if (rc_001 == 0)
	{
	proc_001 = new QProcess (this);
	proc_001->addArgument ("convert");
	proc_001->addArgument (table_images[num_photo->value () - 1][0]);
	proc_001->addArgument ("-" + textLabel1_32->text ());
	if (textLabel1_32->text () == "blur")
		{
		proc_001->addArgument ("100");
		}
	if (textLabel1_32->text () == "swirl")
		{
		proc_001->addArgument ("50");
		rc_002 = 50;
		}
	proc_001->addArgument (wpathtotalproj + "tmpslideimg.png");
	
	connect (proc_001, SIGNAL (processExited ()), this,
		SLOT (fin_plus_effets ()));
	if (!proc_001->start ())
		{
		QMessageBox::warning (this, MANDVDVER,
					table_message[0] + "convert (ImageMagick)");
		}
	else
		{
		deteffets->setDisabled (true);
		rc_001 = 1;
		}
	}
	else
	{
	proc_001 = new QProcess (this);
	proc_001->addArgument ("convert");
	
	if (textLabel1_32->text () == "swirl")
		{
		proc_001->addArgument (table_images[num_photo->value () - 1][0]);
		proc_001->addArgument ("-" + textLabel1_32->text ());
		rc_002 = rc_002 + 50;
		proc_001->addArgument (QString::number (rc_002));
		}
	else
		{
		proc_001->addArgument (wpathtotalproj + "tmpslideimg.png");
		proc_001->addArgument ("-" + textLabel1_32->text ());
		if (textLabel1_32->text () == "blur")
		{
		proc_001->addArgument ("100");
		}
		}
	proc_001->addArgument (wpathtotalproj + "tmpslideimg.png");
	connect (proc_001, SIGNAL (processExited ()), this,
		SLOT (fin_plus_effets ()));
	
	if (!proc_001->start ())
		{
		QMessageBox::warning (this, MANDVDVER,
					table_message[0] + "convert (ImageMagick)");
		}
	else
		{
		deteffets->setDisabled (true);
		}
	}
	}
	
	/* Slideshow: */	
	void
	mainfrm::fin_plus_effets () {
	deteffets->setEnabled (true);
	QPixmap icipix;
	icipix.load (wpathtotalproj + "tmpslideimg.png");
	pixmapLabel2_3_2->setPixmap (icipix);
	}
	
	/* Slideshow: */
	void
	mainfrm::toolButton97_2_clicked () {
	// *** MOINS ***
	if (rc_001 == 0)
	{
	proc_001 = new QProcess (this);
	proc_001->addArgument ("convert");
	proc_001->addArgument (table_images[num_photo->value () - 1][0]);
	if (textLabel1_32->text () == "swirl")
		{
		proc_001->addArgument ("-" + textLabel1_32->text ());
		proc_001->addArgument ("-50");
		rc_002 = -50;
		}
	else
		{
		proc_001->addArgument ("+" + textLabel1_32->text ());
		}
	proc_001->addArgument (wpathtotalproj + "tmpslideimg.png");
	
	connect (proc_001, SIGNAL (processExited ()), this,
		SLOT (fin_plus_effets ()));
	if (!proc_001->start ())
		{
		QMessageBox::warning (this, MANDVDVER,
					table_message[0] + "convert (ImageMagick)");
		}
	else
		{
		deteffets->setDisabled (true);
		rc_001 = 1;
		}
	
	}
	else
	{
	proc_001 = new QProcess (this);
	proc_001->addArgument ("convert");
	if (textLabel1_32->text () == "swirl")
		{
		proc_001->addArgument (table_images[num_photo->value () - 1][0]);
		proc_001->addArgument ("-" + textLabel1_32->text ());
		rc_002 = rc_002 - 50;
		proc_001->addArgument (QString::number (rc_002));
		}
	else
		{
		proc_001->addArgument (wpathtotalproj + "tmpslideimg.png");
		proc_001->addArgument ("+" + textLabel1_32->text ());
		}
	proc_001->addArgument (wpathtotalproj + "tmpslideimg.png");
	
	connect (proc_001, SIGNAL (processExited ()), this,
		SLOT (fin_plus_effets ()));
	}
	
	if (!proc_001->start ())
	{
	QMessageBox::warning (this, MANDVDVER,
				table_message[0] + "convert (ImageMagick)");
	}
	else
	{
	deteffets->setDisabled (true);
	}
	}

	/* Slideshow: */	
	void
	mainfrm::toolButton98_clicked () {
	affzoom->setGeometry (135, 110, 730, 616);
	imgzoom->setPixmap (*pixmapLabel2_3_2->pixmap ());
	deteffets->setDisabled (true);
	affzoom->show ();
	affzoom->raise ();
	}

	/* Slideshow: */	
	void
	mainfrm::toolButton99_clicked () {
	deteffets->setEnabled (true);
	affzoom->hide ();
	}

	/* Slideshow: */	
	void
	mainfrm::mylsttrans_doubleClicked (QIconViewItem *) {
	table_images[num_photo->value () - 1][1] =
	QString::number (duree_affichage->value ());
	QLabel *mypix;
	QLabel *mypix_2;
	
	QIconViewItem *i = mylsttrans->currentItem ();
	if (i != 0)
	{
	table_images[num_photo->value () - 1][2] = i->text ();
	mypix = table_pnt_txt[num_photo->value () - 1][1];
	mypix_2 = pnt_table_trans[i->index ()];
	mypix->setPixmap (*mypix_2->pixmap ());
	}
	else
	{
	table_images[num_photo->value () - 1][2] = table_message[40];
	}
	table_images[num_photo->value () - 1][3] =
	QString::number (duree_transition->value ());
	table_images[num_photo->value () - 1][4] = txt_img->text ();
	
	}

	/* Slideshow: */	
	void
	mainfrm::duree_affichage_valueChanged (int) {
	table_images[num_photo->value () - 1][1] =
	QString::number (duree_affichage->value ());
	calcul_dureeslide ();
	}

	/* Slideshow: */	
	void
	mainfrm::duree_transition_valueChanged (int) {
	table_images[num_photo->value () - 1][3] =
	QString::number (duree_transition->value ());
	calcul_dureeslide ();
	}

	/* Slideshow: */	
	void
	mainfrm::txt_img_textChanged (const QString &) {
	table_images[num_photo->value () - 1][4] = txt_img->text ();
	}

	/* Slideshow: */
	void
	mainfrm::bt_sup_chap_2_clicked () {
	lst_chap->clear ();
	bt_sup_chap_2->setDisabled (true);
	bt_sup_chap->setDisabled (true);
	bt_add_chap_2_2->setDisabled (true);
	max_chapitres = 0;
	}



	/* Slideshow: */	
	void
	mainfrm::valideditmask_clicked () {
	editmask->hide ();
	if (optsel2->isChecked () == true)
	{
	my_pixmap_003->setPixmap (*editpix->pixmap ());
	}
	else
	{
	my_pixmap_002->setPixmap (*editpix->pixmap ());
	}
	Etape_04->setEnabled (true);
	}

	/* Slideshow: */	
	void
	mainfrm::bt_maskedit_clicked () {
	Etape_04->setDisabled (true);
	tabpoint[0] = 0;
	tabpoint[1] = 0;
	wsavbtmenu = my_pixmap_001->pixmap ()->convertToImage ();
	editmask->setGeometry (0, 110, 1200, 700);
	editpix->setPixmap (*my_pixmap_002->pixmap ());
	toolButton158->setOn (true);
	rc_004 = 0;
	outils0_clicked ();
	buttonGroup63->setDisabled (true);
	editmask->show ();
	editmask->raise ();
	fcouleur->setBackgroundColor (couleur_2);
	//
	QListViewItem *j;
	rc_003 = 0;
	lstempl->clear ();
	
	while (rc_003 < max_boutons)
	{
	j =
		new QListViewItem (lstempl, table_boutons_lien[rc_003][0],
				QString::number (table_boutons_pos[rc_003][0]),
				QString::number (table_boutons_pos[rc_003][1]),
				QString::number (table_boutons_pos[rc_003][2]),
				QString::number (table_boutons_pos[rc_003][3]));
	rc_003 = rc_003 + 1;
	}
	//
	rc_003 = 0;
	int x1 = table_boutons_pos[0][0] + 3;
	int x2 = table_boutons_pos[0][2] + 2;
	int y1 = table_boutons_pos[0][1] + 3;
	int y2 = table_boutons_pos[0][3] + 2;
	lineh1->setGeometry (x1, y1, x2, 1);
	lineh2->setGeometry (x1, y1 + y2, x2, 1);
	linev1->setGeometry (x1, y1, 1, y2);
	linev2->setGeometry (x1 + x2, y1, 1, y2 + 1);
	lineh1->raise ();
	lineh2->raise ();
	linev1->raise ();
	linev2->raise ();
	//
	myfontmask = myfont;
	taille_police_mask = taille_police;
	testpol->setFont (myfontmask);
	//
	rc_001 = 0;
	rc_003 = 0;
	optsel1->setChecked (true);
	}

	/* Slideshow: */	
	void
	mainfrm::outils0_clicked () {
	rc_003 = 0;
	QIconSet wl_icoset = outils0->iconSet ();
	pixmapLabel1_5->setPixmap (wl_icoset.pixmap ());
	tabpoint[0] = 0;
	tabpoint[1] = 0;
	buttonGroup63->setDisabled (true);
	}

	/* Slideshow: */	
	void
	mainfrm::outils1_clicked () {
	rc_003 = 1;
	QIconSet wl_icoset = outils1->iconSet ();
	pixmapLabel1_5->setPixmap (wl_icoset.pixmap ());
	tabpoint[0] = 0;
	tabpoint[1] = 0;
	buttonGroup63->setDisabled (true);
	}

	/* Slideshow: */	
	void
	mainfrm::keyPressEvent (QKeyEvent * k) {
	// *** Gestion du clavier ************************************************************
	if (k->key () == Qt::Key_Escape)
	{
	}
	}

	/* Slideshow: */	
	void
	mainfrm::optsel2_stateChanged (int) {
	// *** Mask cliqu ***
	if (optsel2->isChecked () == true)
	{
	fcouleur->setBackgroundColor (couleur_3);
	my_pixmap_002->setPixmap (*editpix->pixmap ());
	editpix->setPixmap (*my_pixmap_003->pixmap ());
	}
	}

	/* Slideshow: */	
	void
	mainfrm::optsel1_stateChanged (int) {
	// *** Mask slectionn ***
	if (optsel1->isChecked () == true)
	{
	fcouleur->setBackgroundColor (couleur_2);
	if (rc_001 != 0)
		{
		my_pixmap_003->setPixmap (*editpix->pixmap ());
		}
	editpix->setPixmap (*my_pixmap_002->pixmap ());
	rc_001 = 1;
	}
	}

	/* Slideshow: */	
	void
	mainfrm::lstempl_clicked (QListViewItem *) {
	// *** Afficher le cadre de travail ***
	QListViewItem *i = lstempl->selectedItem ();
	
	if (i != 0)
	{
	int x1;
	int x2;
	int y1;
	int y2;
	
	tmp_001 = i->text (1);
	x1 = tmp_001.toInt (&ok, 10);
	if (ok == false)
		{
		x1 = 0;
		}
	
	tmp_001 = i->text (2);
	y1 = tmp_001.toInt (&ok, 10);
	if (ok == false)
		{
		y1 = 0;
		}
	
	tmp_001 = i->text (3);
	x2 = tmp_001.toInt (&ok, 10);
	if (ok == false)
		{
		x2 = 0;
		}
	
	tmp_001 = i->text (4);
	y2 = tmp_001.toInt (&ok, 10);
	if (ok == false)
		{
		y2 = 0;
		}
	//
	x1 = x1 + 3;
	y1 = y1 + 3;
	x2 = x2 + 2;
	y2 = y2 + 2;
	//
	lineh1->setGeometry (x1, y1, x2, 1);
	lineh2->setGeometry (x1, y1 + y2, x2, 1);
	linev1->setGeometry (x1, y1, 1, y2);
	linev2->setGeometry (x1 + x2, y1, 1, y2 + 1);
	lineh1->raise ();
	lineh2->raise ();
	linev1->raise ();
	linev2->raise ();
	
	}
	}

	/* Slideshow: Select font ?*/
	void
	mainfrm::toolButton114_clicked () {
	// **************************************
	// *** Choix police de caractre des sous titres ***
	// ***************************************
	QString myfic = QFileDialog::getOpenFileName ("/usr/share/fonts/",
							"Fonts (*.ttf *.TTF)",
							this, table_message[65], table_message[73] );
	if (myfic.isNull ())
	{
	}
	else
	{
	lineEdit12->setText (myfic);
	slider10->setEnabled (true);
	}
	}

	/* Belongs in slideshow? */
	void
	mainfrm::toolButton135_clicked () {
	if (hre_deb_sub->time () < hre_fin_sub->time ())
	{
	if (rc_002 == 0)
		{
		QTime mytime;
		QTime mytime2;
		mytime = hre_deb_sub->time ();
		mytime2 = hre_fin_sub->time ();
		 QListViewItem *i = new QListViewItem(listdessub, mytime.toString("hh:mm:ss"), mytime2.toString("hh:mm:ss"), textsub->text() ); //Warningfix MB
		QTime raztime (0, 0, 0, 0);
		hre_deb_sub->setTime (raztime);
		hre_fin_sub->setTime (raztime);
		textsub->setText ("");
		}
	else
		{
		QListViewItem *i = listdessub->selectedItem ();
	
		if (i != 0)
		{
		QTime mytime;
		QTime mytime2;
		mytime = hre_deb_sub->time ();
		mytime2 = hre_fin_sub->time ();
		i->setText (0, mytime.toString ("hh:mm:ss"));
		i->setText (1, mytime2.toString ("hh:mm:ss"));
		i->setText (2, textsub->text ());
		QTime raztime (0, 0, 0, 0);
		hre_deb_sub->setTime (raztime);
		hre_fin_sub->setTime (raztime);
		textsub->setText ("");
		}
		}
	newsubt->setDisabled (true);
	listdessub->setEnabled (true);
	toolButton133_2->setEnabled (true);
	toolButton133_2_2->setEnabled (true);
	btcloseedit->setEnabled (true);
	btcloseedit_2->setEnabled (true);
	}
	else
	{
	QMessageBox::warning (this, MANDVDVER, table_message[29]);
	}
	}

