/* SVN FILE: $Id$ */
/**
* Project Name : ManDVD
*
* @package className
* @subpackage subclassName
* @author $Author$
* @copyright $Copyright$
* @version $Revision$
* @lastrevision $Date$
* @modifiedby $LastChangedBy$
* @lastmodified $LastChangedDate$
* @license $License$
* @filesource $URL$
*/

/****************************************************************************
** ManDVD
**
** Created: Mon May 08 14:00:00 2006
**      by: Gibault Stphane
**	Hacked on by Mikael Bhm micko@bag.org
**
// ** This is a tool for simply creating DVD Video
** 
****************************************************************************/
//
// C++ Implementation: menu management
//
// Description: Functions (backend) for editing chapters
//
//
// Author: Mikael Bhm <micko@bag.org>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
#include <dvdmenu.h>
#include <mainfrm.h>

/**************************************** Managing Creation of DVD Meny ******************************************/

/* Choose font for DVD-menu */
void mainfrm::bt_police_clicked()
{
    // **********************************
    // *** Slection de la police de caractre ***
    // **********************************
    myfont = QFontDialog::getFont(&ok, QFont("Serif", 11), this);
    taille_police = myfont.pointSize();
}

/* Choose forground color on menu font */
void mainfrm::bt_color_1_clicked()
{
    // ********************************
    // *** Choix de la couleur tat normal ***
    // ********************************
    couleur_1 = QColorDialog::getColor(couleur_1, this, table_message[71]);
    if (couleur_1.isValid()) {
	frame_couleur_1->setBackgroundColor(couleur_1);
    }
}

void mainfrm::bt_color_2_clicked()
{
    // ***********************************
    // *** Choix de la couleur tat slectionn ***
    // ***********************************
    couleur_2 = QColorDialog::getColor(couleur_2, this, table_message[71]);

    if (couleur_2.isValid()) {
	int rouge;
	int vert;
	int bleu;
	couleur_2.getRgb(&rouge, &vert, &bleu);

	if (rouge == 255 && vert == 255 && bleu == 255) {
	    couleur_2.setRgb(254, 254, 254);
	}
	//RGb Set RED GREEN
	if (rouge > 100 && vert > 100 && bleu < 100)
	    couleur_2.setRgb(255, 255, 0);

	//rGB Set GREEN BLUE
	if (rouge < 100 && vert > 100 && bleu > 100)
	    couleur_2.setRgb(0, 255, 255);

	//RgB Set RED BLUE
	if (rouge > 100 && vert < 100 && bleu > 100)
	    couleur_2.setRgb(255, 0, 255);

	//Rgb Set RED 
	if (rouge > 100 && vert < 100 && bleu < 100)
	    couleur_2.setRgb(255, 0, 0);

	//rGb Set GREEN 
	if (rouge < 100 && vert > 100 && bleu < 100)
	    couleur_2.setRgb(0, 255, 0);

	//rgB Set BLUE
	if (rouge < 100 && vert < 100 && bleu > 100)
	    couleur_2.setRgb(0, 0, 255);

	//rgb ->  Set BLACK
	if (rouge < 100 && vert < 100 && bleu < 100)
	    couleur_2.setRgb(0, 0, 0);

	//RGB ->  Set WHITE
	if (rouge > 100 && vert > 100 && bleu > 100)
	    couleur_2.setRgb(255, 255, 255);

	frame_couleur_2->setBackgroundColor(couleur_2);
    }
}

void mainfrm::bt_color_3_clicked()
{
    // *******************************
    // *** Choix de la couleur tat cliqu ***
    // *******************************
    couleur_3 = QColorDialog::getColor(couleur_3, this, table_message[71]);

    if (couleur_3.isValid()) {
	int rouge;
	int vert;
	int bleu;
	couleur_3.getRgb(&rouge, &vert, &bleu);

	if (rouge == 255 && vert == 255 && bleu == 255) {
	    couleur_3.setRgb(254, 254, 254);
	}
	//RGb Set RED GREEN
	if (rouge > 100 && vert > 100 && bleu < 100)
	    couleur_3.setRgb(255, 255, 0);

	//rGB Set GREEN BLUE
	if (rouge < 100 && vert > 100 && bleu > 100)
	    couleur_3.setRgb(0, 255, 255);

	//RgB Set RED BLUE
	if (rouge > 100 && vert < 100 && bleu > 100)
	    couleur_3.setRgb(255, 0, 255);

	//Rgb Set RED 
	if (rouge > 100 && vert < 100 && bleu < 100)
	    couleur_3.setRgb(255, 0, 0);

	//rGb Set GREEN 
	if (rouge < 100 && vert > 100 && bleu < 100)
	    couleur_3.setRgb(0, 255, 0);

	//rgB Set BLUE
	if (rouge < 100 && vert < 100 && bleu > 100)
	    couleur_3.setRgb(0, 0, 255);

	//rgb ->  Set BLACK
	if (rouge < 100 && vert < 100 && bleu < 100)
	    couleur_3.setRgb(0, 0, 0);

	//RGB ->  Set WHITE
	if (rouge > 100 && vert > 100 && bleu > 100)
	    couleur_3.setRgb(255, 255, 255);

	frame_couleur_3->setBackgroundColor(couleur_3);
    }
}

void mainfrm::bt_retourner_clicked()
{
    // **********************************
    // *** Retourner l'image horizontalement ***
    // **********************************
    QImage myimg_2 = save_fond.mirror(true, false);
    save_fond = myimg_2.copy(0, 0, 720, 576, 0);
    QPixmap mypix(save_fond);
    apercu_fond->setPixmap(mypix);
    // *** Mise en place des fonds d'cran pour le menu ***       
    my_pixmap_001->setPixmap(mypix);
}

void mainfrm::bt_retourner_2_clicked()
{
    // ********************************
    // *** Retourner l'image verticalement ***
    // ********************************
    QImage myimg_2 = save_fond.mirror(false, true);
    save_fond = myimg_2.copy(0, 0, 720, 576, 0);
    QPixmap mypix(save_fond);
    apercu_fond->setPixmap(mypix);
    // *** Mise en place des fonds d'cran pour le menu ***       
    my_pixmap_001->setPixmap(mypix);

}

void mainfrm::bt_invert_clicked()
{
    // ****************
    // *** Invert pixels ***
    // ****************
    save_fond.invertPixels(true);
    QPixmap mypix(save_fond);
    apercu_fond->setPixmap(mypix);
    // *** Mise en place des fonds d'cran pour le menu ***       
    my_pixmap_001->setPixmap(mypix);
}

/* Open an image file for import for menu background */
void mainfrm::bt_charg_wall_clicked()
{
    // ***************************
    // *** Slection du fond d'cran ***
    // ***************************
    QString myfic;

    Preview *p = new Preview;
    QFileDialog *fd = new QFileDialog(dossier_travail_2,
				      tr
				      ("Images (*.jpg *.JPG *.jpeg *.JPEG *.png *.PNG)"),
				      this, table_message[65],
				      table_message[67]);

    fd->setContentsPreviewEnabled(TRUE);
    fd->setContentsPreview(p, p);
    fd->setPreviewMode(QFileDialog::Contents);

    if (fd->exec() == QDialog::Accepted) {
	myfic = fd->selectedFile();
	if (myfic.isNull()) {
	} else {
	    int i = myfic.findRev('/');

	    if (i != 1) {
		dossier_travail_2 = myfic.mid(0, i);
	    } else {
		dossier_travail_2 = myfic;
	    }

	    // All 720 changeed to 940 to fit widescreen better 960x540
	    QImage myimg(myfic, 0);
	    QImage myimg_2 = myimg.smoothScale(960, 540, QImage::ScaleMin);

	    QPixmap mypix(myimg_2);
	    QPixmap wl_pix1(720, 576);
	    wl_pix1.fill(Qt::black);

	    QImage wl_img1 = wl_pix1.convertToImage();
	    ::bitBlt(&wl_pix1, (720 - mypix.width()) / 2,
		     (576 - mypix.height()) / 2, &mypix, 0, 0, -1, -1,
		     Qt::CopyROP, false);

	    QImage wl_img2 = wl_pix1.convertToImage();
	    apercu_fond->setPixmap(wl_pix1);
	    path_fond = myfic;
	    save_fond = wl_img2.copy(0, 0, 720, 576, 0);
	    // *** Mise en place des fonds d'cran pour le menu ***       
	    my_pixmap_001->setPixmap(wl_pix1);
	    boite_effets->setEnabled(true);
	}
    }
    delete(p);
    delete(fd);
}


/* Choose colour to the menu!? DVD?? */
void mainfrm::bt_charg_wall_uni_clicked()
{
    // ***************************************
    // *** Choix de la couleur uni du fond du menu ***
    // ***************************************
    QColor couleur_tmp;
    couleur_tmp =
	QColorDialog::getColor(couleur_tmp, this, table_message[71]);

    if (couleur_tmp.isValid()) {
	QImage myimg;
	apercu_fond->pixmap()->fill(couleur_tmp);
	myimg = apercu_fond->pixmap()->convertToImage();
	QImage myimg_2 = myimg.smoothScale(720, 576, QImage::ScaleFree);
	QPixmap mypix(myimg_2);
	apercu_fond->setPixmap(mypix);
	save_fond = myimg_2.copy(0, 0, 720, 576, 0);
	// *** Mise en place des fonds d'cran pour le menu ***       
	my_pixmap_001->setPixmap(*apercu_fond->pixmap());
	boite_effets->setEnabled(true);
	path_fond = "Couleur unie";
    }
}




/* This is slider i menu creation of placement of title 
 * This is Cartesian x value  */
void mainfrm::slider_x_valueChanged(int)
{
    // clqconstruct is a QLabel 
    clqconstruct->setGeometry(1001, 0, longueur, hauteur);
    // Background pixmap in menu slider_y->value() higher move background down
    clqconstruct->setPixmap(save_fond_2.copy
			    (slider_x->value(), slider_y->value(),
			     longueur, hauteur, 0));

    // *** Dessin du texte sur le bouton tat normal ***********
    QPainter mypainter(this);
    mypainter.end();
    mypainter.begin(clqconstruct->pixmap());

    if (wpathbtmenu == "") {
	mypainter.setPen(couleur_1);
	mypainter.setFont(myfont);
	mypainter.drawText(0, hauteur / 2, nomfilm);
    } else {
	mypainter.drawImage(0, 0,
			    wsavbtmenu.smoothScale(longueur, hauteur,
						   QImage::ScaleFree), 0,
			    0, -1, -1);
    }
    mypainter.end();

    // *** On dplace les rgles ***
    regle_1->setGeometry(22 + slider_x->value(), 23, 1, 405);	// WAS 576
    //
    if (23 + slider_x->value() > 400) {
	bt_dyna_modif->setGeometry(33, 40, 240, 250);
    } else {
	if (23 + slider_x->value() < 300) {
	    bt_dyna_modif->setGeometry(490, 40, 240, 250);
	}
    }
    // Position of moving picture
    bt_fantome->setGeometry(23 + slider_x->value(), 23 + slider_y->value(),
			    longueur, hauteur);
    ::bitBlt(bt_fantome, 0, 0, clqconstruct->pixmap(), 0, 0, longueur,
	     hauteur, Qt::CopyROP, false);
}

/* This is slider i menu creation of placement of title 
 * button. This is Cartesian y value  */
void mainfrm::slider_y_valueChanged(int)
{
    // Avoid odd numbers
    int t = slider_y->value();
    t = t / 2;
    t = t * 2;
    slider_y->setValue(t);

    clqconstruct->setGeometry(1001, 0, longueur, hauteur);
    clqconstruct->setPixmap(save_fond_2.copy
			    (slider_x->value(), slider_y->value(),
			     longueur, hauteur, 0));
    // *** Dessin du texte sur le bouton tat normal **********
    QPainter mypainter(this);
    mypainter.end();

    // if statement to reduce null errors
    if (mypainter.begin(clqconstruct->pixmap()) != FALSE) {
	if (wpathbtmenu == "") {
	    mypainter.setPen(couleur_1);
	    mypainter.setFont(myfont);
	    regle_2->setGeometry(23,
				 23 + slider_y->value() +
				 taille_police + 2, 720, 1);
	    mypainter.drawText(0, hauteur / 2, nomfilm);
	    // *** On dplace les rgles ***
	} else {
	    mypainter.drawImage(0, 0,
				wsavbtmenu.smoothScale(longueur, hauteur,
						       QImage::ScaleFree),
				0, 0, -1, -1);
	    // *** On dplace les rgles ***
	    regle_2->setGeometry(23,
				 23 + slider_y->value() + hauteur + 2, 720,
				 1);

	}
	mypainter.end();
	bt_fantome->setGeometry(23 + slider_x->value(),
				23 + slider_y->value(), longueur, hauteur);
	::bitBlt(bt_fantome, 0, 0, clqconstruct->pixmap(), 0, 0, longueur,
		 hauteur, Qt::CopyROP, false);
    }
}

/* Stop button in meny generation clicked */
void mainfrm::bt_annul_create_bt_clicked()
{
    slider_x->setDisabled(true);
    slider_y->setDisabled(true);
    bt_valid_bt->setDisabled(true);
    bt_renew_all->setEnabled(true);
    bt_et04_con_2->setDisabled(true);
    after_lire->setDisabled(true);
    bt_annul_create_bt->setDisabled(true);
    lst_video_2->setEnabled(true);
    bt_add_film_menu->setEnabled(true);
    bt_et04_con->setEnabled(true);
    bt_et04_con_2->setEnabled(true);

    QListViewItem *i = lst_video_2->selectedItem();
    if (i != 0) {
	if (i->text(3) == "$$CHAP$$") {
	    bt_rename_chap->setEnabled(true);
	} else {
	    bt_rename_chap->setDisabled(true);
	}
    } else {
	bt_rename_chap->setDisabled(true);
    }
    regle_1->hide();
    regle_2->hide();
    bt_dyna_modif->hide();
    bt_fantome->hide();
}


/* Pressing confirmbutton of: One new movie or chapter added to the menu  */
void mainfrm::bt_valid_bt_clicked()
{
    bt_fantome->hide();
    bt_renew_all->setEnabled(true);
    bt_dyna_modif->hide();

    // Freeze sliders
    slider_x->setDisabled(true);
    slider_y->setDisabled(true);
    bt_valid_bt->setDisabled(true);
    bt_et04_con_2->setDisabled(true);
    after_lire->setDisabled(true);
    bt_annul_create_bt->setDisabled(true);

    // *** Chargement du bouton en mmoire ***
    // Background picture for menu
    QImage tmpimg = my_pixmap_001->pixmap()->convertToImage();
    // Resscale background image
    tmpimg = tmpimg.smoothScale(720, 405, QImage::ScaleFree);

    // Mask picture 
    QImage myimg = clqconstruct->pixmap()->convertToImage();

    // ********* IMAGE STANDARD *********
    // *** On dessine le bouton sur l'image temporaire ***
    bitBlt(&tmpimg, slider_x->value(), slider_y->value(), &myimg,
	   0, 0, longueur, hauteur);
    // *** On bascule l'image cre dans le buffer affich *****
    QPixmap mypix_001(tmpimg);
    my_pixmap_001->setPixmap(mypix_001);

    if (wpathbtmenu == "") {
	// ********* IMAGE SURVOLEE *********
	tmpimg = my_pixmap_002->pixmap()->convertToImage();
	tmpimg = tmpimg.smoothScale(720, 405, QImage::ScaleFree);
	myimg = bt_fantome_2->pixmap()->convertToImage();

	// *** On dessine le bouton sur l'image temporaire ***
	bitBlt(&tmpimg, slider_x->value(),
	       slider_y->value() + (hauteur / 2), &myimg, 0, 0,
	       longueur - 6, 2);
	// *** On bascule l'image cre dans le buffer affich *****
	QPixmap mypix_002(tmpimg);
	my_pixmap_002->setPixmap(mypix_002);

	// ********* IMAGE CLIQUEE *********
	tmpimg = my_pixmap_003->pixmap()->convertToImage();
	tmpimg = tmpimg.smoothScale(720, 405, QImage::ScaleFree);
	myimg = bt_fantome_3->pixmap()->convertToImage();

	// *** On dessine le bouton sur l'image temporaire ***
	bitBlt(&tmpimg, slider_x->value(),
	       slider_y->value() + (hauteur / 2), &myimg, 0, 0,
	       longueur - 6, 2);
	// *** On bascule l'image cre dans le buffer affich *****
	QPixmap mypix_003(tmpimg);
	my_pixmap_003->setPixmap(mypix_003);

    } else {
	// ********* IMAGE SURVOLEE *********
	tmpimg = my_pixmap_002->pixmap()->convertToImage();
	tmpimg = tmpimg.smoothScale(720, 405, QImage::ScaleFree);	// Needed?
	myimg = bt_fantome_2->pixmap()->convertToImage();

	// *** On dessine le bouton sur l'image temporaire ***
	bitBlt(&tmpimg, slider_x->value(),
	       slider_y->value() + (hauteur - 2), &myimg, 0, 0,
	       longueur - 8, 2);
	// *** On bascule l'image cre dans le buffer affich *****
	QPixmap mypix_002(tmpimg);
	my_pixmap_002->setPixmap(mypix_002);

	// ********* IMAGE CLIQUEE *********
	tmpimg = my_pixmap_003->pixmap()->convertToImage();
	tmpimg = tmpimg.smoothScale(720, 405, QImage::ScaleFree);	// Needed?
	myimg = bt_fantome_3->pixmap()->convertToImage();

	// *** On dessine le bouton sur l'image temporaire ***
	bitBlt(&tmpimg, slider_x->value(),
	       slider_y->value() + (hauteur - 2), &myimg, 0, 0,
	       longueur - 8, 2);
	// *** On bascule l'image cre dans le buffer affich *****
	QPixmap mypix_003(tmpimg);
	my_pixmap_003->setPixmap(mypix_003);
    }

    // Go back to old maxvalue of slider_y to have buttons right
    int tempcurv = slider_y->value();
    int tempminv = slider_y->minValue();
    int tempmaxv = slider_y->maxValue();

    // Current value of slider y in procent
    double sval = (double) tempcurv / tempmaxv;
    int newval = (int) (sval * (576 - hauteur));	// Was * 548
    slider_y->setMaxValue(576 - hauteur);	// Simulate earlier 576
    slider_y->setValue(newval);

    // *** Sauvegarde des informations du bouton ***
    if (slider_x->value() > 0) {
	table_boutons_pos[max_boutons][0] = slider_x->value();
    } else {
	table_boutons_pos[max_boutons][0] = 0;
    }

    if (slider_y->value() > 0) {
	table_boutons_pos[max_boutons][1] = slider_y->value();
    } else {
	table_boutons_pos[max_boutons][1] = 0;
    }

    // Reset slider_y again
    slider_y->setRange(tempminv, tempmaxv);
    slider_y->setValue(tempcurv);

    if (longueur < 720) {
	table_boutons_pos[max_boutons][2] = longueur;
    } else {
	table_boutons_pos[max_boutons][2] = 720;
    }
    if (hauteur < 576) {
	table_boutons_pos[max_boutons][3] = hauteur;
    } else {
	table_boutons_pos[max_boutons][3] = 576;
    }

    // Variabels are set to later use in the creation of the movies 
    table_boutons_pos[max_boutons][4] = audio_bitrate;	// Not used anymore if not set
    table_boutons_lien[max_boutons][0] = nomfilm;
    table_boutons_lien[max_boutons][1] = path_video;
    table_boutons_lien[max_boutons][2] = a_reencoder;
    table_boutons_lien[max_boutons][3] = wchapitres;
    table_boutons_lien[max_boutons][4] = after_lire->currentText();

    if (yasubtitle == 1) {
	table_boutons_lien[max_boutons][5] =
	    video_format + "$$$" + path_subtitle;
    } else {
	table_boutons_lien[max_boutons][5] = video_format;
    }

    table_boutons_lien[max_boutons][6] = type_video;
    table_boutons_lien[max_boutons][7] = wpathbtmenu;
    table_boutons_lien[max_boutons][9] = readBitrate;

    // *** Dblocage de la liste et du lst_video_2->selectedItem();bouton ***
    lst_video_2->setEnabled(true);
    bt_et04_con->setEnabled(true);
    bt_et04_con_2->setEnabled(true);
    bt_rename_chap->setDisabled(true);

    if (lst_video_2->childCount() == 0) {
	bt_tab_order->setEnabled(true);
	bt_maskedit->setEnabled(true);
	bt_add_film_menu->setDisabled(true);
    } else {
	bt_add_film_menu->setEnabled(true);
    }

    // This variable holds total number of buttons in the menu
    max_boutons = max_boutons + 1;

    int objectsleft = lst_video_2->childCount();

    if (objectsleft >= MAXNUMMOV - max_boutons) {
	QMessageBox::warning(this, MANDVDVER,
			     tr("You can't add more chapters now!"));
	QListViewItem *j = lst_video_2->firstChild();

	while (j) {
	    int p = j->childCount();
	    if (p > 0) {
		QListViewItem *child = j->firstChild();
		j->takeItem(child);

	    } else {
		j = j->nextSibling();
	    }
	}
    }
    // *** Suppression de la liste de la listview ***
    QListViewItem *i = lst_video_2->selectedItem();
    if (i != 0) {
	delete i;
    }

    regle_1->hide();
    regle_2->hide();
}

/* Rename a chapter */
void mainfrm::bt_rename_chap_clicked()
{
    QListViewItem *i = lst_video_2->selectedItem();
    if (i != 0) {
	if (i->text(3) == "$$CHAP$$") {
	    Etape_04->setDisabled(true);
	    txttorename->setText(i->text(0));
	    Renamefilm->setGeometry(295, 275, 410, 150);
	    Renamefilm->show();
	    Renamefilm->raise();
	}
    }
}


/* This function sets the movies previewimage in frame */
void mainfrm::setprevimg_dvdmenu(QListViewItem * i)
{
    QListViewItem *j = lst_video_1->firstChild();

    if (j != 0 && i != 0) {
	while (j) {
	    if (j->text(1) == i->text(1)) {
		//Test only. Could be set to help with 4/3 resp 16/9 movies.
		zs_4->setGeometry(43, 579, 680, 1);
		break;
	    }
	    j = j->nextSibling();
	}

	if (i->text(3) != "$$CHAP$$") {
	    QImage wl_img1 = prevmaskfilm->pixmap()->convertToImage();
	    QImage wl_img2 = prevmaskfilm_2->pixmap()->convertToImage();
	    QPixmap wl_pix2(wl_img1);
	    QPixmap wl_pix3(wl_img2);
	    ::bitBlt(&wl_pix3, 0, 0, &wl_pix2, 0, 0, -1, -1, Qt::CopyROP,
		     false);

	    QImage wl_img3 = j->pixmap(0)->convertToImage();
	    QPixmap wl_pix4(wl_img3);
	    ::bitBlt(&wl_pix3, 0, 0, &wl_pix4, 0, 0, -1, -1, Qt::CopyROP,
		     false);

	    prevmaskfilm_3->setPixmap(wl_pix3);
	    prevmaskfilm_3->show();
	}
    }
}


/* Slot for selection changed in videolist 2 in creation DVD menu */
void mainfrm::lst_video_2_selectionChanged()
{
    QListViewItem *i = lst_video_2->selectedItem();
    if (i != 0) {
	if (i->text(3) == "$$CHAP$$") {
	    bt_rename_chap->setEnabled(true);
	} else {
	    bt_rename_chap->setDisabled(true);
	    setprevimg_dvdmenu(i);
	}
    }
}


/* Button to add a movie to the menu clicked from list of movies 
 * Just to make it a little bit more convinient to add movies */
void mainfrm::bt_add_film_menu_clicked_lst(QListViewItem * i,
					   const QPoint &, int)
{
    bt_add_film_menu_clicked();
    setprevimg_dvdmenu(i);
}


/* Add a movie to the DVD menu and start working with sliders */
void mainfrm::bt_add_film_menu_clicked()
{
    // **************************
    // *** Ajout du film sur le menu ***
    // **************************

    QListViewItem *i = lst_video_2->selectedItem();
    if (i != 0) {
	// *** Dblocage des sliders ***
	slider_x->setEnabled(true);
	slider_y->setEnabled(true);
	slider_x->setValue(1);
	slider_y->setValue(1);
	bt_renew_all->setDisabled(true);
	bt_valid_bt->setEnabled(true);
	bt_annul_create_bt->setEnabled(true);

	if (i->text(3) != "$$CHAP$$") {
	    after_lire->setEnabled(true);
	    after_lire->setCurrentItem(0);
	}
	// *** Sauvegarde du titre du film ***
	tmp4sub = i->text(4);
	rc_001 = tmp4sub.find("$$$", 0);

	if (rc_001 != -1) {
	    tmp_002 =
		tmp4sub.mid(rc_001 + 3, tmp4sub.length() - (rc_001 + 3));
	    path_subtitle = tmp_002;
	    yasubtitle = 1;
	} else {
	    path_subtitle = "";
	    yasubtitle = 0;
	}

	if (rc_001 == -1) {
	    rc_001 = tmp4sub.length();
	}
	tmp_002 = tmp4sub.mid(0, rc_001);
	rc_001 = tmp_002.toInt(&ok, 10);
	QString audibit = i->text(9);

	if (ok == true) {
	    if (rc_001 == 0) {
		audio_bitrate = audibit.toInt(&ok, 10);
	    } else {
		audio_bitrate = rc_001;
	    }
	}
	//
	nomfilm = i->text(0);
	path_video = i->text(1);
	a_reencoder = i->text(2);
	wchapitres = i->text(3);
	video_format = i->text(5);
	type_video = i->text(6);
	wpathbtmenu = i->text(7);
	tmp_vsize = i->text(8);	// The estimated size of the video
	readBitrate = i->text(12);
	//
	if (wpathbtmenu == "") {
	    QFontMetrics fm(myfont);
	    longueur = fm.width("\"" + nomfilm + "\"", -1);
	    hauteur = (taille_police + 2) * 2;
	    save_fond_2 = my_pixmap_001->pixmap()->convertToImage();
	    // Resscale background image
	    save_fond_2 =
		save_fond_2.smoothScale(720, 405, QImage::ScaleFree);

	    bt_fantome->setPixmap(save_fond_2.copy
				  (slider_x->value(),
				   slider_y->value(), longueur,
				   hauteur, 0));
	    bt_fantome->setGeometry(23 + slider_x->value(),
				    23 + slider_y->value(),
				    longueur, hauteur);
	    bt_fantome->show();
	    bt_fantome->raise();
	    myfont.setFixedPitch(true);

	    // *** Dessin du texte sur le bouton tat normal ***********
	    QPainter mypainter(this);
	    mypainter.end();
	    mypainter.begin(bt_fantome->pixmap());
	    mypainter.setPen(couleur_1);
	    mypainter.setFont(myfont);
	    mypainter.drawText(0, hauteur / 2, nomfilm);
	    mypainter.end();


	    bt_fantome_2->pixmap()->fill(couleur_2);
	    bt_fantome_3->pixmap()->fill(couleur_3);

	    // Need to be > 30 not to go off off bounds
	    slider_x->setRange(30, 650);
	    slider_y->setRange(10, 550);

	    // *** Rglage des barres de dfilement ***
	    slider_x->setMaxValue(720 - longueur);
	    slider_y->setMaxValue(405 - hauteur);	// Was 576
	} else {

	    // *** Bouton image sur le menu *** 
	    wsavbtmenu.load(wpathbtmenu, 0);
	    if (wsavbtmenu.width() > 700 || wsavbtmenu.height() > 500) {
		QImage reducesize(wpathbtmenu, 0);
		wsavbtmenu =
		    reducesize.smoothScale(500, 350, QImage::ScaleMax);
	    }
	    longueur = wsavbtmenu.width();
	    hauteur = wsavbtmenu.height();
	    wdefhaut = hauteur;
	    wdeflong = longueur;
	    save_fond_2 = my_pixmap_001->pixmap()->convertToImage();
	    bt_fantome->setPixmap(save_fond_2.copy
				  (slider_x->value(),
				   slider_y->value(), longueur,
				   hauteur, 0));
	    bt_fantome->setGeometry(23 + slider_x->value(),
				    23 + slider_y->value(),
				    longueur, hauteur);
	    bt_fantome->show();
	    bt_fantome->raise();

	    // *** Rglage des barres de dfilement ***
	    slider_x->setMaxValue(720 - longueur);
	    slider_y->setMaxValue(405 - hauteur);	// Was 576
	    // *** Dessin du bouton image sur le bouton tat normal ***********
	    QPainter mypainter(this);
	    mypainter.end();
	    mypainter.begin(bt_fantome->pixmap());
	    mypainter.drawImage(0, 0,
				wsavbtmenu.smoothScale(longueur, hauteur,
						       QImage::ScaleMax),
				0, 0, -1, -1);
	    mypainter.end();
	    bt_fantome_2->pixmap()->fill(couleur_2);
	    bt_fantome_3->pixmap()->fill(couleur_3);
	}

	// *** Blocage de la liste pendant le travail sur le bouton ***
	lst_video_2->setDisabled(true);
	bt_add_film_menu->setDisabled(true);
	bt_et04_con_2->setDisabled(true);
	bt_et04_con->setDisabled(true);
	bt_rename_chap->setDisabled(true);
	// *** On passe la zone de suret au plus haut niveau ***
	zs_1->hide();
	zs_2->hide();
	zs_3->hide();
	zs_4->hide();
	//
	if (wpathbtmenu == "") {
	    regle_2->setGeometry(23,
				 23 + slider_y->value() +
				 taille_police + 2, 720, 1);
	} else {
	    regle_2->setGeometry(23, 23 + slider_y->value() + hauteur + 2,
				 720, 1);
	    slider5->setValue(0);
	    slider6->setValue(0);
	    slider7->setValue(0);
	    slider5->setMinValue((longueur * -1) + 60);
	    slider6->setMinValue((hauteur * -1) + 60);
	    slider5->setMaxValue((700 - longueur) - 60);
	    slider6->setMaxValue((550 - hauteur) - 60);
	    if (wdeflong > wdefhaut) {
		slider7->setMinValue((longueur * -1) + 60);
		slider7->setMaxValue((700 - longueur) - 60);
	    } else {
		slider7->setMinValue((hauteur * -1) + 60);
		slider7->setMaxValue((550 - hauteur) - 60);
	    }
	}
	regle_1->setGeometry(22 + slider_x->value(), 23, 1, 405);	// WA5 576
	regle_1->show();
	regle_2->show();
	regle_1->raise();
	regle_2->raise();
	if (wpathbtmenu != "") {
	    bt_dyna_modif->show();
	    bt_dyna_modif->raise();
	}
	clqconstruct->setGeometry(1001, 0, longueur, hauteur);
	clqconstruct->setPixmap(save_fond_2.copy
				(slider_x->value(), slider_y->value(),
				 longueur, hauteur, 0));
	// *** Dessin du texte sur le bouton tat normal ***********
	QPainter mypainter(this);
	mypainter.end();
	mypainter.begin(clqconstruct->pixmap());

	if (wpathbtmenu == "") {
	    mypainter.setPen(couleur_1);
	    mypainter.setFont(myfont);
	    mypainter.drawText(0, hauteur / 2, nomfilm);
	} else {
	    maskeditDone = TRUE;
	    mypainter.drawImage(0, 0,
				wsavbtmenu.smoothScale(longueur, hauteur,
						       QImage::ScaleFree),
				0, 0, -1, -1);
	}
	mypainter.end();
    }
}

/* Clear menu button clicked */
void mainfrm::bt_renew_all_clicked()
{
    if (fautyrencoder == 0) {
	if (QMessageBox::question
	    (this, MANDVDVER,
	     tr
	     ("Warning! All movies will be reencoded if you clear the menu! Are you sure?"),
	     table_message[61], table_message[62], QString::null, 0,
	     1) == 0) {
	    max_boutons = 0;
	    QPixmap mypix(save_fond);
	    apercu_fond->setPixmap(mypix);
	    my_pixmap_001->setPixmap(mypix);
	    bt_et03_con_clicked();
	    // If menu cleared we must reeencode hole dvd! (If moved back after encoded movie)
	    fautyrencoder = 1;
	    maskeditDone = false;	// Detect if maskedit has been done
	}
    } else {
	max_boutons = 0;
	QPixmap mypix(save_fond);
	apercu_fond->setPixmap(mypix);
	my_pixmap_001->setPixmap(mypix);
	bt_et03_con_clicked();
    }
}

/* Mask edit button from DVD meny creation clicked */
void mainfrm::bt_maskedit_clicked()
{
    maskeditDone = true;
    Etape_04->setDisabled(true);
    tabpoint[0] = 0;
    tabpoint[1] = 0;
    wsavbtmenu = my_pixmap_001->pixmap()->convertToImage();
    editmask->setGeometry(0, 110, 1200, 700);
    editpix->setPixmap(*my_pixmap_002->pixmap());
    toolButton158->setOn(true);
    rc_004 = 0;
    outils0_clicked();
    buttonGroup63->setDisabled(true);
    editmask->show();
    editmask->raise();
    fcouleur->setBackgroundColor(couleur_2);
    //
    QListViewItem *j;
    rc_003 = 0;
    lstempl->clear();
    double tempy1 = 0.0;
    int tempnewy1 = 0;

    while (rc_003 < max_boutons) {
	// Change table_boutons_pos[rc_003][1] value to compensate for 16:9
	tempy1 = (double) table_boutons_pos[rc_003][1];
	tempy1 = tempy1 * (405.0 / 576.0);
	tempnewy1 = (int) tempy1;

	j = new QListViewItem(lstempl, table_boutons_lien[rc_003][0],
			      QString::number(table_boutons_pos[rc_003]
					      [0]),
			      QString::number(tempnewy1),
			      QString::number(table_boutons_pos[rc_003]
					      [2]),
			      QString::number(table_boutons_pos[rc_003]
					      [3]));
	rc_003 = rc_003 + 1;
    }
    //
    rc_003 = 0;
    int x1 = table_boutons_pos[0][0] + 3;
    int x2 = table_boutons_pos[0][2] + 2;
    // Compensate for 16:9 format on y1
    tempy1 = (double) table_boutons_pos[0][1];
    tempy1 = tempy1 * (405.0 / 576.0);
    tempnewy1 = (int) tempy1;
    int y1 = tempnewy1 + 3;
    int y2 = table_boutons_pos[0][3] + 2;

    lineh1->setGeometry(x1, y1, x2 - 6, 1);
    lineh2->setGeometry(x1, y1 + y2, x2 - 6, 1);
    linev1->setGeometry(x1, y1, 1, y2);
    linev2->setGeometry(x1 + x2 - 6, y1, 1, y2 + 1);
    lineh1->raise();
    lineh2->raise();
    linev1->raise();
    linev2->raise();
    //
    myfontmask = myfont;
    taille_police_mask = taille_police;
    testpol->setFont(myfontmask);
    //
    rc_001 = 0;
    rc_003 = 0;
    optsel1->setChecked(true);
}


/* Mask edit:  */
bool mainfrm::eventFilter(QObject * o, QEvent * e)
{
    // **********************
    // *** Filtrage des events ***
    // **********************
    if (fen_slideshow->isEnabled() == true
	&& fen_slideshow->isShown() == true) {
	if (e->type() == QEvent::MouseButtonPress) {
	    int i = 0;

	    while (table_pnt_img[i] != o && i < 100) {
		i = i + 1;
	    }
	    if (table_pnt_img[i] == o) {
		num_photo->setValue(i + 1);
	    }
	}
    } else {
	if (editmask->isEnabled() == true && editmask->isShown() == true) {
	    QMouseEvent *k = (QMouseEvent *) e;
	    if (e->type() == QEvent::MouseButtonRelease && rc_003 != 3) {
		tabpoint[0] = 0;
		tabpoint[1] = 0;
		lineh1->hide();
		lineh2->hide();
		linev1->hide();
		linev2->hide();
		QPixmap px;
		px.resize(editpix->size());
		::bitBlt(&px, 0, 0, editpix, 0, 0, 720, 405, Qt::CopyROP,
			 false);
		editpix->setPixmap(px);
		lineh1->show();
		lineh2->show();
		linev1->show();
		linev2->show();
		lineh1->raise();
		lineh2->raise();
		linev1->raise();
		linev2->raise();
	    }

	    if (e->type() == QEvent::MouseButtonPress && rc_003 == 2) {
		QPainter titi(this);
		titi.end();
		titi.begin(editpix);
		QPen monpinc2;
		QFontMetrics fm(myfontmask);
		QString machaine = lineEdit13->text();
		QChar chr = machaine.at(0);
		int decalagex = fm.leftBearing(chr);
		monpinc2.setColor(fcouleur->backgroundColor());
		titi.setPen(monpinc2);
		myfontmask.setStyleStrategy(QFont::NoAntialias);
		titi.setFont(myfontmask);
		titi.drawText(k->x() - decalagex, k->y(),
			      lineEdit13->text());
		titi.end();
		outils0_clicked();
	    }

	    if (e->type() == QEvent::MouseButtonPress && rc_003 == 3) {
		if (tabpoint[0] == 0 && tabpoint[1] == 0) {
		    tabpoint[0] = k->x();
		    tabpoint[1] = k->y();
		} else {
		    QPainter toto(this);
		    toto.end();
		    toto.begin(editpix);
		    QPen monpinc;
		    monpinc.setColor(fcouleur->backgroundColor());
		    monpinc.setWidth(brushsize->value());
		    toto.setPen(monpinc);
		    toto.drawLine(tabpoint[0], tabpoint[1], k->x(),
				  k->y());
		    tabpoint[0] = 0;
		    tabpoint[1] = 0;
		}
	    }

	    if (e->type() == QEvent::MouseMove) {
		locdblebuff->setPixmap(wsavbtmenu.copy
				       (k->x() - 58, k->y() - 36, 116,
					72));
		::bitBlt(zoommask, 0, 0, locdblebuff->pixmap(), 0, 0, 116,
			 72, Qt::CopyROP, false);
		if (k->state() == Qt::LeftButton && rc_003 < 2) {
		    if (tabpoint[0] == 0 && tabpoint[1] == 0) {
			tabpoint[0] = k->x();
			tabpoint[1] = k->y();
		    }
		    QPainter toto(this);
		    toto.end();
		    toto.begin(editpix);
		    if (rc_003 == 0) {
			QPen monpinc;
			monpinc.setColor(fcouleur->backgroundColor());
			monpinc.setWidth(brushsize->value());
			toto.setPen(monpinc);
			toto.drawLine(tabpoint[0], tabpoint[1], k->x(),
				      k->y());
			tabpoint[0] = k->x();
			tabpoint[1] = k->y();
		    } else {
			if (rc_003 == 1) {
			    toto.eraseRect(k->x(), k->y(),
					   brushsize->value(),
					   brushsize->value());
			}
		    }
		    toto.end();
		} else {
		    if (k->state() == Qt::LeftButton && rc_003 == 4) {
			QPainter toto(this);
			toto.end();
			toto.begin(editpix);
			QPen monpinc;
			QBrush mybrush;
			if (rc_004 == 0) {
			    mybrush.setStyle(Qt::SolidPattern);
			} else {
			    if (rc_004 == 1) {
				mybrush.setStyle(Qt::BDiagPattern);
			    } else {
				if (rc_004 == 2) {
				    mybrush.setStyle(Qt::FDiagPattern);
				} else {
				    if (rc_004 == 3) {
					mybrush.setStyle(Qt::
							 Dense4Pattern);
				    } else {
					mybrush.setStyle(Qt::
							 Dense6Pattern);
				    }

				}

			    }

			}

			mybrush.setColor(fcouleur->backgroundColor());
			monpinc.setStyle(Qt::NoPen);
			toto.setBrush(mybrush);
			toto.setPen(monpinc);
			toto.drawRect(k->x(), k->y(),
				      3 + brushsize->value(),
				      3 + brushsize->value());
			tabpoint[0] = 0;
			tabpoint[1] = 0;
			toto.end();
		    }
		}
	    }
	}
    }
    return QWidget::eventFilter(o, e);
}


/* Mask edit: List of videos clicked
 * This will change witch video to edit */
void mainfrm::lstempl_clicked(QListViewItem *)
{
    // *** Afficher le cadre de travail ***
    QListViewItem *i = lstempl->selectedItem();

    if (i != 0) {
	int x1;
	int x2;
	int y1;
	int y2;

	tmp_001 = i->text(1);
	x1 = tmp_001.toInt(&ok, 10);
	if (ok == false) {
	    x1 = 0;
	}

	tmp_001 = i->text(2);
	y1 = tmp_001.toInt(&ok, 10);
	if (ok == false) {
	    y1 = 0;
	}

	tmp_001 = i->text(3);
	x2 = tmp_001.toInt(&ok, 10);
	if (ok == false) {
	    x2 = 0;
	}

	tmp_001 = i->text(4);
	y2 = tmp_001.toInt(&ok, 10);
	if (ok == false) {
	    y2 = 0;
	}
	//
	x1 = x1 + 3;
	y1 = y1 + 3;
	x2 = x2 + 2;
	y2 = y2 + 2;
	//
	lineh1->setGeometry(x1, y1, x2 - 6, 1);
	lineh2->setGeometry(x1, y1 + y2, x2 - 6, 1);
	linev1->setGeometry(x1, y1, 1, y2);
	linev2->setGeometry(x1 + x2 - 6, y1, 1, y2 + 1);
	lineh1->raise();
	lineh2->raise();
	linev1->raise();
	linev2->raise();
    }
}


/* Set tab order in DVD menu creation */
void mainfrm::bt_tab_order_clicked()
{
    int wcpt001;
    wcpt001 = 0;
    QListViewItem *j;
    lsttab->clear();
    //
    while (wcpt001 < max_boutons) {
	if (table_boutons_lien[wcpt001][3] != "$$CHAP$$") {
	    j = new QListViewItem(lsttab,
				  table_boutons_lien[wcpt001][0],
				  QString::number(wcpt001));
	} else {
	    tmp_010 = table_boutons_lien[wcpt001][1];
	    rc_001 = tmp_010.find("|||", 0);

	    if (rc_001 != -1) {
		tmp_011 = tmp_010.mid(0, rc_001);
		j = new QListViewItem(lsttab,
				      tmp_011 + " - " +
				      table_boutons_lien[wcpt001][0],
				      QString::number(wcpt001));
	    }
	}
	wcpt001 = wcpt001 + 1;
    }
    //
    Etape_04->setDisabled(true);
    tab_order->setGeometry(350, 110, 300, 480);
    tab_order->show();
    lsttab->setSorting(1, true);
    lsttab->sort();
    tab_order->raise();
    lsttab->setSorting(-1, false);
}

/* Skriv tab order on DVD menu!? */
void mainfrm::bt_fermer_taborder_clicked()
{
    //
    QString sav_bt_lien[60][10];
    int sav_bt_pos[60][5];
    int wcpt001;
    wcpt001 = 0;

    while (wcpt001 < max_boutons) {
	sav_bt_lien[wcpt001][0] = table_boutons_lien[wcpt001][0];
	sav_bt_lien[wcpt001][1] = table_boutons_lien[wcpt001][1];
	sav_bt_lien[wcpt001][2] = table_boutons_lien[wcpt001][2];
	sav_bt_lien[wcpt001][3] = table_boutons_lien[wcpt001][3];
	sav_bt_lien[wcpt001][4] = table_boutons_lien[wcpt001][4];
	sav_bt_lien[wcpt001][5] = table_boutons_lien[wcpt001][5];
	sav_bt_lien[wcpt001][6] = table_boutons_lien[wcpt001][6];
	sav_bt_lien[wcpt001][7] = table_boutons_lien[wcpt001][7];
	sav_bt_lien[wcpt001][9] = table_boutons_lien[wcpt001][9];	// Bitrate
	//
	sav_bt_pos[wcpt001][0] = table_boutons_pos[wcpt001][0];
	sav_bt_pos[wcpt001][1] = table_boutons_pos[wcpt001][1];
	sav_bt_pos[wcpt001][2] = table_boutons_pos[wcpt001][2];
	sav_bt_pos[wcpt001][3] = table_boutons_pos[wcpt001][3];
	sav_bt_pos[wcpt001][4] = table_boutons_pos[wcpt001][4];

	wcpt001 = wcpt001 + 1;
    }
    //
    QListViewItem *lvi = lsttab->firstChild();
    wcpt001 = 0;

    while (wcpt001 < max_boutons) {
	tmp_001 = lvi->text(1);
	rc_001 = tmp_001.toInt(&ok, 10);
	if (ok == true) {
	    table_boutons_lien[wcpt001][0] = sav_bt_lien[rc_001][0];
	    table_boutons_lien[wcpt001][1] = sav_bt_lien[rc_001][1];
	    table_boutons_lien[wcpt001][2] = sav_bt_lien[rc_001][2];
	    table_boutons_lien[wcpt001][3] = sav_bt_lien[rc_001][3];
	    table_boutons_lien[wcpt001][4] = sav_bt_lien[rc_001][4];
	    table_boutons_lien[wcpt001][5] = sav_bt_lien[rc_001][5];
	    table_boutons_lien[wcpt001][6] = sav_bt_lien[rc_001][6];
	    table_boutons_lien[wcpt001][7] = sav_bt_lien[rc_001][7];
	    table_boutons_lien[wcpt001][9] = sav_bt_lien[rc_001][9];	// Bitrate
	    //
	    table_boutons_pos[wcpt001][0] = sav_bt_pos[rc_001][0];
	    table_boutons_pos[wcpt001][1] = sav_bt_pos[rc_001][1];
	    table_boutons_pos[wcpt001][2] = sav_bt_pos[rc_001][2];
	    table_boutons_pos[wcpt001][3] = sav_bt_pos[rc_001][3];
	    table_boutons_pos[wcpt001][4] = sav_bt_pos[rc_001][4];
	} else {
	    printf(tr("INTERNAL ERROR --- Please report a bug!"));
	}
	lvi = lvi->nextSibling();
	wcpt001 = wcpt001 + 1;
    }
    //
    tab_order->hide();
    Etape_04->setEnabled(true);
}

/* Tab order DVD menu: Move down!? */
void mainfrm::bt_down_tab_clicked()
{
    QListViewItem *i = lsttab->selectedItem();

    if (i != 0) {
	if (i->itemBelow() != NULL) {
	    i->moveItem(i->itemBelow());
	}
    }
}

/* Tab order DVD menu: Move up!? */
void mainfrm::bt_up_ab_clicked()
{
    QListViewItem *i = lsttab->selectedItem();

    if (i != 0) {
	if (i->itemAbove() != NULL) {
	    i->itemAbove()->moveItem(i);
	}
    }
}


/* Import music to the DVD menu */
void mainfrm::bt_fond_mus_clicked()
{
    QString myfic = QFileDialog::getOpenFileName("~",
						 tr
						 ("Sound (*.wav *.WAV *.MP3 *.mp3 *.ogg *.OGG)"),
						 this,
						 table_message[65],
						 table_message[69]);
    if (myfic.isNull()) {
	if (QMessageBox::question
	    (this, MANDVDVER, table_message[24], table_message[61],
	     table_message[62], QString::null, 0, 1) == 0) {
	    path_fond_musical = "";
	    loopsound->setCurrentItem(0);
	    loopsound->setDisabled(true);
	}
    } else {
	path_fond_musical = myfic;
	loopsound->setEnabled(true);
    }
}


/*** Slider for size of button with movie image ****/
void mainfrm::slider5_valueChanged(int)
{
    // ****************************************
    // *** Changement / aggrandissement du bouton ***
    // ****************************************
    longueur = wdeflong + slider5->value();
    //
    if (720 - longueur > 60) {
	clqconstruct->setGeometry(1001, 0, longueur, hauteur);
	clqconstruct->setPixmap(save_fond_2.copy
				(slider_x->value(), slider_y->value(),
				 longueur, hauteur, 0));
	// *** Dessin du texte sur le bouton tat normal ***********
	QPainter mypainter(this);
	mypainter.end();
	mypainter.begin(clqconstruct->pixmap());

	mypainter.drawImage(0, 0,
			    wsavbtmenu.smoothScale(longueur, hauteur,
						   QImage::ScaleFree), 0,
			    0, -1, -1);
	mypainter.end();
	bt_fantome->setGeometry(23 + slider_x->value(),
				23 + slider_y->value(), longueur, hauteur);
	bt_fantome->setPixmap(*clqconstruct->pixmap());
	// *** Rglage des barres de dfilement ***
	slider_x->setMaxValue(720 - longueur);
    } else {
	longueur = wdeflong - slider5->value();
    }
}

void mainfrm::slider6_valueChanged(int)
{
    // ****************************************
    // *** Changement / aggrandissement du bouton ***
    // ****************************************
    hauteur = wdefhaut + slider6->value();
    //
    if (405 - hauteur > 60) {	//Was 576
	clqconstruct->setGeometry(1001, 0, longueur, hauteur);
	clqconstruct->setPixmap(save_fond_2.copy
				(slider_x->value(), slider_y->value(),
				 longueur, hauteur, 0));
	// *** Dessin du texte sur le bouton tat normal ***********
	QPainter mypainter(this);
	mypainter.end();
	mypainter.begin(clqconstruct->pixmap());

	mypainter.drawImage(0, 0,
			    wsavbtmenu.smoothScale(longueur, hauteur,
						   QImage::ScaleFree), 0,
			    0, -1, -1);
	mypainter.end();
	// *** Dplacement des rgles ***
	regle_2->setGeometry(23, 23 + slider_y->value() + hauteur + 2,
			     720, 1);
	// *** Rglage des barres de dfilement ***
	slider_y->setMaxValue(405 - hauteur);	//Was 576
	bt_fantome->setGeometry(23 + slider_x->value(),
				23 + slider_y->value(), longueur, hauteur);
	bt_fantome->setPixmap(*clqconstruct->pixmap());
    } else {
	hauteur = wdefhaut - slider6->value();
    }
}

void mainfrm::slider7_valueChanged(int)
{
    // ****************************************
    // *** Changement / aggrandissement du bouton ***
    // ****************************************
    float ratio;
    if (wdeflong > wdefhaut) {
	longueur = wdeflong + slider7->value();
	ratio = wdeflong / wdefhaut;
	hauteur = wdefhaut + (slider7->value() / ratio);

	if (720 - longueur > 60) {
	    QImage zicitmp = wsavbtmenu.smoothScale(longueur, hauteur,
						    QImage::ScaleMax);
	    hauteur = zicitmp.height();
	    clqconstruct->setGeometry(1001, 0, longueur, hauteur);
	    clqconstruct->setPixmap(save_fond_2.copy(slider_x->value(),
						     slider_y->value(),
						     longueur, hauteur,
						     0));
	    // *** Dessin du texte sur le bouton tat normal ***********
	    QPainter mypainter(this);
	    mypainter.end();
	    mypainter.begin(clqconstruct->pixmap());
	    mypainter.drawImage(0, 0, zicitmp, 0, 0, -1, -1);
	    mypainter.end();
	    // *** Reglage des barres de dfilement ***
	    slider_x->setMaxValue(720 - longueur);
	    slider_y->setMaxValue(405 - hauteur);	// Was 576
	    //
	    bt_fantome->setGeometry(23 + slider_x->value(),
				    23 + slider_y->value(), longueur,
				    hauteur);
	    bt_fantome->setPixmap(*clqconstruct->pixmap());
	}
    } else {
	hauteur = wdefhaut + slider7->value();
	ratio = wdefhaut / wdeflong;
	longueur = wdeflong + (slider7->value() / ratio);

	if (405 - hauteur > 60) {	// Was 576
	    QImage zicitmp = wsavbtmenu.smoothScale(longueur, hauteur,
						    QImage::ScaleMin);
	    longueur = zicitmp.width();
	    clqconstruct->setGeometry(1001, 0, longueur, hauteur);
	    clqconstruct->setPixmap(save_fond_2.copy(slider_x->value(),
						     slider_y->value(),
						     longueur, hauteur,
						     0));
	    // *** Dessin du texte sur le bouton tat normal ***********
	    QPainter mypainter(this);
	    mypainter.end();
	    mypainter.begin(clqconstruct->pixmap());
	    mypainter.drawImage(0, 0, zicitmp, 0, 0, -1, -1);
	    mypainter.end();
	    // *** Reglage des barres de dfilement ***
	    slider_x->setMaxValue(720 - longueur);
	    slider_y->setMaxValue(405 - hauteur);	//Was 576
	    bt_fantome->setGeometry(23 + slider_x->value(),
				    23 + slider_y->value(), longueur,
				    hauteur);
	    bt_fantome->setPixmap(*clqconstruct->pixmap());
	}
    }
    regle_2->setGeometry(23, 23 + slider_y->value() + hauteur + 2, 720, 1);
}
