/*
This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.


    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA   02110-1301

see: http://www.fsf.org/licensing/licenses/gpl-howto.html
*/
#ifndef QPLAYER_GLOBAL_H
#define QPLAYER_GLOBAL_H

#define STATIC_TEMP "/tmp/"

// Here we define the media player backends
// Xine : http://xine.sf.net
#define ENGINE_XINE    0
// MPlayer : http://mplayerhq.hu
#define ENGINE_MPLAYER 1
// VideoLanClient : http://www.videolan.org
#define ENGINE_VLC     2

// Here we define the aspect ratios
#define ASPECT_AUTO    0
#define ASPECT_34      1
#define ASPECT_169     2
#define ASPECT_SQUARE  3

// These two variables define the color to use for the QuickDirectory (on the left side) buttons.
#define COLOR_QUICK_SELECTED 250, 150, 50
#define COLOR_QUICK_NORMAL   170, 170, 255

// This defines the width of the frame, which should be ignored for the drawing of the start/stop marker.
#define XOFFSET 2

// The maximal number of History files to be stored in the top combo box.
#define MAX_HISTORY_FILES 5

#endif // QPLAYER_GLOBAL_H


