#
# $Header: /opt/cvs/python/packages/share1.5/Pmv/Tests/test_Misc.py,v 1.20 2008/11/21 18:34:30 vareille Exp $
#
# $Id: test_Misc.py,v 1.20 2008/11/21 18:34:30 vareille Exp $
#

import sys
import unittest
from mglutil.regression import testplus

"""
This module implements a set of functions to test miscellaneous things in Pmv
"""


mv = None
ct = 0
totalCt = 3

class LogTests(unittest.TestCase):
    """
    setUp + tearDown form a fixture: working environment for the testing code
    """
    def startViewer(self):
        """
        start Viewer
        """
        global mv
        from Pmv.moleculeViewer import MoleculeViewer
        from MolKit import Read
        import Tkinter
        if mv is None:
            mv = MoleculeViewer(trapExceptions=False,
                            logMode='overwrite',
                            withShell=0, 
                            #verbose=False
                            )
            mv.setUserPreference(('warningMsgFormat', 'printed'))
            mv.browseCommands('fileCommands', commands=['readMolecule',],
                           package='Pmv')
            mv.setUserPreference(('warningMsgFormat', 'printed'), log = 0)
            #mv.browseCommands('fileCommands','Pmv')
            mv.loadModule('deleteCommands')
            mv.loadModule("bondsCommands")
            mv.setOnAddObjectCommands(['buildBondsByDistance','displayLines'], log=0)

            mv.browseCommands("interactiveCommands", package='Pmv')
            mv.browseCommands("colorCommands", package='Pmv')
            mv.browseCommands("selectionCommands", package='Pmv')
            mv.browseCommands("helpCommands", package='ViewerFramework')
            # Don't want to trap exceptions and errors... the user pref is set to 1 by
            # default
            mv.setUserPreference(('warningMsgFormat', 'printed'))
            mv.setUserPreference(('Transformation Logging', 'no'))
            #set up links to shared dictionary and current instance
        self.mv = mv 


    def setUp(self):
        """
        setUp
        """
        if not hasattr(self, 'mv'):
            self.startViewer()
 

    def tearDown(self):
        """
        cleanUp
        """
        pass
        #self.mv.Exit(0)
        #del self.mv



class SourceLogTests(LogTests):
    def test_SourceLogBug_1(self):
        global mv
        self.mv.source("./Data/littleScript.py")
        # Need to make sure that the log string has been added to mvAll.log.py
        from Tkinter import END
        logStr = self.mv.GUI.MESSAGE_BOX.tx.get(1.0, END)
        logList = logStr.split("\n")
        logList.reverse()
        ind = 0
        item = logList[0]
        #remove possible extra newline characters
        while item=="":
            ind = ind + 1
            item = logList[ind]
        self.assertEqual(item, 'self.colorByAtomType("1crn", log=0)')
        self.mv.Exit(0)
        #del self.mv
        delattr(self, 'mv')
        mv = None
        #logFile = open("./mvAll.log.py", 'r')
        #allLogs = logFile.readlines()
        #self.assertEqual(allLogs[-1], "self.source('./Data/littleScript.py', log = 0)\n")
        #logFile.close()


    def test_SourceLogBug_2(self):
        global mv
        #import pdb;pdb.set_trace()
        self.mv.source("./Data/withLog.py")
        # Need to make sure that the log string has been added to mvAll.log.py
        self.mv.Exit(0)
        #del self.mv
        delattr(self, 'mv')
        mv = None
        #from time import sleep
        #sleep(2)
        logFile = open("./mvAll.log.py", 'r')
        allLogs = logFile.readlines()
        allLogs.reverse()
        ind = 0
        item = allLogs[ind]
        ##remove possible extra newline characters
        while item=="\n":
            ind = ind + 1
            item = allLogs[ind]
        self.assertEqual(item ,  'self.source("./Data/littleScript.py",log=1)\n')
        logFile.close()
    

    def test_SourceLogBug_3(self):
        global mv
        self.mv.source("./Data/noLog.py")
        # Need to make sure that the log string has been added to mvAll.log.py
        self.mv.Exit(0)
        #del self.mv
        delattr(self, 'mv')
        mv = None
        logFile = open("./mvAll.log.py", 'r')
        allLogs = logFile.readlines()
        allLogs.reverse()
        ind = 0
        item = allLogs[ind]
        ##remove possible extra newline characters
        while item=="\n":
            ind = ind + 1
            item = allLogs[ind]
        self.assertEqual(item ,  'self.source("./Data/littleScript.py",log=0)\n')
        logFile.close()


    def test_SourceTexturedCloudsWithAlpha(self):
        global mv
        self.mv.GUI.setGeom(20,20,730,600)
        self.mv.source("./Data/clouds/alphaband_pmv.py")
        lArray=self.mv.GUI.VIEWER.currentCamera.GrabFrontBufferAsArray()
        from numpy import add
        lSum = add.reduce(lArray)
        self.assertTrue(   lSum == 73848000 
                        or lSum == 73167704 \
                        or lSum == 73168655 \
                        or lSum == 73163584 \
                        or lSum == 73162930 \
                        or lSum == 73163729, # MAC OSX (austral)
                        msg='test_SourceTexturedCloudsWithAlpha lSum:%d'%lSum )
        self.mv.Exit(0)
        delattr(self, 'mv')
        mv = None


if __name__ == '__main__':
    test_cases = [
        'SourceLogTests',
        ]
    
    unittest.main( argv=([__name__] + test_cases) )
    #to get verbose output use this line instead:
    #unittest.main( argv=([__name__, '-v'] + test_cases) )

