#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Wednesday 06 August 2008 16:17:25 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Tutorial/icoscage/icoscage_net.py,v 1.13 2008/08/06 23:19:16 vareille Exp $
#
# $Id: icoscage_net.py,v 1.13 2008/08/06 23:19:16 vareille Exp $
#

from traceback import print_exc

## loading libraries ##
from symserv.VisionInterface.SymservNodes import symlib
from MolKit.VisionInterface.MolKitNodes import molkitlib
from Vision.StandardNodes import stdlib
from DejaVu.VisionInterface.DejaVuNodes import vizlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

if __name__!='__main__' or withoutVision is False:
    pass
    masterNet.getEditor().addLibraryInstance(symlib,"symserv.VisionInterface.SymservNodes", "symlib")

    masterNet.getEditor().addLibraryInstance(molkitlib,"MolKit.VisionInterface.MolKitNodes", "molkitlib")

    masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

    masterNet.getEditor().addLibraryInstance(vizlib,"DejaVu.VisionInterface.DejaVuNodes", "vizlib")

try:
    ## saving node Read Molecule ##
    from MolKit.VisionInterface.MolKitNodes import ReadMolecule
    Read_Molecule_0 = ReadMolecule(constrkw={}, name='Read Molecule', library=molkitlib)
    masterNet.addNode(Read_Molecule_0,3,4)
    Read_Molecule_0.inputPortByName['filename'].widget.set("2plv.pdb", run=False)
    apply(Read_Molecule_0.configure, (), {'paramPanelImmediate': 1, 'expanded': True})
except:
    print "WARNING: failed to restore ReadMolecule named Read Molecule in network masterNet"
    print_exc()
    Read_Molecule_0=None

try:
    ## saving node Lines Macro ##
    from MolKit.VisionInterface.MolKitNodes import LinesMacro
    Lines_Macro_1 = LinesMacro(constrkw={}, name='Lines Macro', library=molkitlib)
    masterNet.addNode(Lines_Macro_1,3,145)
    Lines_Macro_1.macroNetwork.deleteNodes([Lines_Macro_1.macroNetwork.nodes[5]])
    output_Ports_3 = Lines_Macro_1.macroNetwork.opNode
    apply(output_Ports_3.configure, (), {'paramPanelImmediate': 1})
    output_Ports_3.move(219, 337)
    BondsByDist_4 = Lines_Macro_1.macroNetwork.nodes[2]
    BondsByDist_4.inputPortByName['cut_off'].widget.set(1.85, run=False)
    Select_Nodes_5 = Lines_Macro_1.macroNetwork.nodes[3]
    Select_Nodes_5.inputPortByName['nodeType'].widget.set("Atom", run=False)
    Select_Nodes_5.inputPortByName['selectionString'].widget.set("C,N,CA", run=False)
    from MolKit.VisionInterface.MolKitNodes import AtomsProperty
    Extract_Atom_Property_8 = AtomsProperty(constrkw={}, name='Extract Atom Property', library=molkitlib)
    Lines_Macro_1.macroNetwork.addNode(Extract_Atom_Property_8,-3,109)
    Extract_Atom_Property_8.inputPortByName['propertyName'].widget.set("number", run=False)
    apply(Extract_Atom_Property_8.configure, (), {'paramPanelImmediate': 1, 'expanded': True})
    from DejaVu.VisionInterface.GeometryNodes import IndexedPolylinesNE
    indexedPolylines_9 = IndexedPolylinesNE(constrkw={}, name='indexedPolylines', library=vizlib)
    Lines_Macro_1.macroNetwork.addNode(indexedPolylines_9,373,241)
    indexedPolylines_9.inputPortByName['name'].widget.set("", run=False)
    indexedPolylines_9.inputPortByName['geoms'].widget.set("indexedPolylines", run=False)
    apply(indexedPolylines_9.configure, (), {'paramPanelImmediate': 1, 'expanded': True})
    from DejaVu.VisionInterface.DejaVuNodes import ColorMapNE
    Color_Map_10 = ColorMapNE(constrkw={}, name='Color Map', library=vizlib)
    Lines_Macro_1.macroNetwork.addNode(Color_Map_10,196,224)
    Color_Map_10.inputPortByName['colorMap'].widget.set({'mini': 34, 'initialValue': None, 'name': 'cmap', 'ramp': [[1.1920928955078125e-07, 0.0, 1.0, 1.0], [0.0, 0.26666653156280518, 1.0, 1.0], [0.0, 0.5333331823348999, 1.0, 1.0], [0.0, 0.79999983310699463, 1.0, 1.0], [0.0, 1.0, 0.93333333730697632, 1.0], [0.0, 1.0, 0.66666668653488159, 1.0], [0.0, 1.0, 0.40000003576278687, 1.0], [0.0, 1.0, 0.13333338499069214, 1.0], [0.13333326578140259, 1.0, 0.0, 1.0], [0.39999991655349731, 1.0, 0.0, 1.0], [0.66666662693023682, 1.0, 0.0, 1.0], [0.93333327770233154, 1.0, 0.0, 1.0], [1.0, 0.80000007152557373, 0.0, 1.0], [1.0, 0.53333336114883423, 0.0, 1.0], [1.0, 0.26666668057441711, 0.0, 1.0], [1.0, 7.7715611723760958e-16, 0.0, 1.0]], 'labelGridCfg': {'column': 0, 'row': 1}, 'maxi': 6871, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 0, 'labelSide': 'top', 'row': 2}, 'labelCfg': {'text': 'colormap'}, 'class': 'NEColorMap'}, run=False)
    Color_Map_10.inputPortByName['filename'].widget.set("", run=False)

    ## saving connections for network Lines Macro ##
    Lines_Macro_1.macroNetwork.freeze()
    if Select_Nodes_5 is not None and Extract_Atom_Property_8 is not None:
        try:
            Lines_Macro_1.macroNetwork.connectNodes(
                Select_Nodes_5, Extract_Atom_Property_8, "nodes", "atoms", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Select_Nodes_5 and Extract_Atom_Property_8 in network Lines_Macro_1.macroNetwork"
    input_Ports_2 = Lines_Macro_1.macroNetwork.ipNode
    if input_Ports_2 is not None and indexedPolylines_9 is not None:
        try:
            Lines_Macro_1.macroNetwork.connectNodes(
                input_Ports_2, indexedPolylines_9, "new", "instanceMatrices", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between input_Ports_2 and indexedPolylines_9 in network Lines_Macro_1.macroNetwork"
    BondsGeometry_6 = Lines_Macro_1.macroNetwork.nodes[4]
    if BondsGeometry_6 is not None and indexedPolylines_9 is not None:
        try:
            Lines_Macro_1.macroNetwork.connectNodes(
                BondsGeometry_6, indexedPolylines_9, "indices", "indices", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between BondsGeometry_6 and indexedPolylines_9 in network Lines_Macro_1.macroNetwork"
    if BondsGeometry_6 is not None and indexedPolylines_9 is not None:
        try:
            Lines_Macro_1.macroNetwork.connectNodes(
                BondsGeometry_6, indexedPolylines_9, "coords", "coords", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between BondsGeometry_6 and indexedPolylines_9 in network Lines_Macro_1.macroNetwork"
    output_Ports_3 = Lines_Macro_1.macroNetwork.opNode
    if indexedPolylines_9 is not None and output_Ports_3 is not None:
        try:
            Lines_Macro_1.macroNetwork.connectNodes(
                indexedPolylines_9, output_Ports_3, "indexedPolylines", "new", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between indexedPolylines_9 and output_Ports_3 in network Lines_Macro_1.macroNetwork"
    if Extract_Atom_Property_8 is not None and Color_Map_10 is not None:
        try:
            Lines_Macro_1.macroNetwork.connectNodes(
                Extract_Atom_Property_8, Color_Map_10, "propertyValues", "values", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Extract_Atom_Property_8 and Color_Map_10 in network Lines_Macro_1.macroNetwork"
    if Color_Map_10 is not None and indexedPolylines_9 is not None:
        try:
            Lines_Macro_1.macroNetwork.connectNodes(
                Color_Map_10, indexedPolylines_9, "mappedColors", "colors", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Color_Map_10 and indexedPolylines_9 in network Lines_Macro_1.macroNetwork"
    Lines_Macro_1.macroNetwork.unfreeze()
    Lines_Macro_1.shrink()
except:
    print "WARNING: failed to restore LinesMacro named Lines Macro in network masterNet"
    print_exc()
    Lines_Macro_1=None

try:
    ## saving node Viewer ##
    from DejaVu.VisionInterface.DejaVuNodes import Viewer
    Viewer_11 = Viewer(constrkw={}, name='Viewer', library=vizlib)
    masterNet.addNode(Viewer_11,5,335)
    ##
        ## Saving State for Viewer
    Viewer_11.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': [0.03308019268578799, 0.43846153846153846, 0.17595431882784782, 1.0], 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'rootx': 736, 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 40.0, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 400, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -30.0], 'd2cutH': 255, 'far': 50.0, 'd1off': 4, 'lookFrom': [0.0, 0.0, 30.0], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 120.0, 121.0, 122.0, 123.0, 124.0, 125.0, 126.0, 127.0, 128.0, 129.0, 130.0, 131.0, 132.0, 133.0, 134.0, 135.0, 136.0, 137.0, 138.0, 139.0, 140.0, 141.0, 142.0, 143.0, 144.0, 145.0, 146.0, 147.0, 148.0, 149.0, 150.0, 151.0, 152.0, 153.0, 154.0, 155.0, 156.0, 157.0, 158.0, 159.0, 160.0, 161.0, 162.0, 163.0, 164.0, 165.0, 166.0, 167.0, 168.0, 169.0, 170.0, 171.0, 172.0, 173.0, 174.0, 175.0, 176.0, 177.0, 178.0, 179.0, 180.0, 181.0, 182.0, 183.0, 184.0, 185.0, 186.0, 187.0, 188.0, 189.0, 190.0, 191.0, 192.0, 193.0, 194.0, 195.0, 196.0, 197.0, 198.0, 199.0, 200.0, 201.0, 202.0, 203.0, 204.0, 205.0, 206.0, 207.0, 208.0, 209.0, 210.0, 211.0, 212.0, 213.0, 214.0, 215.0, 216.0, 217.0, 218.0, 219.0, 220.0, 221.0, 222.0, 223.0, 224.0, 225.0, 226.0, 227.0, 228.0, 229.0, 230.0, 231.0, 232.0, 233.0, 234.0, 235.0, 236.0, 237.0, 238.0, 239.0, 240.0, 241.0, 242.0, 243.0, 244.0, 245.0, 246.0, 247.0, 248.0, 249.0, 250.0, 251.0, 252.0, 253.0, 254.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'rooty': 410, 'd1scale': 0.080000000000000002}
    apply(Viewer_11.vi.cameras[0].Set, (), state)

    state = {'end': 40, 'density': 0.10000000000000001, 'color': [0.03308019268578799, 0.43846153846153846, 0.17595431882784782, 1.0], 'enabled': False, 'start': 25, 'mode': 'GL_LINEAR'}
    apply(Viewer_11.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [0.057222128, 0.057222128, 0.057222128], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'line', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(Viewer_11.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if Viewer_11.vi.rootObject:
        from opengltk.OpenGL import GL
        state = {'opacity': [0.82307690382003784], 'binding': [10.0, 10.0, 10.0, 10.0, 10.0, 10.0], 'shininess': [50.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[1.0, 1.0, 1.0, 0.82307690382003784]]}
        apply(Viewer_11.vi.rootObject.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if Viewer_11.vi.rootObject:
        Viewer_11.vi.rootObject.clipP = []
        Viewer_11.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

except:
    print "WARNING: failed to restore Viewer named Viewer in network masterNet"
    print_exc()
    Viewer_11=None

try:
    ## saving node Dial ##
    from Vision.StandardNodes import DialNE
    Dial_12 = DialNE(constrkw={}, name='Dial', library=stdlib)
    masterNet.addNode(Dial_12,181,12)
    Dial_12.inputPortByName['dial'].widget.set(198.0, run=False)
except:
    print "WARNING: failed to restore DialNE named Dial in network masterNet"
    print_exc()
    Dial_12=None

try:
    ## saving node IcosCage ##
    from symserv.VisionInterface.SymservNodes import IcosCage
    IcosCage_13 = IcosCage(constrkw={}, name='IcosCage', library=symlib)
    masterNet.addNode(IcosCage_13,180,142)
    _3_fold_16 = IcosCage_13.macroNetwork.nodes[2]
    _3_fold_16.inputPortByName['vector'].widget.set([0.57735026918962584, 0.57735026918962584, 0.57735026918962584], run=False)
    _3_fold_16.inputPortByName['point'].widget.set([0.0, 0, 0], run=False)
    _3_fold_16.inputPortByName['identity'].widget.set(1, run=False)
    _2_fold_17 = IcosCage_13.macroNetwork.nodes[3]
    _2_fold_17.inputPortByName['vector'].widget.set([1.0, 0.0, 0.0], run=False)
    _2_fold_17.inputPortByName['point'].widget.set([0.0, 0, 0], run=False)
    _2_fold_17.inputPortByName['identity'].widget.set(1, run=False)
    _2_fold_18 = IcosCage_13.macroNetwork.nodes[4]
    _2_fold_18.inputPortByName['vector'].widget.set([0.0, 0.0, 1.0], run=False)
    _2_fold_18.inputPortByName['point'].widget.set([0.0, 0, 0], run=False)
    _2_fold_18.inputPortByName['identity'].widget.set(0, run=False)
    _2_fold_19 = IcosCage_13.macroNetwork.nodes[5]
    _2_fold_19.inputPortByName['vector'].widget.set([0.0, 1.0, 0.0], run=False)
    _2_fold_19.inputPortByName['point'].widget.set([0.0, 0, 0], run=False)
    _2_fold_19.inputPortByName['identity'].widget.set(0, run=False)
    _0_0__0_525__0_____22 = IcosCage_13.macroNetwork.nodes[8]
    _0_0__0_525__0_____22.inputPortByName['command'].widget.set("[0.0, 0.525, 0.851]", run=False)
    _0_0__0_525__0_____22.inputPortByName['importString'].widget.set("", run=False)
    mul_23 = IcosCage_13.macroNetwork.nodes[9]
    apply(mul_23.inputPortByName['data2'].configure, (), {'datatype': 'float', 'originalDatatype': 'None'})
    apply(mul_23.outputPortByName['result'].configure, (), {'datatype': 'list'})
    mul_23.inputPortByName['operation'].widget.set("mul", run=False)
    mul_23.inputPortByName['applyToElements'].widget.set(1, run=False)
    _in1__24 = IcosCage_13.macroNetwork.nodes[10]
    apply(_in1__24.inputPortByName['in1'].configure, (), {'datatype': 'list', 'originalDatatype': 'None'})
    _in1__24.inputPortByName['command'].widget.set("[in1]", run=False)
    _in1__24.inputPortByName['importString'].widget.set("", run=False)

    ## saving connections for network IcosCage ##
    IcosCage_13.macroNetwork.freeze()
    IcosCage_13.macroNetwork.unfreeze()

    ## modifying MacroOutputNode dynamic ports
    output_Ports_15 = IcosCage_13.macroNetwork.opNode
    output_Ports_15.inputPorts[1].configure(singleConnection=True)
    output_Ports_15.inputPorts[2].configure(singleConnection=True)
    output_Ports_15.inputPorts[3].configure(singleConnection=True)
    IcosCage_13.shrink()
except:
    print "WARNING: failed to restore IcosCage named IcosCage in network masterNet"
    print_exc()
    IcosCage_13=None

try:
    ## saving node cageVertices ##
    from DejaVu.VisionInterface.GeometryNodes import Spheres
    cageVertices_27 = Spheres(constrkw={}, name='cageVertices', library=vizlib)
    masterNet.addNode(cageVertices_27,33,211)
    cageVertices_27.inputPortByName['radius'].widget.set(7.94444444444, run=False)
    cageVertices_27.inputPortByName['quality'].widget.set(11, run=False)
    cageVertices_27.inputPortByName['name'].widget.set("", run=False)
    cageVertices_27.inputPortByName['geoms'].widget.set("cageVertices", run=False)
except:
    print "WARNING: failed to restore Spheres named cageVertices in network masterNet"
    print_exc()
    cageVertices_27=None

try:
    ## saving node cageFaces ##
    from DejaVu.VisionInterface.GeometryNodes import IndexedPolygonsNE
    cageFaces_28 = IndexedPolygonsNE(constrkw={}, name='cageFaces', library=vizlib)
    masterNet.addNode(cageFaces_28,254,289)
    cageFaces_28.inputPortByName['name'].widget.set("", run=False)
    cageFaces_28.inputPortByName['geoms'].widget.set("cageFaces", run=False)
except:
    print "WARNING: failed to restore IndexedPolygonsNE named cageFaces in network masterNet"
    print_exc()
    cageFaces_28=None

try:
    ## saving node cageEdges ##
    from DejaVu.VisionInterface.GeometryNodes import Cylinders
    cageEdges_29 = Cylinders(constrkw={}, name='cageEdges', library=vizlib)
    masterNet.addNode(cageEdges_29,138,252)
    cageEdges_29.inputPortByName['radius'].widget.set(4.80555555556, run=False)
    cageEdges_29.inputPortByName['quality'].widget.set(7, run=False)
    cageEdges_29.inputPortByName['name'].widget.set("", run=False)
    cageEdges_29.inputPortByName['geoms'].widget.set("cageEdges", run=False)
except:
    print "WARNING: failed to restore Cylinders named cageEdges in network masterNet"
    print_exc()
    cageEdges_29=None

try:
    ## saving node Icosahedral ##
    from symserv.VisionInterface.SymservNodes import Icos1
    Icosahedral_30 = Icos1(constrkw={}, name='Icosahedral', library=symlib)
    masterNet.addNode(Icosahedral_30,62,79)
    apply(Icosahedral_30.configure, (), {'paramPanelImmediate': 1})
    Icosahedral_30.macroNetwork.deleteConnection(Icosahedral_30.macroNetwork.nodes[2], 'outMatrices', Icosahedral_30.macroNetwork.nodes[3], 'matrices')
    _5_fold_33 = Icosahedral_30.macroNetwork.nodes[2]
    _5_fold_33.inputPortByName['vector'].widget.set([0.0, 0.52549288072191591, 0.85079799735929229], run=False)
    _5_fold_33.inputPortByName['point'].widget.set([0.0, 0, 0], run=False)
    _5_fold_33.inputPortByName['identity'].widget.set(1, run=False)
    _3_fold_34 = Icosahedral_30.macroNetwork.nodes[3]
    _3_fold_34.inputPortByName['vector'].widget.set([0.57735026918962584, 0.57735026918962584, 0.57735026918962584], run=False)
    _3_fold_34.inputPortByName['point'].widget.set([0.0, 0, 0], run=False)
    _3_fold_34.inputPortByName['identity'].widget.set(1, run=False)
    _2_fold_35 = Icosahedral_30.macroNetwork.nodes[4]
    _2_fold_35.inputPortByName['vector'].widget.set([1.0, 0.0, 0.0], run=False)
    _2_fold_35.inputPortByName['point'].widget.set([0.0, 0, 0], run=False)
    _2_fold_35.inputPortByName['identity'].widget.set(1, run=False)
    _2_fold_36 = Icosahedral_30.macroNetwork.nodes[5]
    _2_fold_36.inputPortByName['vector'].widget.set([0.0, 0.0, 1.0], run=False)
    _2_fold_36.inputPortByName['point'].widget.set([0.0, 0, 0], run=False)
    _2_fold_36.inputPortByName['identity'].widget.set(0, run=False)
    _2_fold_37 = Icosahedral_30.macroNetwork.nodes[6]
    _2_fold_37.inputPortByName['vector'].widget.set([0.0, 1.0, 0.0], run=False)
    _2_fold_37.inputPortByName['point'].widget.set([0.0, 0, 0], run=False)
    _2_fold_37.inputPortByName['identity'].widget.set(0, run=False)
    from symserv.VisionInterface.SymservNodes import SymRotNE
    Rotate_39 = SymRotNE(constrkw={}, name='Rotate', library=symlib)
    Icosahedral_30.macroNetwork.addNode(Rotate_39,360,51)
    Rotate_39.inputPortByName['vector'].widget.set([1.0, 0.0, 0.0], run=False)
    Rotate_39.inputPortByName['point'].widget.set([0.0, 0, 0], run=False)
    Rotate_39.inputPortByName['angle'].widget.set(0.0, run=False)
    Rotate_39.inputPortByName['identity'].widget.set(0, run=False)
    apply(Rotate_39.configure, (), {'paramPanelImmediate': 1})
    from symserv.VisionInterface.SymservNodes import SymTransNE
    Translate_40 = SymTransNE(constrkw={}, name='Translate', library=symlib)
    Icosahedral_30.macroNetwork.addNode(Translate_40,360,114)
    Translate_40.inputPortByName['vector'].widget.set([0.0, 0.52504568096145199, 0.85107404666322961], run=False)
    Translate_40.inputPortByName['length'].widget.set(50.0, run=False)
    Translate_40.inputPortByName['identity'].widget.set(0, run=False)
    apply(Translate_40.configure, (), {'paramPanelImmediate': 1})

    ## saving connections for network Icosahedral ##
    Icosahedral_30.macroNetwork.freeze()
    if Rotate_39 is not None and Translate_40 is not None:
        try:
            Icosahedral_30.macroNetwork.connectNodes(
                Rotate_39, Translate_40, "outMatrices", "matrices", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Rotate_39 and Translate_40 in network Icosahedral_30.macroNetwork"
    if _5_fold_33 is not None and Rotate_39 is not None:
        try:
            Icosahedral_30.macroNetwork.connectNodes(
                _5_fold_33, Rotate_39, "outMatrices", "matrices", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between _5_fold_33 and Rotate_39 in network Icosahedral_30.macroNetwork"
    if Translate_40 is not None and _3_fold_34 is not None:
        try:
            Icosahedral_30.macroNetwork.connectNodes(
                Translate_40, _3_fold_34, "outMatrices", "matrices", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Translate_40 and _3_fold_34 in network Icosahedral_30.macroNetwork"
    Icosahedral_30.macroNetwork.unfreeze()

    ## modifying MacroOutputNode dynamic ports
    output_Ports_32 = Icosahedral_30.macroNetwork.opNode
    output_Ports_32.inputPorts[1].configure(singleConnection=True)
    Icosahedral_30.shrink()
    apply(Icosahedral_30.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Icos1 named Icosahedral in network masterNet"
    print_exc()
    Icosahedral_30=None

#masterNet.run()
masterNet.freeze()

## saving connections for network icoscage ##
if Read_Molecule_0 is not None and Lines_Macro_1 is not None:
    try:
        masterNet.connectNodes(
            Read_Molecule_0, Lines_Macro_1, "MolSets", "BondsByDist_molecules", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Read_Molecule_0 and Lines_Macro_1 in network masterNet"
if Dial_12 is not None and IcosCage_13 is not None:
    try:
        masterNet.connectNodes(
            Dial_12, IcosCage_13, "value", "mul_data2", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Dial_12 and IcosCage_13 in network masterNet"
if IcosCage_13 is not None and cageVertices_27 is not None:
    try:
        masterNet.connectNodes(
            IcosCage_13, cageVertices_27, "Apply Transf to Coords_coords", "coords", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between IcosCage_13 and cageVertices_27 in network masterNet"
if IcosCage_13 is not None and cageFaces_28 is not None:
    try:
        masterNet.connectNodes(
            IcosCage_13, cageFaces_28, "Apply Transf to Coords_coords", "coords", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between IcosCage_13 and cageFaces_28 in network masterNet"
if IcosCage_13 is not None and cageFaces_28 is not None:
    try:
        masterNet.connectNodes(
            IcosCage_13, cageFaces_28, "faces_indices", "indices", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between IcosCage_13 and cageFaces_28 in network masterNet"
if cageFaces_28 is not None and Viewer_11 is not None:
    try:
        masterNet.connectNodes(
            cageFaces_28, Viewer_11, "indexedPolygons", "geometries", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between cageFaces_28 and Viewer_11 in network masterNet"
if IcosCage_13 is not None and cageEdges_29 is not None:
    try:
        masterNet.connectNodes(
            IcosCage_13, cageEdges_29, "Apply Transf to Coords_coords", "coords", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between IcosCage_13 and cageEdges_29 in network masterNet"
if IcosCage_13 is not None and cageEdges_29 is not None:
    try:
        masterNet.connectNodes(
            IcosCage_13, cageEdges_29, "edges_indices", "indices", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between IcosCage_13 and cageEdges_29 in network masterNet"
if cageEdges_29 is not None and Viewer_11 is not None:
    try:
        masterNet.connectNodes(
            cageEdges_29, Viewer_11, "cylinders", "geometries", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between cageEdges_29 and Viewer_11 in network masterNet"
if cageVertices_27 is not None and Viewer_11 is not None:
    try:
        masterNet.connectNodes(
            cageVertices_27, Viewer_11, "spheres", "geometries", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between cageVertices_27 and Viewer_11 in network masterNet"
if Lines_Macro_1 is not None and Viewer_11 is not None:
    try:
        masterNet.connectNodes(
            Lines_Macro_1, Viewer_11, "indexedPolylines_indexedPolylines", "geometries", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Lines_Macro_1 and Viewer_11 in network masterNet"
if Icosahedral_30 is not None and Lines_Macro_1 is not None:
    try:
        masterNet.connectNodes(
            Icosahedral_30, Lines_Macro_1, "Merge_outMatrices", "indexedPolylines_instanceMatrices", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Icosahedral_30 and Lines_Macro_1 in network masterNet"
masterNet.runOnNewData.value = False


def loadSavedStates_Viewer_11(self=Viewer_11, event=None):
    ##
    ## Saving State for objects in Viewer
    ##

    ## Object root|indexedPolylines
    ## Object root|cageFaces
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': True, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': 1, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'cageFaces', 'backPolyMode': 'fill', 'inheritFrontPolyMode': True, 'inheritStipplePolygons': True, 'inheritBackPolyMode': True, 'scissor': 0, 'protected': False, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|cageFaces')
    if obj:
        apply(obj.Set, (), state)

    ## Material for cageFaces
    if obj:
        from opengltk.OpenGL import GL
        state = {'opacity': [0.63076925277709961], 'binding': [10, 10, 10, 10, 10, 10], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'shininess': [50.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[0.24638870358467102, 0.19015730917453766, 0.36666667461395264, 0.63076925277709961]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for cageFaces

    ## Clipping Planes for cageFaces
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for cageFaces

    ## Object root|cageEdges
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': True, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'cageEdges', 'backPolyMode': 'fill', 'inheritFrontPolyMode': True, 'inheritStipplePolygons': True, 'inheritBackPolyMode': True, 'scissor': 0, 'protected': False, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|cageEdges')
    if obj:
        apply(obj.Set, (), state)

    ## Material for cageEdges
    if obj:
        from opengltk.OpenGL import GL
        state = {'opacity': [1.0], 'binding': [10, 10, 10, 10, 10, 10], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'shininess': [50.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[1.0, 0.69511586427688599, 0.60750848054885864, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for cageEdges

    ## Clipping Planes for cageEdges
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for cageEdges

    ## Object root|cageVertices
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': True, 'stippleLines': False, 'replace': False, 'visible': True, 'immediateRendering': False, 'inheritLighting': True, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': True, 'pickable': True, 'pointWidth': 2, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': 0, 'depthMask': 1, 'inheritSharpColorBoundaries': True, 'scale': [1.0, 1.0, 1.0], 'lighting': True, 'inheritCulling': True, 'inheritShading': True, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': 0, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'cageVertices', 'backPolyMode': 'fill', 'inheritFrontPolyMode': True, 'inheritStipplePolygons': True, 'inheritBackPolyMode': True, 'scissor': 0, 'protected': False, 'inheritLineWidth': True, 'lineWidth': 2, 'inheritXform': 1}
    obj = self.vi.FindObjectByName('root|cageVertices')
    if obj:
        apply(obj.Set, (), state)

    ## Material for cageVertices
    if obj:
        from opengltk.OpenGL import GL
        state = {'opacity': [1.0], 'binding': [10, 10, 10, 10, 10, 10], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'shininess': [50.0], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[1.0, 0.42245891690254211, 0.69369715452194214, 1.0]]}
        apply(obj.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for cageVertices

    ## Clipping Planes for cageVertices
    if obj:
        obj.clipP = []
        obj.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for cageVertices

    ## End Object root|cageVertices

    ##
        ## Saving State for Viewer
    self.vi.TransformRootOnly(1)
    ##

    ## Light Model
    ## End Light Model

    ## Light sources
    ## End Light sources 7

    ## Cameras
    ## Camera Number 0
    state = {'color': [0.03308019268578799, 0.43846153846153846, 0.17595431882784782, 1.0], 'd2off': 1, 'height': 400, 'lookAt': [0.0, 0.0, 0.0], 'pivot': [0.0, 0.0, 0.0], 'translation': [0.0, 0.0, 0.0], 'sideBySideTranslation': 0.0, 'fov': 40.0, 'scale': [1.0, 1.0, 1.0], 'stereoMode': 'MONO', 'width': 400, 'sideBySideRotAngle': 3.0, 'boundingbox': 0, 'projectionType': 0, 'contours': False, 'd2cutL': 150, 'direction': [0.0, 0.0, -30.0], 'd2cutH': 255, 'far': 50.0, 'd1off': 4, 'lookFrom': [0.0, 0.0, 30.0], 'd1cutH': 60, 'antialiased': 0, 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'd1ramp': [0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 26.0, 27.0, 28.0, 29.0, 30.0, 31.0, 32.0, 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0, 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0, 49.0, 50.0, 51.0, 52.0, 53.0, 54.0, 55.0, 56.0, 57.0, 58.0, 59.0, 60.0, 61.0, 62.0, 63.0, 64.0, 65.0, 66.0, 67.0, 68.0, 69.0, 70.0, 71.0, 72.0, 73.0, 74.0, 75.0, 76.0, 77.0, 78.0, 79.0, 80.0, 81.0, 82.0, 83.0, 84.0, 85.0, 86.0, 87.0, 88.0, 89.0, 90.0, 91.0, 92.0, 93.0, 94.0, 95.0, 96.0, 97.0, 98.0, 99.0, 100.0, 101.0, 102.0, 103.0, 104.0, 105.0, 106.0, 107.0, 108.0, 109.0, 110.0, 111.0, 112.0, 113.0, 114.0, 115.0, 116.0, 117.0, 118.0, 119.0, 120.0, 121.0, 122.0, 123.0, 124.0, 125.0, 126.0, 127.0, 128.0, 129.0, 130.0, 131.0, 132.0, 133.0, 134.0, 135.0, 136.0, 137.0, 138.0, 139.0, 140.0, 141.0, 142.0, 143.0, 144.0, 145.0, 146.0, 147.0, 148.0, 149.0, 150.0, 151.0, 152.0, 153.0, 154.0, 155.0, 156.0, 157.0, 158.0, 159.0, 160.0, 161.0, 162.0, 163.0, 164.0, 165.0, 166.0, 167.0, 168.0, 169.0, 170.0, 171.0, 172.0, 173.0, 174.0, 175.0, 176.0, 177.0, 178.0, 179.0, 180.0, 181.0, 182.0, 183.0, 184.0, 185.0, 186.0, 187.0, 188.0, 189.0, 190.0, 191.0, 192.0, 193.0, 194.0, 195.0, 196.0, 197.0, 198.0, 199.0, 200.0, 201.0, 202.0, 203.0, 204.0, 205.0, 206.0, 207.0, 208.0, 209.0, 210.0, 211.0, 212.0, 213.0, 214.0, 215.0, 216.0, 217.0, 218.0, 219.0, 220.0, 221.0, 222.0, 223.0, 224.0, 225.0, 226.0, 227.0, 228.0, 229.0, 230.0, 231.0, 232.0, 233.0, 234.0, 235.0, 236.0, 237.0, 238.0, 239.0, 240.0, 241.0, 242.0, 243.0, 244.0, 245.0, 246.0, 247.0, 248.0, 249.0, 250.0, 251.0, 252.0, 253.0, 254.0, 255.0], 'suspendRedraw': False, 'd1cutL': 0, 'd2scale': 0.0, 'near': 0.10000000000000001, 'drawThumbnail': False, 'd1scale': 0.080000000000000002}
    apply(self.vi.cameras[0].Set, (), state)

    state = {'end': 40, 'density': 0.10000000000000001, 'color': [0.03308019268578799, 0.43846153846153846, 0.17595431882784782, 1.0], 'enabled': False, 'start': 25, 'mode': 'GL_LINEAR'}
    apply(self.vi.cameras[0].fog.Set, (), state)

    ## End Cameras

    ## Clipping planes
    ## End Clipping planes

    ## Root object
    state = {'scissorAspectRatio': 1.0, 'inheritStippleLines': 0, 'stippleLines': False, 'replace': True, 'visible': True, 'immediateRendering': False, 'inheritLighting': False, 'invertNormals': False, 'pivot': [0.0, 0.0, 0.0], 'rotation': [1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0], 'scissorH': 200, 'frontPolyMode': 'fill', 'blendFunctions': ('GL_SRC_ALPHA', 'GL_ONE_MINUS_SRC_ALPHA'), 'outline': False, 'instanceMatrices': [[1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0]], 'scissorX': 0, 'scissorY': 0, 'listed': True, 'inheritPointWidth': 0, 'pickable': 1, 'pointWidth': 3, 'scissorW': 200, 'needsRedoDpyListOnResize': False, 'stipplePolygons': False, 'pickableVertices': False, 'inheritMaterial': False, 'depthMask': 1, 'inheritSharpColorBoundaries': False, 'scale': [0.057222128, 0.057222128, 0.057222128], 'lighting': True, 'inheritCulling': False, 'inheritShading': False, 'shading': 'smooth', 'translation': [0.0, 0.0, 0.0], 'transparent': False, 'sharpColorBoundaries': True, 'culling': 'back', 'name': 'root', 'backPolyMode': 'line', 'inheritFrontPolyMode': False, 'inheritStipplePolygons': 0, 'inheritBackPolyMode': False, 'scissor': 0, 'inheritLineWidth': 0, 'lineWidth': 1, 'inheritXform': 0}
    apply(self.vi.rootObject.Set, (), state)

    ## End Root Object

    ## Material for root
    if self.vi.rootObject:
        from opengltk.OpenGL import GL
        state = {'opacity': [0.82307690382003784], 'binding': [10.0, 10.0, 10.0, 10.0, 10.0, 10.0], 'shininess': [50.0], 'emission': [[0.0, 0.0, 0.0, 1.0]], 'specular': [[0.89999997615814209, 0.89999997615814209, 0.89999997615814209, 1.0]], 'ambient': [[0.10000000149011612, 0.10000000149011612, 0.10000000149011612, 1.0]], 'diffuse': [[1.0, 1.0, 1.0, 0.82307690382003784]]}
        apply(self.vi.rootObject.materials[GL.GL_FRONT].Set, (), state)

        pass  ## needed in case there no modif
    ## End Materials for root

    ## Clipping Planes for root
    if self.vi.rootObject:
        self.vi.rootObject.clipP = []
        self.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

Viewer_11.restoreStates_cb = Viewer_11.restoreStatesFirstRun = loadSavedStates_Viewer_11
Viewer_11.menu.add_separator()
Viewer_11.menu.add_command(label='Restore states', command=Viewer_11.restoreStates_cb)

if __name__=='__main__':
    from sys import argv
    if withoutVision is True: # run without Vision
        masterNet.handleCmdLineArgs(argv[1:], locals())
    else: # run as a stand alone application while vision is hidden
        mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

