/*
 *   mwmcidp.c -- Mwave Modem AT Command Parser
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <mwmparse.h>
#include <mwmparsi.h>

static char szThisFile[] = "MWMCIDP.C";


/* Called by mwmload to initialize cid on or off   */
/* uses MWMPARSE global psi to reference the stateinfo structure          */
ULONG MWM_ENTRY mwmCidpInitCid(
  USHORT bCapability,                   /* FALSE(0) if caller id off      */
  ULONG ulDSPAddrCallerIDLength,        /* DSP address of cid data length */
  ULONG ulDSPAddrCallerIDData )         /* DSP address of cid buffer      */
{
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmcidp::mwmCidpInitCid entry\n");
  DPF("mwmCidpInit bCapability=%d,ulDSPAddr..Len=%lx,ulDSPAddr..Data=%lx",
        bCapability, ulDSPAddrCallerIDLength, ulDSPAddrCallerIDData);
  if( !bCapability )
  {
    psi->dsp.bCapability = 0;
    psi->dsp.ulDSPAddrCallerIDLength = 0l;
    psi->dsp.ulDSPAddrCallerIDData   = 0l;
  }
  else
  {
    psi->dsp.bCapability = 1;
    psi->dsp.ulDSPAddrCallerIDLength = ulDSPAddrCallerIDLength;
    psi->dsp.ulDSPAddrCallerIDData   = ulDSPAddrCallerIDData;
  }
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmcidp::mwmCidpInitCid exit ulRC 0\n");
  return 0l;
}

/* Called by mwmload to find the current #CID mode for dsp loading   */
ULONG MWM_ENTRY mwmCidpQueryCid( void )
{
  REGISTERS Registers;
  USHORT    usCID;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmcidp::mwmCidpQueryCid entry\n");
  if (!( mwmParseQueryModemRegisters(&Registers) == DSP_NOERROR ) )
  {                                             /* if query fails      */
     Registers.PoundCID = 0;                    /* just fake a 0       */
  } /* endif */

  switch (Registers.PoundCID)
  {
  case 0:
  case 1:
  case 2:
    usCID = (USHORT)Registers.PoundCID;
    break;
  default:
    DPF("mwmCidpQueryCid invalid=%d", Registers.PoundCID);
    usCID = 0;
    break;
  } /* endswitch */
  DPF("mwmCidpQueryCid returning #CID=%d", usCID);
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmcidp::mwmCidpQueryCid exit usCID %x\n",usCID);
  return usCID;
}

/* Called by mwmPoundCommand to handle #CID? */
USHORT mwmCidpCIDQuery(STATEINFO *psi)
{
  REGISTERS Registers;
  USHORT usParserStatus = 0;
  char    achTempString[2];
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmcidp::mwmCidpCIDQuery entry\n");
  if(!( mwmParseQueryModemRegisters(&Registers) == DSP_NOERROR ) )
  {                                            /* if query fails      */
    Registers.PoundCID = 0;                    /* just fake a 0       */
  } /* endif */
  DPF("mwmCidpCIDQuery get #CID=%d", Registers.PoundCID);

  achTempString[0] = Registers.PoundCID | '0';  /* bin->ASCII convert  */
  achTempString[1] = '\0';
  usParserStatus = mwmParseEchoString(psi,achTempString);
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmcidp::mwmCidpCIDQuery exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

/* Called by mwmPoundCommand to handle #CID= (copied from mwmpound.c)*/
USHORT  mwmCidpCIDCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParm;
  char   szEnabledCapabilities[]="0,1,2";
  char   szDisabledCapabilities[]="0";
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmcidp::mwmCidpCIDCommand entry\n");
  if ( psi->achCommandBuffer[psi->usNextATIndex] == '?' )
  {  /* #CID=?" */
    if( psi->dsp.bCapability == 0 )
    { /* caller id is disabled */
      usParserStatus = mwmParseEchoString(psi,szDisabledCapabilities);
    }
    else
    { /* caller id is enabled */
      usParserStatus = mwmParseEchoString(psi,szEnabledCapabilities);
    } /* endif */
    if (!(usParserStatus & MWM_GET_MORE_BUFFERS) )
    { /* advance over the '?' */
      psi->usNextATIndex++;
    } /* endif */
  }
  else
  {
    usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                        &psi->usNextATIndex);
    DPF("mwmCidpCIDCommand set #CID=%d", usParm);
    usParserStatus = mwmCidpPoundCIDCommand( psi, usParm );
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmcidp::mwmCidpCIDCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}


/* Called by mwmCidpCIDCommand and mwmIniatilizeModem */
USHORT  mwmCidpPoundCIDCommand(STATEINFO *psi, USHORT usParm)
{
  REGISTERS Registers;
  USHORT usParserStatus = 0;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmcidp::mwmCidpPoundCIDCOmmand entry\n");
//  DPF("mwmCidpPoundCIDCommand entry");
  if ( !(mwmParseQueryModemRegisters(&Registers) == DSP_NOERROR ) )
  {                                             /* if query fails      */
     Registers.PoundCID = 0;                    /* just fake a 0       */
  } /* endif */
  if (!(usParm == Registers.PoundCID) )
  {
//    DPF("mwmCidpPoundCIDCommand=%d from PoundCID=%d", usParm, Registers.PoundCID);
    if ( (psi->usNextPPIndex + 2) < PP_BUFFER_THRESHOLD)
    {
      switch (usParm)
      {
        case 1:
        case 2:
          if(!( psi->dsp.bCapability ) )
          {
             usParserStatus = MWM_ATCMD_ERROR;
             break;
          }
          /* if bCapability is TRUE, fall through to do it */
        case 0:
          psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x24 | psi->usParserMode);
          psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 60+usParm;
          Registers.PoundCID=usParm;
          DPF("mwmCidpCIDCommand set #CID=%d", Registers.PoundCID);
          mwmParseSetModemRegisters(&Registers);
          /* in case of error I could defer the PP command but ??? */
          break;
        default:
          usParserStatus = MWM_ATCMD_ERROR;
          break;
      }
    }
    else
    {
      /*********************************************************************/
      /* There is not enough room left in this PP Command buffer to process*/
      /* this command....                                                  */
      /*********************************************************************/
      usParserStatus = MWM_GET_MORE_BUFFERS;
      psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
    } /* endif */
  } /* endif */
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmcidp::mwmCidpPoundCIDCOmmand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}



/* Called by mwmIPC1 to handle caller ID message */
#define MAXCALLERIDLENGTH          256

#define UNKNOWN_MESSAGE_FORMAT     0x00
#define SINGLE_MESSAGE_FORMAT      0x04
#define MULTI_MESSAGE_FORMAT       0x80

#define HEADER_LEN     2
#define MESSAGE_FORMAT 0
#define MESSAGE_LEN    1

#define DATE_TIME_PARM             0x01
#define CALLING_LINE_ID_PARM       0x02 /* this has area code */
#define DN_PARM                    0x03 /* was 2 mts 4034, no area code if not needed to dial */
#define REASON_NO_DN_PARM          0x04
#define NAME_PARM                  0x07
#define REASON_NO_NAME_PARM        0x08

#define SUBHEADER_LEN  2
#define PARM_TYPE      0
#define PARM_LEN       1

/* These buffers are defined as static rather than automatic to ease the */
/* use of the stack.  Since they are only used in response to a caller ID */
/* interrupt, they may not even have to be replicated when we go to a */
/* modem. */
#define DATELENGTH 4    /* each byte is printed %c */
static char   szDate[]="DATE = ";
#define TIMELENGTH 4    /* each byte is printed %c */
static char   szTime[]="TIME = ";
#define NAMELENGTH 32   /* each byte is printed %c */
static char   szName[]="NAME = ";
#define NMBRLENGTH 20   /* each byte is printed %c */
static char   szNmbr[]="NMBR = ";
#define MESGLENGTH 20   /* each byte is printed %02X */
static char   szMesg[]="MESG = ";
#define HEADERLENGTH 7    /* offset in szXXXX to start data */

#define RAWLENGTH 60    /* each byte is printed %02X */

static USHORT usBuffer[MAXCALLERIDLENGTH+1];
  /* We allow up to 255 chars in the caller ID message+1(to read CRC) */
  /* +1(to allow usBufferIndex to possibly become equal to MAXCALLERIDLENGTH) */
static char   szDTEBuffer[HEADERLENGTH+DATELENGTH+2+
                          HEADERLENGTH+TIMELENGTH+2+
                          HEADERLENGTH+NAMELENGTH+2+
                          HEADERLENGTH+NMBRLENGTH+2+
                          HEADERLENGTH+(2*MESGLENGTH)+2+1];
  /* We size the DTE buffer for the maximum message */

USHORT mwmCidpParseCID(STATEINFO *psi)
{
  REGISTERS Registers;

  ULONG  ulRC;

  USHORT usCallerIDState;       /* enumerated state variable */
  #define  DONE       0
  #define  FORMATTED  1
  #define  RAW        2
  #define  MULTIFIELD 3

  USHORT usBufferCount;         /* length of the data */
  USHORT usFieldLength;         /* field length */
  USHORT usBufferIndex;         /* index into dsp USHORT buffer */
  char far * pDTEBuffer;        /* char ptr to string buffer */
  USHORT usDTEBufferCount;      /* running count of the DTE buffer length */

  USHORT i;                     /* for loop index */

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmcidp::mwmCidpParseCID entry\n");

  if( (psi->dsp.ulDSPAddrCallerIDLength == 0l) ||
       (psi->dsp.ulDSPAddrCallerIDData   == 0l) ||
       (psi->dsp.bCapability == 0) )
  {    /* if I don't have dsp info just leave */
     DPF("mwmCidpParseCID no dsp info");
     return 0;
   }
   ulRC = dspMemTransfer(psi->dsp.hDSP, psi->dsp.ulDSPAddrCallerIDLength,
                        &usBufferCount,
                        1,
                        DSP_MEMXFER_DATA_READ);
   if (ulRC!=DSP_NOERROR)
   {
     mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                      MWM_DSP_ERROR, ulRC );
     return (USHORT)ulRC;
   }

   /* 06/18/96 - if length is zero ignore */
   if( usBufferCount == 0 )
   {
     DPF("mwmCidpParseCID caller id reported length is 0");
     return 0;
   }
   /* 06/18/96 - end */

   if( !(usBufferCount < MAXCALLERIDLENGTH-1 ))/* range limit the buffer count */
   {
      usBufferCount = MAXCALLERIDLENGTH-1;
   }
   ulRC = dspMemTransfer(psi->dsp.hDSP, psi->dsp.ulDSPAddrCallerIDData,
                        &usBuffer[0],
                        usBufferCount, /*also get the CRC for raw */
                        DSP_MEMXFER_DATA_READ);
   if (ulRC!=DSP_NOERROR)
   {
     mwmIPCHandleError(szThisFile,__LINE__,&psi->mwmError,
                      MWM_DSP_ERROR, ulRC );
     return (USHORT)ulRC;
   }
   if(!( mwmParseQueryModemRegisters(&Registers) == DSP_NOERROR ) )
   {                                             /* if query fails      */
      Registers.PoundCID = 0;                    /* just fake a 0       */
   } /* endif */

   /* calculte predicted length */
   i = (usBuffer[1] & 0x7f) + 3;
   DPF("mwmCidpParseCid actual WR_COUNT=%d,predicted length=%d", usBufferCount,i );

   if( usBufferCount > i )
   {    /* if actual is greater than predicted, reduce to predicted */
      usBufferCount = i;
   }

   /* accumlate BCC */
   for( usBufferIndex=0, i=0; usBufferIndex < usBufferCount; usBufferIndex++ )
   {
      i+=usBuffer[usBufferIndex];
   }
   i &= 0xff;
   if(!( i == 0 ) )
   {    /* bad BCC, ignore buffer */
     DPF("mwmCidpParseCid BCC residue=0x%02x (should be 0)", i );
// This BCC routine worked with SINGLE MESSAGE FORMAT but failed with MULTI
//    so for now it does not dump the buffer.
//     mwmParseEchoString(psi,"");
//     mwmParseWriteCmdToDSP(psi,0);
//     return 0;
   }

   usBufferIndex = 0;
   usDTEBufferCount = 0;
   pDTEBuffer = &szDTEBuffer[0];
   *pDTEBuffer = '\0';

   switch( Registers.PoundCID )
   {
   case 0:
      usCallerIDState= DONE;
      break;
   case 1:
      usCallerIDState= FORMATTED;
      break;
   case 2:
      usCallerIDState= RAW;
      break;
   default :
      usCallerIDState= DONE;
      DPF("mwmCidpParseCid invalid PoundCID=%d", Registers.PoundCID);
      break;
   }
   while( (usBufferIndex < usBufferCount-3) && !(usCallerIDState==DONE))
   { /* The usBufferCount-3 is only for the multi-field case, where */
     /*  I have to have at least a field code, field length and crc */
     switch( usCallerIDState )
     {
     case RAW:
        usFieldLength = usBufferCount;
        /* Run the for loop to always move the usBufferIndex past the field */
        /* If the index would exceed the string buffer, then don't move the */
        /*    data.  This way we get to the next field w/o touching memory  */
        /*    outside my buffer. This move policy is done below also. */
        for(i=0; i<usFieldLength; i++)
        {
          if( i < RAWLENGTH )
          {     /* delivered with parity */
             sprintf( pDTEBuffer,"%02X", usBuffer[usBufferIndex] );
             pDTEBuffer += 2;
             usDTEBufferCount+=2;
          }
          usBufferIndex += 1;
        } /* endfor */
        *pDTEBuffer++ = '\r';
        *pDTEBuffer++ = '\n';
        *pDTEBuffer   = '\0';
        usDTEBufferCount +=3;
        usCallerIDState = DONE;
        break;
     case FORMATTED:
     {
        switch( usBuffer[usBufferIndex++] )
        {
        case SINGLE_MESSAGE_FORMAT:
           usFieldLength = usBuffer[usBufferIndex++] & 0x7f;
           if( !( usFieldLength < 9 ) )
           {    /* at least mmddhhssP */
//             DPF("mwmCidpParseCid valid single message");
             for(i=0; i< HEADERLENGTH; i++)
             {
               *pDTEBuffer++ = szDate[i];
             }
             usDTEBufferCount +=HEADERLENGTH;
             *pDTEBuffer++ = usBuffer[usBufferIndex++] & 0x7f;
             *pDTEBuffer++ = usBuffer[usBufferIndex++] & 0x7f;
             *pDTEBuffer++ = usBuffer[usBufferIndex++] & 0x7f;
             *pDTEBuffer++ = usBuffer[usBufferIndex++] & 0x7f;
             *pDTEBuffer++ = '\r';
             *pDTEBuffer++ = '\n';
             for(i=0; i< HEADERLENGTH; i++)
             {
               *pDTEBuffer++ = szTime[i];
             }
             usDTEBufferCount +=HEADERLENGTH;
             *pDTEBuffer++ = usBuffer[usBufferIndex++] & 0x7f;
             *pDTEBuffer++ = usBuffer[usBufferIndex++] & 0x7f;
             *pDTEBuffer++ = usBuffer[usBufferIndex++] & 0x7f;
             *pDTEBuffer++ = usBuffer[usBufferIndex++] & 0x7f;
             *pDTEBuffer++ = '\r';
             *pDTEBuffer++ = '\n';
             usDTEBufferCount +=12;
             usFieldLength -= 8;
             for(i=0; i< HEADERLENGTH; i++)
             {
               *pDTEBuffer++ = szNmbr[i];
             }
             usDTEBufferCount +=HEADERLENGTH;
             if( ! ( usFieldLength < NMBRLENGTH ) )
             { /* limit field length */
               usFieldLength = NMBRLENGTH;
             }
             for(i=0; i<usFieldLength; i++)
             {
                *pDTEBuffer++=usBuffer[usBufferIndex++] & 0x7f;
                usDTEBufferCount +=1;
             } /* endfor */
             *pDTEBuffer++ = '\r';
             *pDTEBuffer++ = '\n';
             *pDTEBuffer = '\0';
             usDTEBufferCount +=2;
           }
           usCallerIDState = DONE;
           break;
        case MULTI_MESSAGE_FORMAT:
           usCallerIDState = MULTIFIELD;
           usBufferIndex +=1;   /* skip over the total length */
           break;
        default :
           DPF("mwmCidpParseCid invalid message tag=%d", usBuffer[usBufferIndex-1]);
           usCallerIDState = DONE;
           break;
        }
        break;
     }
     case MULTIFIELD:
     {
        switch( usBuffer[usBufferIndex++] & 0x7f )
        {
        case DATE_TIME_PARM:
           usFieldLength = usBuffer[usBufferIndex++] & 0X7F;
           if( usFieldLength == 8 )
           {    /* fixed length field per TR-NWT-000031 */
//             DPF("mwmCidpParseCid valid DATE_TIME field");
             for(i=0; i< HEADERLENGTH; i++)
             {
               *pDTEBuffer++ = szDate[i];
             }
             *pDTEBuffer++ = usBuffer[usBufferIndex++] & 0x7f;
             *pDTEBuffer++ = usBuffer[usBufferIndex++] & 0x7f;
             *pDTEBuffer++ = usBuffer[usBufferIndex++] & 0x7f;
             *pDTEBuffer++ = usBuffer[usBufferIndex++] & 0x7f;
             *pDTEBuffer++ = '\r';
             *pDTEBuffer++ = '\n';
             for(i=0; i< HEADERLENGTH; i++)
             {
               *pDTEBuffer++ = szTime[i];
             }
             *pDTEBuffer++ = usBuffer[usBufferIndex++] & 0x7f;
             *pDTEBuffer++ = usBuffer[usBufferIndex++] & 0x7f;
             *pDTEBuffer++ = usBuffer[usBufferIndex++] & 0x7f;
             *pDTEBuffer++ = usBuffer[usBufferIndex++] & 0x7f;
             *pDTEBuffer++ = '\r';
             *pDTEBuffer++ = '\n';
             *pDTEBuffer = '\0';
             usDTEBufferCount += (12+HEADERLENGTH+HEADERLENGTH);
           }
           else
           {    /* bad field, ignore */
             DPF("mwmCidpParseCid invalid DATE_TIME field");
             *pDTEBuffer = '\0';
           }
           break;
        case CALLING_LINE_ID_PARM:
        case DN_PARM:
        case REASON_NO_DN_PARM:         /* should be length 1, P or O */
        case REASON_NO_NAME_PARM:       /* should be length 1, P or O */
//           DPF("mwmCidpParseCid valid CALLING_LINE, DN, NO_DN, NO_NAME field");
           for(i=0; i< HEADERLENGTH; i++)
           {
             *pDTEBuffer++ = szNmbr[i];
           }
           usDTEBufferCount +=HEADERLENGTH;
           usFieldLength = usBuffer[usBufferIndex++] & 0x7f;
           for(i=0; i<usFieldLength; i++)
           {
              if( i < NMBRLENGTH )
              {
                 *pDTEBuffer++ = usBuffer[usBufferIndex]& 0x7f;
                 usDTEBufferCount +=1;
              }
              usBufferIndex += 1;
           } /* endfor */
           *pDTEBuffer++ = '\r';
           *pDTEBuffer++ = '\n';
           *pDTEBuffer = '\0';
           usDTEBufferCount +=2;
           break;
        case NAME_PARM:
//           DPF("mwmCidpParseCid valid NAME field");
           for(i=0; i< HEADERLENGTH; i++)
           {
             *pDTEBuffer++ = szName[i];
           }
           usDTEBufferCount +=HEADERLENGTH;
           usFieldLength = usBuffer[usBufferIndex++] & 0x7f;
           for(i=0; i<usFieldLength; i++)
           {
              if( i < NAMELENGTH )
              {
                 *pDTEBuffer++ = usBuffer[usBufferIndex]& 0x7f;
                 usDTEBufferCount +=1;
              }
              usBufferIndex += 1;
           } /* endfor */
           *pDTEBuffer++ = '\r';
           *pDTEBuffer++ = '\n';
           *pDTEBuffer = '\0';
           usDTEBufferCount +=2;
           break;
        default :
           DPF("mwmCidpParseCid invalid field - treated as MESG");
           for(i=0; i< HEADERLENGTH; i++)
           {
             *pDTEBuffer++ = szMesg[i];
           }
           usDTEBufferCount +=HEADERLENGTH;
           usFieldLength = usBuffer[usBufferIndex++] & 0x7f;
           for(i=0; i<usFieldLength; i++)
           {
              if( i < MESGLENGTH )
              {  /* delivered with parity */
                 sprintf( pDTEBuffer,"%02X", usBuffer[usBufferIndex] );
                 pDTEBuffer += 2;
                 usDTEBufferCount +=2;
              }
              usBufferIndex += 1;
           } /* endfor */
           *pDTEBuffer++ = '\r';
           *pDTEBuffer++ = '\n';
           *pDTEBuffer = '\0';
           usDTEBufferCount +=2;
           break;
        }
        break;
     }
     default :
        DPF("mwmCidpParseCid invalid usCallerIDState tag=%d", usCallerIDState);
        usCallerIDState = DONE;
        break;
     }
  } /* endwhile */
//  DPF("mwmCidpParseCid Buffer length=%d", usDTEBufferCount);
  mwmParseEchoString(psi,szDTEBuffer);
  mwmParseWriteCmdToDSP(psi,0);
  /* NOTENOTE: This call usually would append OK<cr> to the end but the */
  /*    DSP code is giving me a special deal */
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmcidp::mwmCidpParseCID exit ulRC 0\n");
  return 0;
}

/*****************************************************************************/
/*                                                                           */
/* Distinctive Ring code added by SRP  9/10/96                               */
/*                                                                           */
/*****************************************************************************/

/* Called by mwmload to initialize sdr on or off   */
/* uses MWMPARSE global psi to reference the stateinfo structure          */
ULONG MWM_ENTRY mwmCidpInitDRing(
  USHORT bCapability)                   /* FALSE(0) if caller id off      */
{
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmcidp::mwmCidpInitDRing entry\n");
  DPF("mwmCidpInitDRing bCapability=%d", bCapability);
  if( !bCapability )
  {
    psi->dsp.bDRingCapability = 0;
  }
  else
  {
    psi->dsp.bDRingCapability = 1;
  }
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmcidp::mwmCidpInitDRing exit ulRC 0\n");
  return 0l;
}

/* Called by mwmload to find the current -SDR mode for dsp loading   */
ULONG MWM_ENTRY mwmCidpQueryDRing( void )
{
  REGISTERS Registers;
  USHORT    usDRing;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmcidp::mwmCidpQueryDRing entry\n");

  if (!( mwmParseQueryModemRegisters(&Registers) == DSP_NOERROR ) )
  {                                             /* if query fails      */
     Registers.DashSDR = 0;                  /* just fake a 0       */
  } /* endif */

  if (Registers.DashSDR <= 1)
  {
    usDRing = (USHORT)Registers.DashSDR;

  } else {
    DPF("mwmCidpQueryDRing invalid=%d", Registers.DashSDR);
    usDRing = 0;

  } /* end if */
  DPF("mwmCidpQueryDRing returning -SDR=%d", usDRing);
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmcidp::mwmCidpQueryDRing exit usDRing %x\n",usDRing);
  return usDRing;
}

/* Called by mwmDashCommand to handle -SDR? */
USHORT mwmCidpDRingQuery(STATEINFO *psi)
{
  REGISTERS Registers;
  USHORT    usParserStatus = 0;
  char      achTempString[4];
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmcidp::mwmCidpDRingQuery entry\n");
  if(!( mwmParseQueryModemRegisters(&Registers) == DSP_NOERROR ) )
  {                                            /* if query fails      */
    Registers.DashSDR = 0;                  /* just fake a 0       */
  } /* endif */
  DPF("mwmCidpDRingQuery get -SDR=%d", Registers.DashSDR);

  /* This needs to be changed to support >1 digit */
  achTempString[0] = Registers.DashSDR | '0';  /* bin->ASCII convert  */
  achTempString[1] = '\0';

  usParserStatus = mwmParseEchoString(psi,achTempString);
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmcidp::mwmCidpDRingQuery exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

/* Called by mwmDashCommand to handle -SDR= */
USHORT  mwmCidpDashSDRCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  USHORT usParm;
  char   szDisabledCapabilities[]="0";
  char   szEnabledCapabilities[]="0,1";
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmcidp::mwmCidpDashSDRCommand entry\n");
  if ( psi->achCommandBuffer[psi->usNextATIndex] == '?' )
  {  /* -SDR=?" */

    if( psi->dsp.bDRingCapability == 0 )
    { /* distinctive ring is disabled */
      usParserStatus = mwmParseEchoString(psi,szDisabledCapabilities);
    }
    else
    { /* distinctive ring is enabled */
      usParserStatus = mwmParseEchoString(psi,szEnabledCapabilities);
    } /* endif */

    if (!(usParserStatus & MWM_GET_MORE_BUFFERS) )
    { /* advance over the '?' */
      psi->usNextATIndex++;
    } /* endif */
  }
  else
  {
    usParm = mwmParseGetArgFromATString(psi->achCommandBuffer,
                                        &psi->usNextATIndex);
    DPF("mwmCidpDashSDRCommand set -SDR=%d", usParm);
    usParserStatus = mwmCidpDashSDRCommandSet( psi, usParm );
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmcidp::mwmCidpDashSDRCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}


/* Called by mwmCidpDashSDRCommand and mwmIniatilizeModem */
USHORT  mwmCidpDashSDRCommandSet(STATEINFO *psi, USHORT usParm)
{
  REGISTERS Registers;
  USHORT usParserStatus = 0;

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmcidp::mwmCidpDashSDRCommandSet entry\n");
  DPF("mwmCidpDashSDRCommandSet entry");
  if ( !(mwmParseQueryModemRegisters(&Registers) == DSP_NOERROR ) )
  {                                             /* if query fails      */
     Registers.DashSDR = 0;                  /* just fake a 0       */
  } /* endif */

  if (!(usParm == Registers.DashSDR) )
  {
    DPF("mwmCidpDashSDRCommandSet=%d from DashSDR=%d", usParm, Registers.DashSDR);
    if ( (psi->usNextPPIndex + 2) < PP_BUFFER_THRESHOLD)
    {
      switch (usParm)
      {
        case 1:
          if(!( psi->dsp.bDRingCapability ) )
          {
             usParserStatus = MWM_ATCMD_ERROR;
             break;
          }
        case 0:
          psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x24 | psi->usParserMode);
          psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 90+usParm;
          Registers.DashSDR=usParm;

          DPF("mwmCidpSDRCommandSet set -SDR=%d", Registers.DashSDR);

          mwmParseSetModemRegisters(&Registers);
          /* in case of error I could defer the PP command but ??? */
          break;
        default:
          usParserStatus = MWM_ATCMD_ERROR;
          break;
      }
    }
    else
    {
      /*********************************************************************/
      /* There is not enough room left in this PP Command buffer to process*/
      /* this command....                                                  */
      /*********************************************************************/
      usParserStatus = MWM_GET_MORE_BUFFERS;
      psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
    } /* endif */
  } /* endif */
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmcidp::mwmCidpDashSDRCommandSet exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}


