/* ============================================================
 * File  : itemtree.h
 * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
 * Date  : 2003-12-22
 * Description : tree of stream folder and items
 *
 * Copyright 2003 by Eric Giesselbach

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */


#ifndef ITEMTREE_H
#define ITEMTREE_H

#include <qdir.h>
#include <qptrlist.h>
#include <qstringlist.h>
#include <qobject.h>


// GUI interface uses StreamBrowser only

class StreamFolder;

class StreamObject : public QObject
{
  public:
    typedef QPtrList<StreamObject> ObjectList;

    StreamObject(const QString& sObjectName);
    ~StreamObject();

    void addObjectToList(StreamObject* item);
    void removeObjectFromList(StreamObject* streamObject);

    void clearObjectList();
    void nextObject(bool folded);
    void prevObject(bool folded);
    StreamObject* getObject();
    StreamObject* findObject(const QString& searchName);

    // retrieval and storage of tree status
    void setIndex(int index);
    int  getIndex();

    void setPrefix(QString prefix);
    void setName(QString nme);
    QString& getName();
    void resetDisplaySize(bool foldList, int rows, int offset, bool& onTop, bool& atBottom);
    QString& getNextDisplayStr();

    void setAction(unsigned int act);
    unsigned int getAction();

    ObjectList objectList;

    // display cursor, initialized to 0 but not managed by object
    int cursor;
    
    QString descr;
    
    void toggleMarked();
    bool marked;

  private:
    QString& getPrefixedName();
    QString& getDisplayStr(int index);

    QString name;
    QString prefix;
    QString prefixedName;

    int objectIndex;

    bool displayFolded;
    int displayIndex;
    int displayOffset;
    unsigned int displaySize;

    unsigned int action;
};


class StreamItem : public StreamObject
{
  public:
    StreamItem( StreamFolder *sParent, const QString& sName,
                const QString& sUrl, const QString& sDescr,
                const QString& sHandler );
    
    QString url;
    
    QString& getFolderName();
    QString handler;  // STREAM_* command or name of parser to use when user activates this item.
                      //   STREAM_DL: download before play (podcast files) 
    QStringList meta; // additional information. 

  private:
    StreamFolder *parent;
};


class StreamFolder : public StreamObject
{
  public:
    StreamFolder( const QString& sName );
    StreamItem* getStreamItem();
    
    QString caption;
};


class ItemTree : public StreamObject
{
  public:
    ItemTree();
    ~ItemTree();

    StreamFolder* getStreamFolder();
};

#endif /* ITEMTREE_H */
