#! /usr/bin/perl
#* ============================================================
# * File        : wwmp_pls.pl
# * Version     : 0.1
# * Author      : Eric
# * Date        : 2006-09-11
# * Description : parser for World Wide Media Project user playlist
# *               (http://www.worldwidemediaproject.com)
# * 
# * To use this parser
# * 1) copy this parser to ~/.mythtv/mythstream/parsers/wwmp/wwmp_pls.pl
# * 2) copy the Playlist URL from your user account profile on the
# *    World Wide Media Project site.
# * 3) add this stream item in MythStream:
# *      Stream Name   : My WWMP Favorites
# *      Stream URL    : [your Playlist URL]
# *      Stream Handler: wwmp/wwmp_pls
# *  
# *  
# * ============================================================ */

use English;
use XML::DOM;
use HTML::Entities;

#------------------------------------------------------------------------------
# Init
#------------------------------------------------------------------------------

&read_parse();    # get commandline parameters into @in
$source = $in[0]; # source filename from command line

my $doc = XML::DOM::Document->new;
my $head = $doc->createXMLDecl ('1.0');
my $root = $doc->createElement('items');

sub newNode
{
  local $name  = shift;
  local $value = shift;
  local $node = $doc->createElement($name);
  local $text = $doc->createTextNode($value);
  $node->appendChild($text);
  
  return $node;
}

#------------------------------------------------------------------------------
# read file into $data
#------------------------------------------------------------------------------

$datafile = $source;
open( INFO, "<$datafile" );      # Open file for reading
undef $/;
$data = <INFO>;                 # Read all
close(INFO);

#------------------------------------------------------------------------------
# Parse playlist
#------------------------------------------------------------------------------

# file1=mms://uasmedia.uas.alaska.edu/wmtencoder/uasbroadcast.wmv
# Title1=[United States][English]University of Alaska

sub dump_lines
{
  @lines = split ( "\n", $data);
  foreach $line(@lines)
  {
    if (@matches = ( $line =~ m/Title\d+=\[(.*)\]\[(.*)\](.*)$/ ) )
    {
      $country  = @matches[0];
      $language = @matches[1];
      $name     = @matches[2];
      
      @matches = ( $prevLine =~ m/file\d+=(.*)$/ );
      $url = @matches[0];
      
      $url =~ s/&(amp;){0}/&amp;/g;
      
      $item = $doc->createElement('item');
      $root->appendChild($item);
 
      $name = decode_entities($name);
     
      $item->appendChild( newNode('name', $name) );
      $item->appendChild( newNode('url', $url) );
      $item->appendChild( newNode('descr', "Country: $country, Language: $language") );
        
      # This action meta node requires the stations stationid, not yet present in
      # ubustream or pls format
      # When user selects "mark as nonfunctional", MythStream performs that action,
      # and displays a message based on the server response.
      
        #$stationid = ""; 
        #$meta = $doc->createElement('meta');
        #$meta->appendChild( newNode('name'   , 'action: mark as nonfunctional') );
        #$meta->appendChild( newNode('content', "wwmp/wwmp_act|marknf|$stationid") );
        #$meta->appendChild( newNode('viewer' , 'url') );
        #$item->appendChild( $meta );
    }

    $prevLine = $line;
  }
}

#------------------------------------------------------------------------------
# search url's in $data and place them in special format
#------------------------------------------------------------------------------

&dump_lines();

print $head->toString;
print $root->toString;
print "\n";

#--------------------------------------------------------------------------------
# get command line parameters
#--------------------------------------------------------------------------------

sub read_parse 
{
  local (*in) = @_ if @_;
  local ($i);
  push(@in, @ARGV);
  foreach $i (0 .. $#in) { $in[$i] =~ s/\+/ /g;}
  return scalar(@in);
}



