/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperColors;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.activity.CuptiActivityUvmCounter;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalUVM;
import com.nvidia.viper.model.TimelineKind;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TimelineUVM
extends Timeline
implements IModel {
    private long totalValue = 0L;
    private long totalDuration = 0L;
    private long totalThrashes = 0L;
    private long totalThrashingSize = 0L;
    private long totalThrottles = 0L;
    private long totalRemoteMapSource = 0L;
    private long totalRemoteMapSourceSize = 0L;
    private long totalRemoteMapDest = 0L;
    private long totalRemoteMapDestSize = 0L;
    private long totalDtoDSrcSize = 0L;
    private long totalDtoDDstSize = 0L;
    private long totalDtoDSrcDuration = 0L;
    private long totalDtoDDstDuration = 0L;
    private final Map<Integer, ViperColors.GradientColors> processColors = new HashMap<Integer, ViperColors.GradientColors>();
    private Set<ITimelineInterval> uvmIntervals = new HashSet<ITimelineInterval>();
    private final boolean isSegmented;
    private boolean initializedSummary = false;

    public TimelineUVM(String name, TimelineKind kind) {
        super(name, kind);
        this.isSegmented = false;
    }

    public TimelineUVM(String name, TimelineKind kind, boolean isSegmented) {
        super(name, kind);
        this.isSegmented = isSegmented;
    }

    public long getTotalValue() {
        if (this.totalValue == 0L) {
            switch (this.getKind()) {
                case UVM_MEMCPY_HTOD: 
                case UVM_MEMCPY_DTOH: 
                case UVM_MEMCPY_DTOD: 
                case UVM_PAGE_FAULT: 
                case UVM_GPU_PAGE_FAULT: {
                    if (this.getKind() != TimelineKind.UVM_PAGE_FAULT || this.isSegmented()) {
                        for (ITimelineInterval interval : this.getIntervals(false)) {
                            TimelineIntervalUVM uvmInterval = (TimelineIntervalUVM)interval;
                            Long value = uvmInterval.getCounterValue();
                            if (value == null) continue;
                            this.totalValue += value.longValue();
                        }
                        break;
                    }
                    this.totalValue = this.getIntervals(false).size();
                    break;
                }
            }
        }
        return this.totalValue;
    }

    public long getTotalDuration() {
        this.initTimelineSummary();
        return this.totalDuration;
    }

    @Override
    public List<ITimelineInterval> getIntervals(boolean loadAnalysis) {
        List<ITimelineInterval> result = super.getIntervals(loadAnalysis);
        result.addAll(this.uvmIntervals);
        return result;
    }

    public long getNumRecords() {
        long numRecords = 0L;
        for (ITimelineInterval interval : this.getIntervals(false)) {
            if (!(interval instanceof TimelineIntervalUVM)) continue;
            TimelineIntervalUVM tl = (TimelineIntervalUVM)interval;
            numRecords += tl.getNumRecords();
        }
        return numRecords;
    }

    private void initTimelineSummary() {
        if (!this.initializedSummary) {
            for (ITimelineInterval interval : this.getIntervals(false)) {
                if (!(interval instanceof TimelineIntervalUVM)) continue;
                TimelineIntervalUVM uvmInterval = (TimelineIntervalUVM)interval;
                this.totalDuration += uvmInterval.getDuration();
                switch (uvmInterval.getKind()) {
                    case UVM_THRASHING: {
                        this.totalThrashingSize += uvmInterval.getCounterValue();
                        ++this.totalThrashes;
                        break;
                    }
                    case UVM_PAGE_THROTTLING: {
                        ++this.totalThrottles;
                        break;
                    }
                    case UVM_REMOTE_MAP: {
                        Timeline ancestorTL = this.getAncestor(TimelineKind.DEVICE);
                        if (ancestorTL == null) {
                            if ((long)uvmInterval.getSrcId() == CuptiActivityUvmCounter.cpuId) {
                                this.totalRemoteMapSourceSize += uvmInterval.getCounterValue();
                                ++this.totalRemoteMapSource;
                                break;
                            }
                            if ((long)uvmInterval.getDstId() != CuptiActivityUvmCounter.cpuId) break;
                            this.totalRemoteMapDestSize += uvmInterval.getCounterValue();
                            ++this.totalRemoteMapDest;
                            break;
                        }
                        TimelineDevice deviceTL = (TimelineDevice)ancestorTL;
                        if (deviceTL.getId() == uvmInterval.getSrcId()) {
                            this.totalRemoteMapSourceSize += uvmInterval.getCounterValue();
                            ++this.totalRemoteMapSource;
                            break;
                        }
                        if (deviceTL.getId() != uvmInterval.getDstId()) break;
                        this.totalRemoteMapDestSize += uvmInterval.getCounterValue();
                        ++this.totalRemoteMapDest;
                        break;
                    }
                    case UVM_MEMCPY_DTOD: {
                        TimelineDevice deviceTL = (TimelineDevice)this.getAncestor(TimelineKind.DEVICE);
                        if (deviceTL.getId() == uvmInterval.getSrcId()) {
                            this.totalDtoDSrcDuration += uvmInterval.getDuration();
                            this.totalDtoDSrcSize += uvmInterval.getCounterValue();
                            break;
                        }
                        if (deviceTL.getId() != uvmInterval.getDstId()) break;
                        this.totalDtoDDstDuration += uvmInterval.getDuration();
                        this.totalDtoDDstSize += uvmInterval.getCounterValue();
                        break;
                    }
                }
            }
            this.initializedSummary = true;
        }
    }

    public Long getTotalThrashingSize() {
        this.initTimelineSummary();
        return this.totalThrashingSize;
    }

    public long getTotalThrashes() {
        this.initTimelineSummary();
        return this.totalThrashes;
    }

    public long getTotalPageThrottles() {
        this.initTimelineSummary();
        return this.totalThrottles;
    }

    public long getTotalRemoteMapSource() {
        this.initTimelineSummary();
        return this.totalRemoteMapSource;
    }

    public long getTotalRemoteMapSourceSize() {
        this.initTimelineSummary();
        return this.totalRemoteMapSourceSize;
    }

    public long getTotalRemoteMapDest() {
        this.initTimelineSummary();
        return this.totalRemoteMapDest;
    }

    public long getTotalRemoteMapDestSize() {
        this.initTimelineSummary();
        return this.totalRemoteMapDestSize;
    }

    public long getTotalDtoDSrcSize() {
        this.initTimelineSummary();
        return this.totalDtoDSrcSize;
    }

    public long getTotalDtoDDstSize() {
        this.initTimelineSummary();
        return this.totalDtoDDstSize;
    }

    public long getTotalDtoDSrcDuration() {
        this.initTimelineSummary();
        return this.totalDtoDSrcDuration;
    }

    public long getTotalDtoDDstDuration() {
        this.initTimelineSummary();
        return this.totalDtoDDstDuration;
    }

    @Override
    public boolean isSegmented() {
        return this.isSegmented;
    }

    public String getLegendTitle() {
        for (ITimelineInterval interval : this.uvmIntervals) {
            if (!(interval instanceof TimelineIntervalUVM)) continue;
            return ((TimelineIntervalUVM)interval).getLegendTitle();
        }
        return null;
    }

    public TimelineIntervalUVM getFirstInterval() {
        for (ITimelineInterval interval : this.uvmIntervals) {
            if (!(interval instanceof TimelineIntervalUVM)) continue;
            return (TimelineIntervalUVM)interval;
        }
        return null;
    }

    @Override
    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        TimelineDevice device = (TimelineDevice)this.getAncestor(TimelineKind.DEVICE);
        device.getId();
    }

    public void setIntervalColors(Integer processId, ViperColors.GradientColors color) {
        if (color == null) {
            this.processColors.remove(processId);
        } else {
            this.processColors.put(processId, color);
        }
    }

    public boolean addUvmInterval(ITimelineInterval interval) {
        this.uvmIntervals.add(interval);
        return true;
    }

    @Override
    public synchronized void addAdditionalIntervals() {
        for (ITimelineInterval interval : this.uvmIntervals) {
            this.addInterval(interval, false);
        }
    }
}

