/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.editor.SourceSassEditor;
import com.nvidia.viper.jni.OpenMPAggregate;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineKind;
import com.nvidia.viper.model.TimelineProcess;
import com.nvidia.viper.ui.IContextOwner;
import com.nvidia.viper.ui.OpenMPContentProvider;
import com.nvidia.viper.ui.OpenMPLabelProvider;
import com.nvidia.viper.ui.OpenMPLabelType;
import com.nvidia.viper.ui.SessionEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.ViewPart;

public class OpenMPView
extends ViewPart
implements IContextOwner,
ISessionPropertyChangeListener {
    private Session session;
    private Composite parent;
    private TableViewer table;
    private int processId;
    private static String processLabelPrefix = "Summary of OpenMP events on process: ";
    private Label processLabel;
    private ActivePartListener asListener = new ActivePartListener();

    public void createPartControl(Composite parent) {
        this.parent = parent;
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm form = toolkit.createScrolledForm(parent);
        GridLayout layout = new GridLayout();
        this.processLabel = new Label(form.getBody(), 128);
        this.processLabel.setBackground(form.getBackground());
        form.getBody().setLayout((Layout)layout);
        this.table = new TableViewer(form.getBody(), 4);
        this.table.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setContentProvider((IContentProvider)new OpenMPContentProvider());
        OpenMPLabelProvider NameLabelContentProvider = new OpenMPLabelProvider(OpenMPLabelType.name);
        TableViewerColumn column = new TableViewerColumn(this.table, 16384);
        column.getColumn().setWidth(220);
        column.setLabelProvider((CellLabelProvider)NameLabelContentProvider);
        column.getColumn().setText(NameLabelContentProvider.getTitle());
        OpenMPLabelProvider PercentageLabelContentProvider = new OpenMPLabelProvider(OpenMPLabelType.percentage);
        column = new TableViewerColumn(this.table, 16384);
        column.getColumn().setWidth(100);
        column.setLabelProvider((CellLabelProvider)PercentageLabelContentProvider);
        column.getColumn().setText(PercentageLabelContentProvider.getTitle());
        OpenMPLabelProvider totalTimeLabelContentProvider = new OpenMPLabelProvider(OpenMPLabelType.totalTime);
        column = new TableViewerColumn(this.table, 16384);
        column.getColumn().setWidth(100);
        column.setLabelProvider((CellLabelProvider)totalTimeLabelContentProvider);
        column.getColumn().setText(totalTimeLabelContentProvider.getTitle());
        OpenMPLabelProvider CallsLabelContentProvider = new OpenMPLabelProvider(OpenMPLabelType.calls);
        column = new TableViewerColumn(this.table, 16384);
        column.getColumn().setWidth(100);
        column.setLabelProvider((CellLabelProvider)CallsLabelContentProvider);
        column.getColumn().setText(CallsLabelContentProvider.getTitle());
        this.table.getTable().pack();
        this.table.getTable().setHeaderVisible(true);
        this.table.getTable().setLinesVisible(true);
        this.table.setComparator((ViewerComparator)new OpenMPComparator());
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this.asListener);
    }

    private void handleClosedActivePart(IWorkbenchPart part) {
        if (part instanceof SessionEditor) {
            this.table.setInput(null);
            this.processId = 0;
        }
    }

    private void handleNewActivePart(IWorkbenchPart part) {
        Session newSession = null;
        if (part instanceof SessionEditor) {
            newSession = ((SessionEditor)part).getSession();
        } else if (part instanceof SourceSassEditor) {
            newSession = ((SourceSassEditor)part).getSession();
        } else if (part instanceof OpenMPView) {
            newSession = ((OpenMPView)part).session;
        }
        Session oldSession = this.session;
        if (newSession != null) {
            this.session = newSession;
            this.session.addPropertyChangeListener(this);
            this.processId = this.session.getSummaryViewDefaultProcess();
            if (oldSession != null) {
                this.refreshView();
            }
        }
    }

    private void refreshView() {
        if (this.table != null && this.table.getControl() != null && !this.table.getControl().isDisposed()) {
            this.table.getTable().setVisible(false);
            this.table.setInput((Object)this.session.getOpenMPSummary(this.processId));
            if (this.processId != 0) {
                this.processLabel.setText(String.valueOf(processLabelPrefix) + new Integer(this.processId).toString());
            } else {
                this.processLabel.setText("");
            }
            this.table.refresh();
            this.table.getTable().setVisible(true);
        }
    }

    @Override
    public void propertyChange(IModel model, String propertyName) {
        if ("session:sInterval".equals(propertyName) && this.session != null && this.session.getPrimarySelected() != null) {
            Timeline timeline = this.session.getPrimarySelected().getTimeline();
            if (timeline.getKind() != TimelineKind.PROCESS) {
                timeline = timeline.getAncestor(TimelineKind.PROCESS);
            }
            if (timeline == null) {
                return;
            }
            this.processId = ((TimelineProcess)timeline).getId();
            this.table.setInput((Object)this.session.getOpenAccSummary(this.processId));
            if (this.processId != 0) {
                this.processLabel.setText(String.valueOf(processLabelPrefix) + new Integer(this.processId).toString());
            } else {
                this.processLabel.setText("");
            }
        }
    }

    @Override
    public void ownerChanged(IContextOwner oldOwner, IContextOwner newOwner) {
    }

    public void setFocus() {
        if (this.parent != null) {
            this.parent.setFocus();
        }
    }

    private class ActivePartListener
    implements IPartListener {
        private ActivePartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            OpenMPView.this.handleNewActivePart(part);
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            OpenMPView.this.handleNewActivePart(part);
        }

        public void partOpened(IWorkbenchPart part) {
            OpenMPView.this.handleNewActivePart(part);
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            OpenMPView.this.handleClosedActivePart(part);
        }
    }

    private class OpenMPComparator
    extends ViewerComparator {
        private OpenMPComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof OpenMPAggregate && e2 instanceof OpenMPAggregate) {
                return -((OpenMPAggregate)e1).compareTo((OpenMPAggregate)e2);
            }
            return 0;
        }
    }
}

