/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.BandwidthFormatter;
import com.nvidia.viper.ByteSizeFormatter;
import com.nvidia.viper.StringUtils;
import com.nvidia.viper.ViperColors;
import com.nvidia.viper.model.DependencyHighlightingStrategy;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineHighlightingStrategy;
import com.nvidia.viper.model.TimelineIntervalEnvironment;
import com.nvidia.viper.model.TimelineIntervalNvlink;
import com.nvidia.viper.model.TimelineNvlink;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class TimelineFigure
extends RectangleFigure {
    private static final Rectangle NO_CLIP = new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private static final int SHORTENED_STRING_MINIMUM_CHARS = 4;
    private static final int INTERVAL_TEXT_HMARGIN = 3;
    private static final int INTERVAL_TEXT_VMARGIN = 0;
    private static final int INTERVAL_GRADIENT_WIDTH_THRESHOLD = 1;
    private static final int INTERVAL_GRADIENT_HEIGHT_THRESHOLD = 2;
    public static final int ENV_INTERVAL_SYMBOL_HEIGHT = 6;
    public static final int ENV_INTERVAL_SYMBOL_WIDTH = 6;
    private final Timeline model;
    private final boolean showExtended;
    private double xScale = 1.0;
    private Set<ITimelineInterval> highlightIntervals = new HashSet<ITimelineInterval>();
    private boolean isSelected = false;
    private int minIntervalTextWidth = -1;
    private int minIntervalTextHeight = -1;
    private static int systemFontHeight = Integer.MIN_VALUE;

    public TimelineFigure(Timeline model) {
        this.model = model;
        this.showExtended = model.getKind().usesExtendedEnd();
        model.setFigure(this);
    }

    public void setXScale(double scale) {
        this.xScale = scale;
    }

    public boolean setHighlightIntervals(Set<ITimelineInterval> intervals) {
        if (intervals == null || intervals.isEmpty()) {
            if (this.highlightIntervals.isEmpty()) {
                return false;
            }
            this.highlightIntervals.clear();
            return true;
        }
        HashSet<ITimelineInterval> intervalsOnThisTL = new HashSet<ITimelineInterval>();
        for (ITimelineInterval interval : intervals) {
            if (!this.model.hasInterval(interval) || !this.model.canAddInterval(interval)) continue;
            intervalsOnThisTL.add(interval);
        }
        if (intervalsOnThisTL.containsAll(this.highlightIntervals) && intervalsOnThisTL.size() == this.highlightIntervals.size()) {
            return false;
        }
        this.highlightIntervals = intervalsOnThisTL;
        return true;
    }

    public void setIsSelected(boolean selected) {
        this.isSelected = selected;
    }

    protected Rectangle getRegionBounds(long start, long length, int height, Rectangle clip) {
        int x = (int)Math.round((double)start * this.xScale);
        int y = height >= 0 ? clip.y + this.model.getIntervalRowHeight() - height : clip.y;
        int regionHeight = height >= 0 ? height : clip.height;
        int regionWidth = (int)Math.round((double)length * this.xScale);
        Rectangle rect = new Rectangle(x, y, Math.max(1, regionWidth), regionHeight);
        rect.intersect(clip);
        return rect;
    }

    protected Rectangle getPrimaryIntervalBounds(ITimelineInterval interval, Rectangle clip) {
        return this.getRegionBounds(interval.getStart(), interval.getDuration(), interval.getHeight(this.model.getIntervalRowHeight()), clip);
    }

    protected Rectangle getExtendedIntervalBounds(ITimelineInterval interval, Rectangle clip) {
        return this.getRegionBounds(interval.getEnd(), interval.getExtendedEnd() - interval.getEnd(), interval.getHeight(this.model.getIntervalRowHeight()), clip);
    }

    protected Rectangle getIntervalBounds(ITimelineInterval interval, Rectangle clip) {
        return this.getRegionBounds(interval.getStart(), this.showExtended ? interval.getExtendedDuration() : interval.getDuration(), interval.getHeight(this.model.getIntervalRowHeight()), clip);
    }

    protected List<Point> getIntervalPoints(TimelineIntervalNvlink nvlinkInterval, Rectangle clip) {
        Rectangle rect = this.getRegionBounds(nvlinkInterval.getStart(), nvlinkInterval.getDuration(), nvlinkInterval.getHeight(this.model.getIntervalRowHeight()), clip);
        ArrayList<Point> points = new ArrayList<Point>();
        int yStart = rect.y + rect.height - nvlinkInterval.getStartHeight(this.model.getIntervalRowHeight());
        Point point1 = new Point(rect.x, yStart);
        points.add(point1);
        List<Long> intermediateTimestamps = nvlinkInterval.getIntermediateIntervals();
        for (Long intermediateTimestamp : intermediateTimestamps) {
            int yIndex = rect.y + rect.height - nvlinkInterval.getHeightAtTimestamp(intermediateTimestamp, this.model.getIntervalRowHeight());
            long duration = intermediateTimestamp - nvlinkInterval.getStart();
            int width = (int)Math.round((double)duration * this.xScale);
            width = Math.max(1, width);
            int xIndex = rect.x + width;
            points.add(new Point(xIndex, yIndex));
        }
        int yEnd = rect.y + rect.height - nvlinkInterval.getEndHeight(this.model.getIntervalRowHeight());
        Point point2 = new Point(rect.x + rect.width, yEnd);
        points.add(point2);
        return points;
    }

    protected void paintEnvSymbol(TimelineIntervalEnvironment interval, Graphics g, Rectangle clip, Color fgColor, ViperColors.GradientColors bgColors, int alpha) {
        if (this.model instanceof TimelineDevice) {
            int oldAlpha = g.getAlpha();
            if (alpha != -1) {
                g.setAlpha(alpha);
            }
            g.setForegroundColor(bgColors.primary);
            g.setBackgroundColor(bgColors.secondary);
            g.fillOval(this.getEnvSymbolRect(interval, clip).intersect(clip));
            g.setAlpha(oldAlpha);
        }
    }

    private void paintNvlinkInterval(TimelineIntervalNvlink interval, Graphics g, Rectangle clip, Color fgColor, ViperColors.GradientColors bgColors, int alpha) {
        if (this.model instanceof TimelineNvlink) {
            int oldAlpha = g.getAlpha();
            if (alpha != -1) {
                g.setAlpha(alpha);
            }
            g.setForegroundColor(bgColors.primary);
            g.setBackgroundColor(bgColors.secondary);
            List<Point> points = this.getIntervalPoints(interval, clip);
            int pointIndex = 0;
            while (pointIndex < points.size() - 1) {
                Point point1 = points.get(pointIndex);
                Point point2 = points.get(pointIndex + 1);
                g.drawLine(point1, point2);
                ++pointIndex;
            }
            g.setAlpha(oldAlpha);
        }
    }

    protected void paintNormalInterval(ITimelineInterval interval, Graphics g, Rectangle clip, Color fgColor, ViperColors.GradientColors bgColors, int alpha) {
        Color oldFg;
        Rectangle clipRect = this.getIntervalBounds(interval, clip);
        boolean useGradient = bgColors.secondary != null && clipRect.width > 1 && clipRect.height > 2;
        int oldAlpha = g.getAlpha();
        if (alpha != -1) {
            g.setAlpha(alpha);
        }
        g.setForegroundColor(bgColors.primary);
        g.setBackgroundColor(bgColors.secondary);
        if (useGradient) {
            g.fillGradient(clipRect, true);
        } else {
            g.fillRectangle(clipRect);
        }
        if (this.showExtended && interval.getExtendedEnd() > interval.getEnd()) {
            Rectangle primaryClipRect = this.getPrimaryIntervalBounds(interval, clip);
            Rectangle.SINGLETON.x = primaryClipRect.x + primaryClipRect.width;
            Rectangle.SINGLETON.y = clipRect.y + 1;
            Rectangle.SINGLETON.height = clipRect.height - 2;
            Rectangle.SINGLETON.width = clipRect.width - primaryClipRect.width - 1;
            if (Rectangle.SINGLETON.width > 0 && Rectangle.SINGLETON.height > 0) {
                g.setBackgroundColor(this.model.getBackgroundColor());
                g.fillRectangle(Rectangle.SINGLETON);
            }
        }
        if (clipRect.height > this.minIntervalTextHeight && clipRect.width > this.minIntervalTextWidth && alpha == -1) {
            Rectangle fullRect = this.getPrimaryIntervalBounds(interval, NO_CLIP);
            if (fullRect.width > this.minIntervalTextWidth) {
                fullRect.y = clipRect.y;
                fullRect.height = clipRect.height;
                Dimension textBounds = new Dimension(fullRect.width - 6, clipRect.height - 0);
                Font font = this.getLocalFont();
                String boundedText = StringUtils.getBoundedText(interval.getDisplayName(), textBounds, font, 4);
                if (boundedText != null) {
                    Dimension extents = FigureUtilities.getStringExtents((String)boundedText, (Font)font);
                    Point textLoc = fullRect.getCenter().translate(-extents.width / 2, -extents.height / 2);
                    g.setForegroundColor(fgColor);
                    g.drawText(boundedText, textLoc);
                }
            }
        }
        g.setAlpha(oldAlpha);
        if (this.model.getSession().isDrawOnCriticalPath(interval) && alpha == 50) {
            oldFg = g.getForegroundColor();
            g.setForegroundColor(ViperColors.INTERVAL_CRITICAL_PATH_UNSELECTED_COLOR);
            g.drawRectangle(clipRect);
            g.setForegroundColor(oldFg);
        }
        if (this.model.getKind().isUvmKind() && this.model.getSession().isDrawOnFilteredUvmIntervals(interval.getID()) && alpha == 50) {
            oldFg = g.getForegroundColor();
            g.setForegroundColor(ViperColors.INTERVAL_CRITICAL_PATH_UNSELECTED_COLOR);
            g.drawRectangle(clipRect);
            g.setForegroundColor(oldFg);
        }
    }

    private void paintInterval(ITimelineInterval interval, Graphics g, Rectangle clip, Color fgColor, ViperColors.GradientColors bgColors, int alpha) {
        if (interval instanceof TimelineIntervalNvlink) {
            this.paintNvlinkInterval((TimelineIntervalNvlink)interval, g, clip, fgColor, bgColors, alpha);
        } else if (interval instanceof TimelineIntervalEnvironment) {
            this.paintEnvSymbol((TimelineIntervalEnvironment)interval, g, clip, fgColor, bgColors, alpha);
        } else {
            this.paintNormalInterval(interval, g, clip, fgColor, bgColors, alpha);
        }
    }

    public Rectangle getEnvSymbolRect(TimelineIntervalEnvironment interval, Rectangle clip) {
        int scaledSymbolHeight;
        int symbolRadius;
        int x = (int)Math.round((double)interval.getStart() * this.xScale);
        int rowHeight = TimelineFigure.getScaledValue(this.model.getIntervalRowHeight());
        int yOffset = TimelineFigure.getScaledValue(((TimelineDevice)this.model).getYOffsetForEnvSymbol(interval));
        yOffset = yOffset < (symbolRadius = (scaledSymbolHeight = TimelineFigure.getScaledValue(6)) / 2) ? scaledSymbolHeight : (yOffset > rowHeight - symbolRadius ? rowHeight : (yOffset += symbolRadius));
        int y = clip.y + rowHeight - yOffset;
        return new Rectangle(x -= 3, y, Math.max(1, TimelineFigure.getScaledValue(6)), scaledSymbolHeight);
    }

    private void paintOuterBorderNormal(ITimelineInterval interval, Graphics g, Rectangle clip) {
        float lineWidth = Math.max(1.0f, this.getLineWidthFloat());
        int width = (int)Math.floor(lineWidth);
        Rectangle newClip = new Rectangle(clip).expand(this.getLineWidth() * 2, 0);
        Rectangle r = this.getPrimaryIntervalBounds(interval, newClip);
        r.x -= width;
        r.y -= width;
        r.width += width;
        r.height += width;
        g.drawRoundRectangle(r, 3, 3);
    }

    private void paintOuterBorderEnvSymbol(TimelineIntervalEnvironment interval, Graphics g, Rectangle clip) {
        g.drawOval(this.getEnvSymbolRect(interval, clip).intersect(clip));
    }

    protected void paintIntervalInnerBorder(ITimelineInterval interval, Graphics g, Rectangle clip, Color color, int alpha) {
        float lineInset = Math.max(1.0f, this.getLineWidthFloat()) / 2.0f;
        int inset1 = (int)Math.floor(lineInset);
        int inset2 = (int)Math.ceil(lineInset);
        Rectangle newClip = new Rectangle(clip).expand(this.getLineWidth() * 2, 0);
        Rectangle r = this.getPrimaryIntervalBounds(interval, newClip);
        r.x += inset1;
        r.y += inset1;
        r.width -= inset1 + inset2;
        r.height -= inset1 + inset2;
        int oldAlpha = g.getAlpha();
        g.setAlpha(alpha);
        g.setForegroundColor(color);
        g.drawRectangle(r);
        g.setAlpha(oldAlpha);
    }

    protected void paintIntervalOuterBorder(ITimelineInterval interval, Graphics g, Rectangle clip, Color color, int alpha) {
        int oldAlpha = g.getAlpha();
        g.setAlpha(alpha);
        g.setForegroundColor(color);
        if (interval instanceof TimelineIntervalEnvironment) {
            this.paintOuterBorderEnvSymbol((TimelineIntervalEnvironment)interval, g, clip);
        } else if (!(interval instanceof TimelineIntervalNvlink)) {
            this.paintOuterBorderNormal(interval, g, clip);
        }
        g.setAlpha(oldAlpha);
    }

    private void paintFigureInternal(Graphics g, int numRows, Rectangle[] rowBounds, Set<ITimelineInterval> highlighted, TimelineHighlightingStrategy highlightStrategy) {
        if (this.model.rwl.readLock().tryLock()) {
            int row = 0;
            while (row < numRows) {
                Set<ITimelineInterval> intervals = this.model.getIntervalsToDraw(row);
                for (ITimelineInterval interval : intervals) {
                    if (highlighted != null && highlighted.contains(interval)) continue;
                    int alpha = this.model.getIntervalAlpha(interval);
                    ViperColors.GradientColors colors = this.model.getIntervalColors(interval);
                    this.paintInterval(interval, g, rowBounds[row], ViperColors.INTERVAL_TEXT_FGCOLOR, colors, alpha);
                }
                ++row;
            }
            for (ITimelineInterval interval : highlighted) {
                int row2 = this.model.getRowNum(interval);
                int alpha = this.model.getIntervalAlpha(interval);
                this.paintInterval(interval, g, rowBounds[row2], ViperColors.INTERVAL_HILITE_TEXT_FGCOLOR, highlightStrategy.getHighlightColor(interval), alpha);
                this.paintIntervalOuterBorder(interval, g, rowBounds[row2], ViperColors.INTERVAL_SELECTED_COLOR, alpha);
            }
            this.model.rwl.readLock().unlock();
        }
    }

    public void paintFigure(Graphics g) {
        if (this.minIntervalTextWidth == -1 || this.minIntervalTextHeight == -1 || !this.getFont().equals((Object)this.getLocalFont())) {
            this.setFont(this.getFont());
            this.minIntervalTextWidth = FigureUtilities.getFontMetrics((Font)this.getLocalFont()).getAverageCharWidth() * 4;
            this.minIntervalTextHeight = this.model instanceof TimelineDevice ? Integer.MAX_VALUE : FigureUtilities.getFontMetrics((Font)this.getLocalFont()).getHeight() - 2;
        }
        Rectangle drawArea = this.getClientArea();
        int numRows = this.model.getNumIntervalRows();
        int rowHeight = TimelineFigure.getScaledValue(this.model.getIntervalRowHeight());
        int rowInnerMargin = TimelineFigure.getScaledValue(this.model.getIntervalRowInnerMargin());
        int timelineMargin = TimelineFigure.getScaledValue(this.model.getTimelineOuterMargin());
        Rectangle[] rowBounds = new Rectangle[numRows];
        int i = 0;
        while (i < numRows) {
            rowBounds[i] = new Rectangle(drawArea.x, drawArea.y + timelineMargin + (rowHeight + rowInnerMargin) * i, drawArea.width, rowHeight);
            ++i;
        }
        if (this.isSelected) {
            g.setBackgroundColor(ViperColors.TIMELINE_SELECTED_COLOR);
            g.fillRectangle(drawArea);
            int originalWidth = g.getLineWidth();
            if (timelineMargin > originalWidth) {
                g.setLineWidth(timelineMargin);
            }
            g.setBackgroundColor(this.getBackgroundColor());
            g.fillRectangle(drawArea.getExpanded(0, -timelineMargin));
            if (timelineMargin > originalWidth) {
                g.setLineWidth(originalWidth);
            }
        } else {
            g.setBackgroundColor(this.getBackgroundColor());
            g.fillRectangle(drawArea);
        }
        if (this.model instanceof TimelineNvlink) {
            Font oldFont = g.getFont();
            Font font = new Font((Device)Display.getCurrent(), "Monospace", 8, 1);
            g.setFont(font);
            TimelineNvlink nvlinkTimeline = (TimelineNvlink)this.model;
            if (nvlinkTimeline.getMaxValue() != null) {
                int xPosition = this.model.getSession().getXPosition();
                g.drawText(new BandwidthFormatter(ByteSizeFormatter.Base.KILOBYTE).format(nvlinkTimeline.getMaxValue()), xPosition, rowBounds[0].y);
                g.drawText("0", xPosition, rowBounds[0].y + rowHeight + timelineMargin - g.getFontMetrics().getHeight());
                g.setFont(oldFont);
            }
        }
        TimelineHighlightingStrategy highlightStrategy = null;
        highlightStrategy = this.model.getSession().isShowDependencies() ? new DependencyHighlightingStrategy(this.model.getSession()) : new TimelineHighlightingStrategy();
        this.paintFigureInternal(g, numRows, rowBounds, this.highlightIntervals, highlightStrategy);
    }

    public static int getScaledTimelineHeight(Timeline timeline) {
        int numRows = timeline.getNumIntervalRows();
        int rowHeight = TimelineFigure.getScaledValue(timeline.getIntervalRowHeight());
        int innerMargin = TimelineFigure.getScaledValue(timeline.getIntervalRowInnerMargin());
        int outerMargin = TimelineFigure.getScaledValue(timeline.getTimelineOuterMargin());
        int height = numRows * (rowHeight + innerMargin) - innerMargin;
        return height + 2 * outerMargin;
    }

    public static int getScaledValue(int height) {
        if (systemFontHeight == Integer.MIN_VALUE) {
            int h;
            Display current = Display.getCurrent();
            if (current == null) {
                throw new IllegalStateException("Should be called from the SWT thread");
            }
            Font font = current.getSystemFont();
            systemFontHeight = h = FigureUtilities.getFontMetrics((Font)font).getHeight();
        }
        return Math.max(height * systemFontHeight / 16, height);
    }
}

