/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.navigator;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.NavigatorSafeRunnable;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.CommonViewerSiteFactory;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.navigator.IDescriptionProvider;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.NavigatorActionService;
import org.eclipse.ui.progress.UIJob;

public final class CommonNavigatorManager
implements ISelectionChangedListener {
    private final CommonNavigator commonNavigator;
    private final INavigatorContentService contentService;
    private NavigatorActionService actionService;
    private final IDescriptionProvider commonDescriptionProvider;
    private final IStatusLineManager statusLineManager;
    private final ILabelProvider labelProvider;
    private UpdateActionBarsJob updateActionBars;
    private ISelectionChangedListener statusBarListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent anEvent) {
            CommonNavigatorManager.this.updateStatusBar(anEvent.getSelection());
        }
    };

    public CommonNavigatorManager(CommonNavigator aNavigator) {
        this(aNavigator, null);
    }

    public CommonNavigatorManager(CommonNavigator aNavigator, IMemento aMemento) {
        this.commonNavigator = aNavigator;
        this.contentService = this.commonNavigator.getNavigatorContentService();
        this.statusLineManager = this.commonNavigator.getViewSite().getActionBars().getStatusLineManager();
        this.commonDescriptionProvider = this.contentService.createCommonDescriptionProvider();
        this.labelProvider = (ILabelProvider)this.commonNavigator.getCommonViewer().getLabelProvider();
        this.init(aMemento);
    }

    private void init(IMemento memento) {
        this.updateActionBars = new UpdateActionBarsJob(this.commonNavigator.getTitle());
        CommonViewer commonViewer = this.commonNavigator.getCommonViewer();
        commonViewer.addSelectionChangedListener(this);
        commonViewer.addPostSelectionChangedListener(this.statusBarListener);
        this.updateStatusBar(commonViewer.getSelection());
        ICommonViewerWorkbenchSite commonViewerSite = CommonViewerSiteFactory.createCommonViewerSite(this.commonNavigator.getViewSite());
        this.actionService = new NavigatorActionService(commonViewerSite, (StructuredViewer)commonViewer, commonViewer.getNavigatorContentService());
        final RetargetAction openAction = new RetargetAction("org.eclipse.ui.navigator.Open", CommonNavigatorMessages.Open_action_label);
        this.commonNavigator.getViewSite().getPage().addPartListener((IPartListener)openAction);
        openAction.setActionDefinitionId("org.eclipse.ui.navigator.Open");
        new OpenAndLinkWithEditorHelper((StructuredViewer)this.commonNavigator.getCommonViewer()){

            protected void activate(ISelection selection) {
                int currentMode = OpenStrategy.getOpenMethod();
                try {
                    OpenStrategy.setOpenMethod((int)0);
                    CommonNavigatorManager.this.actionService.setContext(new ActionContext(CommonNavigatorManager.this.commonNavigator.getCommonViewer().getSelection()));
                    CommonNavigatorManager.this.actionService.fillActionBars(CommonNavigatorManager.this.commonNavigator.getViewSite().getActionBars());
                    openAction.run();
                }
                finally {
                    OpenStrategy.setOpenMethod((int)currentMode);
                }
            }

            protected void linkToEditor(ISelection selection) {
            }

            protected void open(ISelection selection, boolean activate) {
                CommonNavigatorManager.this.actionService.setContext(new ActionContext(CommonNavigatorManager.this.commonNavigator.getCommonViewer().getSelection()));
                CommonNavigatorManager.this.actionService.fillActionBars(CommonNavigatorManager.this.commonNavigator.getViewSite().getActionBars());
                openAction.run();
            }
        };
        if (memento != null) {
            this.restoreState(memento);
        }
        this.initContextMenu();
        this.initViewMenu();
    }

    public void dispose() {
        this.commonNavigator.getCommonViewer().removeSelectionChangedListener(this);
        this.commonNavigator.getCommonViewer().removeSelectionChangedListener(this.statusBarListener);
        this.actionService.dispose();
    }

    public void selectionChanged(SelectionChangedEvent anEvent) {
        if (anEvent.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)anEvent.getSelection();
            this.actionService.setContext(new ActionContext((ISelection)structuredSelection));
            this.actionService.fillActionBars(this.commonNavigator.getViewSite().getActionBars());
        }
    }

    public void restoreState(IMemento aMemento) {
        this.actionService.restoreState(aMemento);
    }

    public void saveState(IMemento aMemento) {
        this.actionService.saveState(aMemento);
    }

    protected void fillContextMenu(IMenuManager aMenuManager) {
        ISelection selection = this.commonNavigator.getCommonViewer().getSelection();
        this.actionService.setContext(new ActionContext(selection));
        this.actionService.fillContextMenu(aMenuManager);
    }

    protected void initContextMenu() {
        MenuManager menuMgr = new MenuManager(this.contentService.getViewerDescriptor().getPopupMenuId());
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CommonNavigatorManager.this.fillContextMenu(manager);
            }
        });
        CommonViewer commonViewer = this.commonNavigator.getCommonViewer();
        Menu menu = menuMgr.createContextMenu((Control)commonViewer.getTree());
        commonViewer.getTree().setMenu(menu);
        this.actionService.prepareMenuForPlatformContributions(menuMgr, (ISelectionProvider)commonViewer, false);
    }

    protected void initViewMenu() {
        IMenuManager viewMenu = this.commonNavigator.getViewSite().getActionBars().getMenuManager();
        viewMenu.add((IContributionItem)new Separator("additions"));
        viewMenu.add((IContributionItem)new Separator("additions-end"));
        this.updateActionBars.schedule(100L);
    }

    protected void updateStatusBar(ISelection aSelection) {
        Image img = null;
        if (aSelection != null && !aSelection.isEmpty() && aSelection instanceof IStructuredSelection) {
            img = this.labelProvider.getImage(((IStructuredSelection)aSelection).getFirstElement());
        }
        this.statusLineManager.setMessage(img, this.commonDescriptionProvider.getDescription(aSelection));
    }

    public NavigatorActionService getNavigatorActionService() {
        return this.actionService;
    }

    private class UpdateActionBarsJob
    extends UIJob {
        public UpdateActionBarsJob(String label) {
            super(label);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(this){
                final /* synthetic */ UpdateActionBarsJob this$1;
                {
                    this.this$1 = updateActionBarsJob;
                }

                public void run() throws Exception {
                    if (CommonNavigatorManager.access$0(UpdateActionBarsJob.access$0(this.this$1)).getCommonViewer().getInput() != null) {
                        StructuredSelection selection = new StructuredSelection(CommonNavigatorManager.access$0(UpdateActionBarsJob.access$0(this.this$1)).getCommonViewer().getInput());
                        CommonNavigatorManager.access$1(UpdateActionBarsJob.access$0(this.this$1)).setContext(new ActionContext((ISelection)selection));
                        CommonNavigatorManager.access$1(UpdateActionBarsJob.access$0(this.this$1)).fillActionBars(CommonNavigatorManager.access$0(UpdateActionBarsJob.access$0(this.this$1)).getViewSite().getActionBars());
                    }
                }
            });
            return Status.OK_STATUS;
        }

        static /* synthetic */ CommonNavigatorManager access$0(UpdateActionBarsJob updateActionBarsJob) {
            return updateActionBarsJob.CommonNavigatorManager.this;
        }
    }
}

