/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.expertsystem;

import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.expertsystem.BaseStage;
import com.nvidia.viper.expertsystem.BoundsStage;
import com.nvidia.viper.expertsystem.ComputeStage;
import com.nvidia.viper.expertsystem.ExpertSystemStepAction;
import com.nvidia.viper.expertsystem.IExpertSystemStage;
import com.nvidia.viper.expertsystem.LatencyStage;
import com.nvidia.viper.expertsystem.MemoryStage;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.ExpertSystem;
import com.nvidia.viper.model.Session;
import java.util.List;

public abstract class KernelInstanceStage
extends BaseStage
implements IExpertSystemStage {
    protected String stageDesc;
    protected int numSteps;
    protected String[] stepTitles;
    protected String[] stepDescs;
    protected ExpertSystemStepAction[] stepActions;

    public KernelInstanceStage(ExpertSystem expertSystem) {
        super(expertSystem);
        this.updateAndPerformActions();
    }

    @Override
    public String getDescription(ResultOutput otpt) {
        return this.stageDesc.replace("%RLOC%", ResultOutput.REPORT.equals((Object)otpt) ? "below" : "at right");
    }

    @Override
    public int getNumSteps() {
        return this.numSteps;
    }

    @Override
    public String getStepTitle(int stepIdx) {
        if (stepIdx < this.numSteps) {
            return this.stepTitles[stepIdx];
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public String getStepDescription(int stepIdx) throws IndexOutOfBoundsException {
        if (stepIdx < this.numSteps) {
            return this.stepDescs[stepIdx];
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public ExpertSystemStepAction getStepAction(int stepIdx) {
        if (stepIdx < this.numSteps) {
            return this.stepActions[stepIdx];
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean propertyChange(String propertyName) {
        if (("session:sInterval".equals(propertyName) || "session:analysis".equals(propertyName)) && this.getExpertSystem() != null) {
            this.updateAndPerformActions();
            return true;
        }
        return false;
    }

    @Override
    public boolean canPerformStep(int stepIdx) {
        if (this.stepTitles != null && this.stepTitles.length > stepIdx && this.stepTitles[stepIdx].equals(ViperMessages.ExpertSystem_StepRerun_Title)) {
            Executable exe = this.getExpertSystem().getSession().getExecutable();
            return exe != null;
        }
        return super.canPerformStep(stepIdx);
    }

    public AnalysisResult getKernelResult(AnalysisStage stage, Class<? extends AnalysisResult> cls) {
        List<AnalysisResult> results;
        Session session;
        if (this.getExpertSystem() != null && this.getExpertSystem().getSession() != null && (session = this.getExpertSystem().getSession()).getAnalysis() != null && (results = session.getAnalysis().getAnalysisResults(stage, cls)).size() == 1) {
            return results.get(0);
        }
        return null;
    }

    public AnalysisResult getKernelResult(AnalysisStage stage, Class<? extends AnalysisResult> cls, AnalysisDescriptor desc) {
        AnalysisResult result;
        List<AnalysisResult> results;
        Session session;
        if (this.getExpertSystem() != null && this.getExpertSystem().getSession() != null && (session = this.getExpertSystem().getSession()).getAnalysis() != null && (results = session.getAnalysis().getAnalysisResults(stage, cls)).size() == 1 && (result = results.get(0)).getDescriptor().equals((Object)desc)) {
            return results.get(0);
        }
        return null;
    }

    private void updateAndPerformActions() {
        ExpertSystemStepAction updateActions = this.update();
        if (updateActions != null && this.getExpertSystem() != null && this.getExpertSystem().getSession() != null) {
            updateActions.perform(this.getExpertSystem().getSession());
        }
    }

    public static ExpertSystemStepAction getAnalysisRunAction(boolean force) {
        ExpertSystemStepAction boundsAction = BoundsStage.getAnalysisRunAction(force);
        ExpertSystemStepAction computeAction = ComputeStage.getAnalysisRunAction(force);
        ExpertSystemStepAction memoryAction = MemoryStage.getAnalysisRunAction(force);
        ExpertSystemStepAction latencyAction = LatencyStage.getAnalysisRunAction(force);
        ExpertSystemStepAction action = new ExpertSystemStepAction(boundsAction, computeAction, memoryAction, latencyAction);
        action.flatten(true);
        return action;
    }
}

