/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.editor.SourceSassEditor;
import com.nvidia.viper.ui.ContextManager;
import com.nvidia.viper.ui.SessionEditor;
import com.nvidia.viper.ui.TimelinePropertyComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class TimelinePropertyView
extends ViewPart {
    private ActivePartListener asListener = new ActivePartListener();
    private TimelinePropertyComposite timelineProperties;

    public void createPartControl(Composite parent) {
        this.timelineProperties = new TimelinePropertyComposite(parent, 0);
        this.handleNewActivePart((IWorkbenchPart)ContextManager.getSingleton().getActiveSessionEditor());
        ViperHelp.setContextHelp((Control)parent, ViperHelp.PROPERTY_VIEW_CONTEXT_ID);
    }

    protected void handleNewActivePart(IWorkbenchPart part) {
        if (part instanceof SessionEditor) {
            this.timelineProperties.setSession(((SessionEditor)part).getSession());
        } else if (part instanceof SourceSassEditor) {
            this.timelineProperties.setSession(((SourceSassEditor)part).getSession());
        }
    }

    protected void handleClosedPart(IWorkbenchPart part) {
        if (part instanceof SessionEditor && this.timelineProperties.getSession() == ((SessionEditor)part).getSession()) {
            this.timelineProperties.setSession(null);
        }
    }

    public void setFocus() {
        if (this.timelineProperties != null) {
            this.timelineProperties.setFocus();
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this.asListener);
        ContextManager.getSingleton().addIdempotent((IWorkbenchPart)this);
    }

    public void dispose() {
        super.dispose();
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this.asListener);
        ContextManager.getSingleton().removeIdempotent((IWorkbenchPart)this);
    }

    private class ActivePartListener
    implements IPartListener {
        private ActivePartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            TimelinePropertyView.this.handleNewActivePart(part);
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            TimelinePropertyView.this.handleNewActivePart(part);
        }

        public void partOpened(IWorkbenchPart part) {
            TimelinePropertyView.this.handleNewActivePart(part);
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            TimelinePropertyView.this.handleClosedPart(part);
        }
    }
}

