/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIList;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.debug.core.model.MemoryByte;

public class MIDataReadMemoryBytesInfo
extends MIInfo {
    private static final int DEFAULT_WORD_SIZE = 1;
    private MemoryByte[] fBlock = null;

    public MIDataReadMemoryBytesInfo(MIOutput output, int size) {
        this(output, size, 1);
    }

    public MIDataReadMemoryBytesInfo(MIOutput output, int count, int word_size) {
        super(output);
        this.parse(count, word_size);
    }

    public MemoryByte[] getMIMemoryBlock() {
        return this.fBlock;
    }

    private void parse(int count, int word_size) {
        this.fBlock = new MemoryByte[count * word_size];
        int i = 0;
        while (i < this.fBlock.length) {
            this.fBlock[i] = new MemoryByte(0, 0);
            ++i;
        }
        MIResult[] results = this.getMIOutput().getMIResultRecord().getMIResults();
        int i2 = 0;
        while (i2 < results.length) {
            if (results[i2].getVariable().equals("memory")) {
                MIList v = (MIList)results[i2].getMIValue();
                try {
                    int j = 0;
                    while (j < v.getMIValues().length) {
                        MITuple b = (MITuple)v.getMIValues()[j];
                        int offset = 0;
                        String contents = "";
                        int k = 0;
                        while (k < b.getMIResults().length) {
                            MIResult r = b.getMIResults()[k];
                            if (r.getVariable().equals("offset")) {
                                String offset_s = ((MIConst)r.getMIValue()).getCString();
                                offset = Integer.decode(offset_s);
                            } else if (r.getVariable().equals("contents")) {
                                contents = ((MIConst)r.getMIValue()).getCString();
                            }
                            ++k;
                        }
                        if (offset * word_size + contents.length() / 2 <= count * word_size) {
                            k = 0;
                            while (k < contents.length() / 2) {
                                this.fBlock[offset * word_size + k] = new MemoryByte((byte)Integer.parseInt(contents.substring(k * 2, k * 2 + 2), 16));
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++i2;
        }
    }
}

