/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.shells;

import java.io.PrintWriter;

public class TerminalServiceShellWriterThread
extends Thread {
    private PrintWriter fOutputWriter;
    private String fNextCommand;
    private volatile boolean fIsCancelled;

    public TerminalServiceShellWriterThread(PrintWriter outputWriter) {
        this.fOutputWriter = outputWriter;
        this.setName("Terminal Service ShellWriter" + this.getName());
        this.start();
    }

    public synchronized boolean isDone() {
        return this.fIsCancelled;
    }

    public synchronized void stopThread() {
        this.fIsCancelled = true;
        this.notifyAll();
    }

    public synchronized boolean sendCommand(String command) {
        try {
            while (!this.fIsCancelled && this.fNextCommand != null) {
                this.wait();
            }
            if (!this.fIsCancelled) {
                this.fNextCommand = command;
                this.notifyAll();
                while (!this.fIsCancelled && this.fNextCommand != null) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            this.stopThread();
        }
        return !this.fIsCancelled;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        try {
            try {
                block5: while (!this.fIsCancelled) {
                    while (true) {
                        if (this.fNextCommand != null || this.fIsCancelled) {
                            if (this.fIsCancelled) continue block5;
                            this.fOutputWriter.println(this.fNextCommand);
                            this.fNextCommand = null;
                            this.notifyAll();
                            if (!this.fOutputWriter.checkError()) continue block5;
                            this.stopThread();
                            continue block5;
                        }
                        this.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.stopThread();
            this.fOutputWriter.close();
            this.fOutputWriter = null;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.stopThread();
            this.fOutputWriter.close();
            this.fOutputWriter = null;
            return;
        }
    }
}

