/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.debug.core.ICDIDebugger;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;

public class GDBCDIDebugger
implements ICDIDebugger {
    ILaunch fLaunch;

    public ICDISession createDebuggerSession(ILaunch launch, IBinaryParser.IBinaryObject exe, IProgressMonitor monitor) throws CoreException {
        this.fLaunch = launch;
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        Session dsession = null;
        String debugMode = config.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (debugMode.equals("run")) {
            dsession = this.createLaunchSession(config, exe, monitor);
        } else if (debugMode.equals("attach")) {
            dsession = this.createAttachSession(config, exe, monitor);
        } else if (debugMode.equals("core")) {
            dsession = this.createCoreSession(config, exe, monitor);
        }
        if (dsession != null) {
            ICDITarget[] dtargets = dsession.getTargets();
            int i = 0;
            while (i < dtargets.length) {
                Process debugger = dsession.getSessionProcess(dtargets[i]);
                if (debugger != null) {
                    IProcess debuggerProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)debugger, (String)this.renderDebuggerProcessLabel(config));
                    launch.addProcess(debuggerProcess);
                }
                ++i;
            }
        }
        return dsession;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Session createLaunchSession(ILaunchConfiguration config, IBinaryParser.IBinaryObject exe, IProgressMonitor monitor) throws CoreException {
        Session session;
        Session session2 = null;
        boolean failed = false;
        try {
            String gdb = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
            String miVersion = this.getMIVersion(config);
            boolean usePty = config.getAttribute("org.eclipse.cdt.launch.use_terminal", true);
            File cwd = GDBCDIDebugger.getProjectPath(config).toFile();
            String gdbinit = config.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
            session2 = usePty ? MIPlugin.getDefault().createCSession(gdb, miVersion, exe.getPath().toFile(), cwd, gdbinit, monitor) : MIPlugin.getDefault().createCSession(gdb, miVersion, exe.getPath().toFile(), cwd, gdbinit, null, monitor);
            this.initializeLibraries(config, session2);
            session = session2;
            if (!failed) return session;
            if (session2 == null) return session;
        }
        catch (Exception e) {
            try {
                failed = true;
                if (!(e instanceof CoreException)) throw this.newCoreException(e);
                throw (CoreException)((Object)e);
            }
            catch (Throwable throwable) {
                if (!failed) throw throwable;
                if (session2 == null) throw throwable;
                try {
                    session2.terminate();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            session2.terminate();
            return session;
        }
        catch (Exception exception) {}
        return session;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Session createAttachSession(ILaunchConfiguration config, IBinaryParser.IBinaryObject exe, IProgressMonitor monitor) throws CoreException {
        Session session;
        Session session2 = null;
        boolean failed = false;
        try {
            String gdb = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
            String miVersion = this.getMIVersion(config);
            int pid = config.getAttribute("org.eclipse.cdt.launch.ATTACH_PROCESS_ID", -1);
            File cwd = GDBCDIDebugger.getProjectPath(config).toFile();
            String gdbinit = config.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
            File exeFile = exe != null ? exe.getPath().toFile() : null;
            session2 = MIPlugin.getDefault().createCSession(gdb, miVersion, exeFile, pid, null, cwd, gdbinit, monitor);
            this.initializeLibraries(config, session2);
            session = session2;
            if (!failed) return session;
            if (session2 == null) return session;
        }
        catch (Exception e) {
            try {
                failed = true;
                if (!(e instanceof CoreException)) throw this.newCoreException(e);
                throw (CoreException)((Object)e);
            }
            catch (Throwable throwable) {
                if (!failed) throw throwable;
                if (session2 == null) throw throwable;
                try {
                    session2.terminate();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            session2.terminate();
            return session;
        }
        catch (Exception exception) {}
        return session;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Session createCoreSession(ILaunchConfiguration config, IBinaryParser.IBinaryObject exe, IProgressMonitor monitor) throws CoreException {
        Session session;
        Session session2 = null;
        boolean failed = false;
        try {
            String gdb = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
            String miVersion = this.getMIVersion(config);
            File cwd = GDBCDIDebugger.getProjectPath(config).toFile();
            Path coreFile = new Path(config.getAttribute("org.eclipse.cdt.launch.COREFILE_PATH", null));
            String gdbinit = config.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
            session2 = MIPlugin.getDefault().createCSession(gdb, miVersion, exe.getPath().toFile(), coreFile.toFile(), cwd, gdbinit, monitor);
            this.initializeLibraries(config, session2);
            session2.getSharedLibraryManager().update();
            session = session2;
            if (!failed) return session;
            if (session2 == null) return session;
        }
        catch (Exception e) {
            try {
                failed = true;
                if (!(e instanceof CoreException)) throw this.newCoreException(e);
                throw (CoreException)((Object)e);
            }
            catch (Throwable throwable) {
                if (!failed) throw throwable;
                if (session2 == null) throw throwable;
                try {
                    session2.terminate();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            session2.terminate();
            return session;
        }
        catch (Exception exception) {}
        return session;
    }

    protected void initializeLibraries(ILaunchConfiguration config, Session session) throws CoreException {
        try {
            SharedLibraryManager sharedMgr = session.getSharedLibraryManager();
            boolean autolib = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_AUTO_SOLIB, true);
            boolean stopOnSolibEvents = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_STOP_ON_SOLIB_EVENTS, false);
            List p = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, Collections.EMPTY_LIST);
            ICDITarget[] dtargets = session.getTargets();
            int i = 0;
            while (i < dtargets.length) {
                Target target = (Target)dtargets[i];
                try {
                    sharedMgr.setAutoLoadSymbols(target, autolib);
                    sharedMgr.setStopOnSolibEvents(target, stopOnSolibEvents);
                    if (autolib && !stopOnSolibEvents) {
                        sharedMgr.setStopOnSolibEvents(target, true);
                        sharedMgr.setDeferredBreakpoint(target, true);
                    }
                }
                catch (CDIException cDIException) {}
                if (p.size() > 0) {
                    String[] oldPaths = sharedMgr.getSharedLibraryPaths(target);
                    String[] paths = new String[oldPaths.length + p.size()];
                    System.arraycopy(p.toArray(new String[p.size()]), 0, paths, 0, p.size());
                    System.arraycopy(oldPaths, 0, paths, p.size(), oldPaths.length);
                    sharedMgr.setSharedLibraryPaths(target, paths);
                }
                ++i;
            }
        }
        catch (CDIException e) {
            throw this.newCoreException(String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_initializing_shared_lib_options")) + e.getMessage(), e);
        }
    }

    public static IPath getProjectPath(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        IPath p;
        String projectName = GDBCDIDebugger.getProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0 && (p = (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).getLocation()) != null) {
            return p;
        }
        return Path.EMPTY;
    }

    public static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
    }

    protected ILaunch getLauch() {
        return this.fLaunch;
    }

    protected String renderDebuggerProcessLabel(ILaunchConfiguration config) {
        String format = "{0} ({1})";
        String timestamp = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        String label = MIPlugin.getResourceString("src.GDBDebugger.Debugger_process");
        try {
            label = config.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
        }
        catch (CoreException coreException) {}
        return MessageFormat.format((String)format, (Object[])new String[]{label, timestamp});
    }

    protected CoreException newCoreException(Throwable exception) {
        String message = String.valueOf(MIPlugin.getResourceString("src.GDBDebugger.Error_creating_session")) + exception.getMessage();
        int code = 150;
        String ID = MIPlugin.getUniqueIdentifier();
        String exMessage = exception == null || exception.getLocalizedMessage() == null ? new String() : exception.getLocalizedMessage();
        MultiStatus status = new MultiStatus(ID, code, message, exception);
        status.add((IStatus)new Status(4, ID, code, exMessage, exception));
        return new CoreException((IStatus)status);
    }

    protected CoreException newCoreException(String message, Throwable exception) {
        int code = 150;
        String ID = MIPlugin.getUniqueIdentifier();
        String exMessage = exception == null || exception.getLocalizedMessage() == null ? new String() : exception.getLocalizedMessage();
        MultiStatus status = new MultiStatus(ID, code, message, exception);
        status.add((IStatus)new Status(4, ID, code, exMessage, exception));
        return new CoreException((IStatus)status);
    }

    protected String getMIVersion(ILaunchConfiguration config) {
        return MIPlugin.getMIVersion(config);
    }
}

