/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dnd;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.ITextEditorExtension;

public class TextViewerDragAdapter
extends DragSourceAdapter {
    public static final String DRAG_SELECTION_CATEGORY = "dragSelectionCategory";
    private IPositionUpdater fPositionUpdater;
    private Position fSelectionPosition;
    private ITextViewer fViewer;
    private ITextEditorExtension fEditor;
    private boolean fIsEnabled = true;

    public TextViewerDragAdapter(ITextViewer viewer) {
        this(viewer, null);
    }

    public TextViewerDragAdapter(ITextViewer viewer, ITextEditorExtension editor) {
        this.fViewer = viewer;
        this.fEditor = editor;
    }

    public void dragFinished(DragSourceEvent event) {
        IDocument doc = this.fViewer.getDocument();
        try {
            doc.removePositionCategory(DRAG_SELECTION_CATEGORY);
            doc.removePositionUpdater(this.fPositionUpdater);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        if (event.doit && event.detail == 2 && this.isDocumentEditable()) {
            try {
                doc.replace(this.fSelectionPosition.offset, this.fSelectionPosition.length, null);
            }
            catch (BadLocationException badLocationException) {}
        }
        if (this.fViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)this.fViewer).getRewriteTarget().endCompoundChange();
        }
    }

    public void dragSetData(DragSourceEvent event) {
        IDocument doc = this.fViewer.getDocument();
        try {
            event.data = doc.get(this.fSelectionPosition.offset, this.fSelectionPosition.length);
        }
        catch (BadLocationException badLocationException) {
            event.detail = 0;
            event.doit = false;
        }
    }

    public void dragStart(DragSourceEvent event) {
        if (!this.fIsEnabled) {
            event.doit = false;
            return;
        }
        int offset = this.getOffsetAtLocation(event.x, event.y, false);
        offset = this.getDocumentOffset(offset);
        Point selection = this.fViewer.getSelectedRange();
        if (selection != null && offset >= selection.x && offset < selection.x + selection.y) {
            this.fSelectionPosition = new Position(selection.x, selection.y);
            if (this.fViewer instanceof ITextViewerExtension) {
                ((ITextViewerExtension)this.fViewer).getRewriteTarget().beginCompoundChange();
            }
            IDocument doc = this.fViewer.getDocument();
            try {
                doc.addPositionCategory(DRAG_SELECTION_CATEGORY);
                this.fPositionUpdater = new DefaultPositionUpdater(DRAG_SELECTION_CATEGORY);
                doc.addPositionUpdater(this.fPositionUpdater);
                doc.addPosition(DRAG_SELECTION_CATEGORY, this.fSelectionPosition);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            event.doit = true;
            event.detail = 1;
            if (this.isDocumentEditable()) {
                event.detail |= 2;
            }
        } else {
            event.doit = false;
            event.detail = 0;
        }
    }

    private int getOffsetAtLocation(int x, int y, boolean absolute) {
        StyledText textWidget = this.fViewer.getTextWidget();
        StyledTextContent content = textWidget.getContent();
        Point location = absolute ? textWidget.toControl(x, y) : new Point(x, y);
        int line = (textWidget.getTopPixel() + location.y) / textWidget.getLineHeight();
        if (line >= content.getLineCount()) {
            return content.getCharCount();
        }
        int lineOffset = content.getOffsetAtLine(line);
        String lineText = content.getLine(line);
        Point endOfLine = textWidget.getLocationAtOffset(lineOffset + lineText.length());
        if (location.x >= endOfLine.x) {
            return lineOffset + lineText.length();
        }
        try {
            return textWidget.getOffsetAtLocation(location);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1;
        }
    }

    private int getDocumentOffset(int widgetOffset) {
        if (this.fViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fViewer;
            return extension.widgetOffset2ModelOffset(widgetOffset);
        }
        IRegion visible = this.fViewer.getVisibleRegion();
        if (widgetOffset > visible.getLength()) {
            return -1;
        }
        return widgetOffset + visible.getOffset();
    }

    private boolean isDocumentEditable() {
        if (this.fEditor != null) {
            return !this.fEditor.isEditorInputReadOnly();
        }
        return this.fViewer.isEditable();
    }

    public void setEnabled(boolean enabled) {
        this.fIsEnabled = enabled;
    }
}

